/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings;

import com.minecolonies.coremod.achievements.ModAchievements;
import com.minecolonies.coremod.colony.CitizenData;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingWorker;
import com.minecolonies.coremod.colony.buildings.utils.BuildingBuilderResource;
import com.minecolonies.coremod.colony.jobs.AbstractJob;
import com.minecolonies.coremod.colony.jobs.JobBuilder;
import com.minecolonies.coremod.entity.EntityCitizen;
import com.minecolonies.coremod.inventory.InventoryCitizen;
import com.minecolonies.coremod.tileentities.TileEntityColonyBuilding;
import com.minecolonies.coremod.util.InventoryUtils;
import com.minecolonies.coremod.util.Utils;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BuildingBuilder
extends AbstractBuildingWorker {
    public static final int MAX_BUILDING_LEVEL = 5;
    private static final String BUILDER = "Builder";
    private static final String TAG_RESOURCE_LIST = "resourcesItem";
    private HashMap<String, BuildingBuilderResource> neededResources = new HashMap();

    public BuildingBuilder(Colony c, BlockPos l) {
        super(c, l);
    }

    @Override
    @NotNull
    public String getSchematicName() {
        return BUILDER;
    }

    @Override
    public int getMaxBuildingLevel() {
        return 5;
    }

    @Override
    public void onUpgradeComplete(int newLevel) {
        super.onUpgradeComplete(newLevel);
        if (newLevel == 1) {
            this.getColony().triggerAchievement(ModAchievements.achievementBuildingBuilder);
        }
        if (newLevel >= this.getMaxBuildingLevel()) {
            this.getColony().triggerAchievement(ModAchievements.achievementUpgradeBuilderMax);
        }
    }

    @Override
    @NotNull
    public String getJobName() {
        return BUILDER;
    }

    @Override
    @NotNull
    public AbstractJob createJob(CitizenData citizen) {
        return new JobBuilder(citizen);
    }

    @Override
    public void readFromNBT(@NotNull NBTTagCompound compound) {
        super.readFromNBT(compound);
        NBTTagList neededResTagList = compound.getTagList(TAG_RESOURCE_LIST, 10);
        for (int i = 0; i < neededResTagList.tagCount(); ++i) {
            NBTTagCompound neededRes = neededResTagList.getCompoundTagAt(i);
            ItemStack stack = ItemStack.loadItemStackFromNBT((NBTTagCompound)neededRes);
            BuildingBuilderResource resource = new BuildingBuilderResource(stack.getItem(), stack.getItemDamage(), stack.stackSize);
            this.neededResources.put(stack.getUnlocalizedName(), resource);
        }
    }

    @Override
    public void writeToNBT(@NotNull NBTTagCompound compound) {
        super.writeToNBT(compound);
        NBTTagList neededResTagList = new NBTTagList();
        for (BuildingBuilderResource resource : this.neededResources.values()) {
            NBTTagCompound neededRes = new NBTTagCompound();
            ItemStack itemStack = new ItemStack(resource.getItem(), resource.getAmount(), resource.getDamageValue());
            itemStack.writeToNBT(neededRes);
            neededResTagList.appendTag((NBTBase)neededRes);
        }
        compound.setTag(TAG_RESOURCE_LIST, (NBTBase)neededResTagList);
    }

    @Override
    public void serializeToView(@NotNull ByteBuf buf) {
        super.serializeToView(buf);
        this.updateAvailableResources();
        buf.writeInt(this.neededResources.size());
        for (Map.Entry<String, BuildingBuilderResource> entry : this.neededResources.entrySet()) {
            BuildingBuilderResource resource = this.neededResources.get(entry.getKey());
            int itemId = Item.getIdFromItem((Item)resource.getItem());
            int damage = resource.getDamageValue();
            buf.writeInt(itemId);
            buf.writeInt(damage);
            buf.writeInt(resource.getAvailable());
            buf.writeInt(resource.getAmount());
        }
    }

    public Map<String, BuildingBuilderResource> getNeededResources() {
        return new HashMap<String, BuildingBuilderResource>(this.neededResources);
    }

    public void addNeededResource(@Nullable ItemStack res, int amount) {
        if (res == null || res.getItem() == null || res.stackSize == 0 || amount == 0) {
            return;
        }
        BuildingBuilderResource resource = this.neededResources.get(res.getUnlocalizedName());
        if (resource == null) {
            resource = new BuildingBuilderResource(res.getItem(), res.getItemDamage(), amount);
        } else {
            resource.setAmount(resource.getAmount() + amount);
        }
        this.neededResources.put(res.getUnlocalizedName(), resource);
        this.markDirty();
    }

    @Override
    public boolean neededForWorker(@Nullable ItemStack stack) {
        return Utils.isMiningTool(stack);
    }

    public void reduceNeededResource(ItemStack res, int amount) {
        int preAmount = 0;
        if (this.neededResources.containsKey(res.getUnlocalizedName())) {
            preAmount = this.neededResources.get(res.getUnlocalizedName()).getAmount();
        }
        if (preAmount - amount <= 0) {
            this.neededResources.remove(res.getUnlocalizedName());
        } else {
            this.neededResources.get(res.getUnlocalizedName()).setAmount(preAmount - amount);
        }
        this.markDirty();
    }

    public void resetNeededResources() {
        this.neededResources = new HashMap();
        this.markDirty();
    }

    private void updateAvailableResources() {
        EntityCitizen builder = this.getWorkerEntity();
        InventoryCitizen builderInventory = null;
        if (builder != null) {
            builderInventory = builder.getInventoryCitizen();
        }
        for (Map.Entry<String, BuildingBuilderResource> entry : this.neededResources.entrySet()) {
            TileEntityColonyBuilding chestInventory;
            BuildingBuilderResource resource = entry.getValue();
            resource.setAvailable(0);
            if (builderInventory != null) {
                resource.addAvailable(InventoryUtils.getItemCountInItemHandler((IItemHandler)new InvWrapper((IInventory)builderInventory), resource.getItem(), resource.getDamageValue()));
            }
            if ((chestInventory = this.getTileEntity()) != null) {
                resource.addAvailable(InventoryUtils.getItemCountInProvider((ICapabilityProvider)chestInventory, resource.getItem(), resource.getDamageValue()));
            }
            if (builder == null) continue;
            for (BlockPos pos : this.getAdditionalCountainers()) {
                TileEntity entity = builder.worldObj.getTileEntity(pos);
                if (!(entity instanceof TileEntityChest)) continue;
                resource.addAvailable(InventoryUtils.getItemCountInProvider((ICapabilityProvider)entity, resource.getItem(), resource.getDamageValue()));
            }
        }
    }

    public boolean requiresResourceForBuilding(ItemStack stack) {
        return this.neededResources.containsKey(stack.getUnlocalizedName());
    }

    @Override
    public boolean transferStack(@NotNull ItemStack stack, @NotNull World world) {
        if (super.transferStack(stack, world)) {
            this.markDirty();
            return true;
        }
        return false;
    }

    @Override
    public ItemStack forceTransferStack(ItemStack stack, World world) {
        ItemStack itemStack = super.forceTransferStack(stack, world);
        if (itemStack != null) {
            this.markDirty();
            return itemStack;
        }
        return itemStack;
    }
}

