/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings;

import com.minecolonies.blockout.views.Window;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.achievements.ModAchievements;
import com.minecolonies.coremod.client.gui.WindowHutFarmer;
import com.minecolonies.coremod.colony.CitizenData;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.ColonyView;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingWorker;
import com.minecolonies.coremod.colony.jobs.AbstractJob;
import com.minecolonies.coremod.colony.jobs.JobFarmer;
import com.minecolonies.coremod.entity.ai.citizen.farmer.Field;
import com.minecolonies.coremod.entity.ai.citizen.farmer.FieldView;
import com.minecolonies.coremod.entity.ai.item.handling.ItemStorage;
import com.minecolonies.coremod.network.messages.AssignFieldMessage;
import com.minecolonies.coremod.network.messages.AssignmentModeMessage;
import com.minecolonies.coremod.tileentities.ScarecrowTileEntity;
import com.minecolonies.coremod.util.LanguageHandler;
import com.minecolonies.coremod.util.Utils;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BuildingFarmer
extends AbstractBuildingWorker {
    private static final String FARMER = "Farmer";
    private static final int MAX_BUILDING_LEVEL = 5;
    private static final String TAG_FIELDS = "fields";
    private static final String TAG_ASSIGN_MANUALLY = "assign";
    private static final int BLOCK_UPDATE_FLAG = 3;
    private final ArrayList<Field> farmerFields = new ArrayList();
    @Nullable
    private Field currentField;
    private boolean assignManually = false;
    private static final int SEEDS_TO_KEEP = 64;
    private final Map<ItemStorage, Integer> keepX = new HashMap<ItemStorage, Integer>();

    public BuildingFarmer(Colony c, BlockPos l) {
        super(c, l);
        ItemStack stackSeed = new ItemStack(Items.WHEAT_SEEDS);
        ItemStack stackCarrot = new ItemStack(Items.CARROT);
        ItemStack stackPotatoe = new ItemStack(Items.POTATO);
        ItemStack stackReed = new ItemStack(Items.BEETROOT_SEEDS);
        this.keepX.put(new ItemStorage(stackSeed.getItem(), stackSeed.getItemDamage(), 0, false), 64);
        this.keepX.put(new ItemStorage(stackCarrot.getItem(), stackCarrot.getItemDamage(), 0, false), 64);
        this.keepX.put(new ItemStorage(stackPotatoe.getItem(), stackPotatoe.getItemDamage(), 0, false), 64);
        this.keepX.put(new ItemStorage(stackReed.getItem(), stackReed.getItemDamage(), 0, false), 64);
    }

    @NotNull
    public List<Field> getFarmerFields() {
        return Collections.unmodifiableList(this.farmerFields);
    }

    public boolean hasNoFields() {
        return this.farmerFields.isEmpty();
    }

    public void addFarmerFields(Field field) {
        field.calculateSize(this.getColony().getWorld(), field.getLocation().down());
        this.farmerFields.add(field);
    }

    @Nullable
    public Field getCurrentField() {
        return this.currentField;
    }

    public void setCurrentField(@Nullable Field currentField) {
        this.currentField = currentField;
    }

    @Nullable
    public Field getFieldToWorkOn() {
        Collections.shuffle(this.farmerFields);
        for (Field field : this.farmerFields) {
            if (!field.needsWork()) continue;
            this.currentField = field;
            return field;
        }
        return null;
    }

    @Override
    public Map<ItemStorage, Integer> getRequiredItemsAndAmount() {
        return this.keepX;
    }

    @Override
    @NotNull
    public String getSchematicName() {
        return FARMER;
    }

    @Override
    public int getMaxBuildingLevel() {
        return 5;
    }

    @Override
    public void onUpgradeComplete(int newLevel) {
        super.onUpgradeComplete(newLevel);
        if (newLevel == 1) {
            this.getColony().triggerAchievement(ModAchievements.achievementBuildingFarmer);
        }
        if (newLevel >= this.getMaxBuildingLevel()) {
            this.getColony().triggerAchievement(ModAchievements.achievementUpgradeFarmerMax);
        }
    }

    @Override
    public boolean neededForWorker(@Nullable ItemStack stack) {
        return stack != null && Utils.isHoe(stack);
    }

    @Override
    @NotNull
    public String getJobName() {
        return FARMER;
    }

    @Override
    @NotNull
    public AbstractJob createJob(@NotNull CitizenData citizen) {
        if (!this.farmerFields.isEmpty()) {
            for (Field field : this.farmerFields) {
                Field colonyField = this.getColony().getField(field.getID());
                if (colonyField != null) {
                    colonyField.setOwner(citizen.getName());
                }
                field.setOwner(citizen.getName());
            }
        }
        return new JobFarmer(citizen);
    }

    @Override
    public void readFromNBT(@NotNull NBTTagCompound compound) {
        super.readFromNBT(compound);
        NBTTagList fieldTagList = compound.getTagList(TAG_FIELDS, 10);
        for (int i = 0; i < fieldTagList.tagCount(); ++i) {
            NBTTagCompound fieldCompound = fieldTagList.getCompoundTagAt(i);
            Field f = Field.createFromNBT(this.getColony(), fieldCompound);
            if (f == null) continue;
            this.farmerFields.add(f);
        }
        this.assignManually = compound.getBoolean(TAG_ASSIGN_MANUALLY);
    }

    @Override
    public void writeToNBT(@NotNull NBTTagCompound compound) {
        super.writeToNBT(compound);
        NBTTagList fieldTagList = new NBTTagList();
        for (Field f : this.farmerFields) {
            NBTTagCompound fieldCompound = new NBTTagCompound();
            f.writeToNBT(fieldCompound);
            fieldTagList.appendTag((NBTBase)fieldCompound);
        }
        compound.setTag(TAG_FIELDS, (NBTBase)fieldTagList);
        compound.setBoolean(TAG_ASSIGN_MANUALLY, this.assignManually);
    }

    @Override
    public void onDestroyed() {
        super.onDestroyed();
        for (Field field : this.farmerFields) {
            Field tempField = this.getColony().getField(field.getID());
            if (tempField == null) continue;
            tempField.setTaken(false);
            tempField.setOwner("");
            ScarecrowTileEntity scarecrowTileEntity = (ScarecrowTileEntity)this.getColony().getWorld().getTileEntity(field.getID());
            if (this.getColony() == null || this.getColony().getWorld() == null) continue;
            this.getColony().getWorld().notifyBlockUpdate(scarecrowTileEntity.getPos(), this.getColony().getWorld().getBlockState(scarecrowTileEntity.getPos()), this.getColony().getWorld().getBlockState(scarecrowTileEntity.getPos()), 3);
            scarecrowTileEntity.setName(LanguageHandler.format("com.minecolonies.coremod.gui.scarecrow.user", LanguageHandler.format("com.minecolonies.coremod.gui.scarecrow.user.noone", new Object[0])));
        }
    }

    @Override
    public void serializeToView(@NotNull ByteBuf buf) {
        super.serializeToView(buf);
        buf.writeBoolean(this.assignManually);
        int size = 0;
        for (Field field : this.getColony().getFields().values()) {
            if (field.isTaken()) {
                if (this.getWorker() != null && !field.getOwner().equals(this.getWorker().getName())) continue;
                ++size;
                continue;
            }
            ++size;
        }
        buf.writeInt(size);
        for (Field field : this.getColony().getFields().values()) {
            FieldView fieldView;
            if (field.isTaken()) {
                if (this.getWorker() != null && !field.getOwner().equals(this.getWorker().getName())) continue;
                fieldView = new FieldView(field);
                fieldView.serializeViewNetworkData(buf);
                continue;
            }
            fieldView = new FieldView(field);
            fieldView.serializeViewNetworkData(buf);
        }
        if (this.getWorker() == null) {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)"");
        } else {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.getWorker().getName());
        }
    }

    public void syncWithColony(@NotNull World world) {
        if (!this.farmerFields.isEmpty()) {
            ArrayList<Field> tempFields = new ArrayList<Field>(this.farmerFields);
            for (Field field : tempFields) {
                ScarecrowTileEntity scarecrow = (ScarecrowTileEntity)world.getTileEntity(field.getID());
                if (scarecrow == null) {
                    this.farmerFields.remove((Object)field);
                    if (this.currentField == null || this.currentField.getID() != field.getID()) continue;
                    this.currentField = null;
                    continue;
                }
                scarecrow.setName(LanguageHandler.format("com.minecolonies.coremod.gui.scarecrow.user", this.getWorker().getName()));
                this.getColony().getWorld().notifyBlockUpdate(scarecrow.getPos(), this.getColony().getWorld().getBlockState(scarecrow.getPos()), this.getColony().getWorld().getBlockState(scarecrow.getPos()), 3);
                field.setInventoryField(scarecrow.getInventoryField());
                if (this.currentField == null || this.currentField.getID() != field.getID()) continue;
                this.currentField.setInventoryField(scarecrow.getInventoryField());
            }
        }
    }

    public void resetFields() {
        for (Field field : this.farmerFields) {
            field.setNeedsWork(true);
            field.calculateSize(this.getColony().getWorld(), field.getLocation().down());
        }
    }

    public boolean assignManually() {
        return this.assignManually;
    }

    public void freeField(BlockPos position) {
        Field tempField = this.farmerFields.stream().filter(field -> field.getID().equals((Object)position)).findFirst().orElse(null);
        if (tempField != null) {
            this.farmerFields.remove((Object)tempField);
            Field field2 = this.getColony().getField(position);
            field2.setTaken(false);
            field2.setOwner("");
            ScarecrowTileEntity scarecrowTileEntity = (ScarecrowTileEntity)this.getColony().getWorld().getTileEntity(field2.getID());
            this.getColony().getWorld().notifyBlockUpdate(scarecrowTileEntity.getPos(), this.getColony().getWorld().getBlockState(scarecrowTileEntity.getPos()), this.getColony().getWorld().getBlockState(scarecrowTileEntity.getPos()), 3);
            scarecrowTileEntity.setName(LanguageHandler.format("com.minecolonies.coremod.gui.scarecrow.user", LanguageHandler.format("com.minecolonies.coremod.gui.scarecrow.user.noone", new Object[0])));
        }
    }

    public void assignField(BlockPos position) {
        Field field = this.getColony().getField(position);
        field.setTaken(true);
        field.setOwner(this.getWorker().getName());
        this.farmerFields.add(field);
    }

    public void setAssignManually(boolean assignManually) {
        this.assignManually = assignManually;
    }

    public static class View
    extends AbstractBuildingWorker.View {
        private boolean assignFieldManually;
        @NotNull
        private List<FieldView> fields = new ArrayList<FieldView>();
        private String workerName;
        private int amountOfFields;

        public View(ColonyView c, BlockPos l) {
            super(c, l);
        }

        @Override
        @NotNull
        public Window getWindow() {
            return new WindowHutFarmer(this);
        }

        @Override
        public void deserialize(@NotNull ByteBuf buf) {
            this.fields = new ArrayList<FieldView>();
            super.deserialize(buf);
            this.assignFieldManually = buf.readBoolean();
            int size = buf.readInt();
            for (int i = 1; i <= size; ++i) {
                FieldView fieldView = new FieldView();
                fieldView.deserialize(buf);
                this.fields.add(fieldView);
                if (!fieldView.isTaken()) continue;
                ++this.amountOfFields;
            }
            this.workerName = ByteBufUtils.readUTF8String((ByteBuf)buf);
        }

        public boolean assignFieldManually() {
            return this.assignFieldManually;
        }

        @NotNull
        public List<FieldView> getFields() {
            return Collections.unmodifiableList(this.fields);
        }

        public String getWorkerName() {
            return this.workerName;
        }

        public int getAmountOfFields() {
            return this.amountOfFields;
        }

        public void setAssignFieldManually(boolean assignFieldManually) {
            MineColonies.getNetwork().sendToServer((IMessage)new AssignmentModeMessage(this, assignFieldManually));
            this.assignFieldManually = assignFieldManually;
        }

        public void changeFields(BlockPos id, boolean addNewField, int row) {
            MineColonies.getNetwork().sendToServer((IMessage)new AssignFieldMessage(this, addNewField, id));
            this.fields.get(row).setTaken(addNewField);
            if (addNewField) {
                this.fields.get(row).setOwner(this.workerName);
                ++this.amountOfFields;
            } else {
                this.fields.get(row).setOwner("");
                --this.amountOfFields;
            }
        }

        @Override
        @NotNull
        public AbstractBuildingWorker.Skill getPrimarySkill() {
            return AbstractBuildingWorker.Skill.ENDURANCE;
        }

        @Override
        @NotNull
        public AbstractBuildingWorker.Skill getSecondarySkill() {
            return AbstractBuildingWorker.Skill.CHARISMA;
        }
    }
}

