/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.views;

import com.minecolonies.blockout.views.Window;
import com.minecolonies.coremod.client.gui.WindowHutBuilder;
import com.minecolonies.coremod.colony.ColonyView;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingWorker;
import com.minecolonies.coremod.colony.buildings.utils.BuildingBuilderResource;
import io.netty.buffer.ByteBuf;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import org.jetbrains.annotations.NotNull;

public class BuildingBuilderView
extends AbstractBuildingWorker.View {
    private final HashMap<String, BuildingBuilderResource> resources = new HashMap();

    public BuildingBuilderView(ColonyView c, BlockPos l) {
        super(c, l);
    }

    @Override
    @NotNull
    public Window getWindow() {
        return new WindowHutBuilder(this);
    }

    @Override
    public void deserialize(@NotNull ByteBuf buf) {
        super.deserialize(buf);
        int size = buf.readInt();
        this.resources.clear();
        for (int i = 0; i < size; ++i) {
            int itemId = buf.readInt();
            int damage = buf.readInt();
            ItemStack itemStack = new ItemStack(Item.getByNameOrId((String)Integer.toString(itemId)), 1, damage);
            int amountAvailable = buf.readInt();
            int amountNeeded = buf.readInt();
            BuildingBuilderResource resource = new BuildingBuilderResource(itemStack.getItem(), itemStack.getItemDamage(), amountNeeded, amountAvailable);
            this.resources.put(itemStack.getDisplayName(), resource);
        }
    }

    public Map<String, BuildingBuilderResource> getResources() {
        return Collections.unmodifiableMap(this.resources);
    }

    @Override
    @NotNull
    public AbstractBuildingWorker.Skill getPrimarySkill() {
        return AbstractBuildingWorker.Skill.INTELLIGENCE;
    }

    @Override
    @NotNull
    public AbstractBuildingWorker.Skill getSecondarySkill() {
        return AbstractBuildingWorker.Skill.STRENGTH;
    }
}

