/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.jobs;

import com.minecolonies.coremod.client.render.RenderBipedCitizen;
import com.minecolonies.coremod.colony.CitizenData;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.jobs.AbstractJob;
import com.minecolonies.coremod.entity.ai.basic.AbstractAISkeleton;
import com.minecolonies.coremod.entity.ai.citizen.deliveryman.EntityAIWorkDeliveryman;
import com.minecolonies.coremod.util.BlockPosUtil;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import org.jetbrains.annotations.NotNull;

public class JobDeliveryman
extends AbstractJob {
    private static final String TAG_DESTINATION = "destination";
    private BlockPos destination;

    public JobDeliveryman(CitizenData entity) {
        super(entity);
    }

    @Override
    public void readFromNBT(@NotNull NBTTagCompound compound) {
        super.readFromNBT(compound);
        if (compound.hasKey(TAG_DESTINATION)) {
            this.destination = BlockPosUtil.readFromNBT(compound, TAG_DESTINATION);
        }
    }

    @Override
    @NotNull
    public String getName() {
        return "com.minecolonies.coremod.job.Deliveryman";
    }

    @Override
    @NotNull
    public RenderBipedCitizen.Model getModel() {
        return RenderBipedCitizen.Model.DELIVERYMAN;
    }

    @Override
    public void writeToNBT(@NotNull NBTTagCompound compound) {
        super.writeToNBT(compound);
        if (this.hasDestination()) {
            BlockPosUtil.writeToNBT(compound, TAG_DESTINATION, this.destination);
        }
    }

    @NotNull
    public AbstractAISkeleton<JobDeliveryman> generateAI() {
        return new EntityAIWorkDeliveryman(this);
    }

    public boolean hasDestination() {
        return this.destination != null;
    }

    public boolean isNeeded() {
        Colony colony = this.getCitizen().getColony();
        return colony != null && !colony.getDeliverymanRequired().isEmpty();
    }

    public BlockPos getDestination() {
        return this.destination;
    }

    public void setDestination(BlockPos destination) {
        this.destination = destination;
    }
}

