/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.permissions;

import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.permissions.IPermissions;
import com.minecolonies.coremod.network.PacketUtils;
import com.minecolonies.coremod.util.AchievementUtils;
import com.minecolonies.coremod.util.Utils;
import com.mojang.authlib.GameProfile;
import io.netty.buffer.ByteBuf;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Permissions
implements IPermissions {
    private static final String TAG_UPDATE = "update";
    private static final String TAG_OWNERS = "owners";
    private static final String TAG_ID = "id";
    private static final String TAG_RANK = "rank";
    private static final String TAG_PERMISSIONS = "permissionMap";
    private static final String TAG_FLAGS = "flags";
    private static final String TAG_OWNER = "owner";
    private static final String TAG_OWNER_ID = "ownerid";
    @NotNull
    private static final Map<Rank, RankPair> promotionRanks = new EnumMap<Rank, RankPair>(Rank.class);
    @NotNull
    private final Colony colony;
    @NotNull
    private final Map<UUID, Player> players = new HashMap<UUID, Player>();
    @NotNull
    private final Map<Rank, Integer> permissionMap = new EnumMap<Rank, Integer>(Rank.class);
    private boolean dirty = false;
    private String ownerName = "";
    private UUID ownerUUID = null;
    private boolean updatedPermissionAlready = false;

    public Permissions(@NotNull Colony colony) {
        this.permissionMap.put(Rank.OWNER, 0);
        this.setPermission(Rank.OWNER, Action.ACCESS_HUTS);
        this.setPermission(Rank.OWNER, Action.PLACE_HUTS);
        this.setPermission(Rank.OWNER, Action.BREAK_HUTS);
        this.setPermission(Rank.OWNER, Action.CAN_PROMOTE);
        this.setPermission(Rank.OWNER, Action.CAN_DEMOTE);
        this.setPermission(Rank.OWNER, Action.SEND_MESSAGES);
        this.setPermission(Rank.OWNER, Action.EDIT_PERMISSIONS);
        this.setPermission(Rank.OWNER, Action.MANAGE_HUTS);
        this.setPermission(Rank.OWNER, Action.RECEIVE_MESSAGES);
        this.setPermission(Rank.OWNER, Action.USE_SCAN_TOOL);
        this.setPermission(Rank.OWNER, Action.PLACE_BLOCKS);
        this.setPermission(Rank.OWNER, Action.BREAK_BLOCKS);
        this.setPermission(Rank.OWNER, Action.TOSS_ITEM);
        this.setPermission(Rank.OWNER, Action.PICKUP_ITEM);
        this.setPermission(Rank.OWNER, Action.FILL_BUCKET);
        this.setPermission(Rank.OWNER, Action.OPEN_CONTAINER);
        this.setPermission(Rank.OWNER, Action.RIGHTCLICK_BLOCK);
        this.setPermission(Rank.OWNER, Action.RIGHTCLICK_ENTITY);
        this.setPermission(Rank.OWNER, Action.THROW_POTION);
        this.setPermission(Rank.OWNER, Action.SHOOT_ARROW);
        this.setPermission(Rank.OWNER, Action.ATTACK_CITIZEN);
        this.setPermission(Rank.OWNER, Action.ATTACK_ENTITY);
        this.setPermission(Rank.OWNER, Action.ACCESS_FREE_BLOCKS);
        this.setPermission(Rank.OWNER, Action.TELEPORT_TO_COLONY);
        this.permissionMap.put(Rank.OFFICER, 0);
        this.setPermission(Rank.OFFICER, Action.ACCESS_HUTS);
        this.setPermission(Rank.OFFICER, Action.PLACE_HUTS);
        this.setPermission(Rank.OFFICER, Action.BREAK_HUTS);
        this.setPermission(Rank.OFFICER, Action.CAN_PROMOTE);
        this.setPermission(Rank.OFFICER, Action.CAN_DEMOTE);
        this.setPermission(Rank.OFFICER, Action.SEND_MESSAGES);
        this.setPermission(Rank.OFFICER, Action.MANAGE_HUTS);
        this.setPermission(Rank.OFFICER, Action.RECEIVE_MESSAGES);
        this.setPermission(Rank.OFFICER, Action.USE_SCAN_TOOL);
        this.setPermission(Rank.OFFICER, Action.PLACE_BLOCKS);
        this.setPermission(Rank.OFFICER, Action.BREAK_BLOCKS);
        this.setPermission(Rank.OFFICER, Action.TOSS_ITEM);
        this.setPermission(Rank.OFFICER, Action.PICKUP_ITEM);
        this.setPermission(Rank.OFFICER, Action.FILL_BUCKET);
        this.setPermission(Rank.OFFICER, Action.OPEN_CONTAINER);
        this.setPermission(Rank.OFFICER, Action.RIGHTCLICK_BLOCK);
        this.setPermission(Rank.OFFICER, Action.RIGHTCLICK_ENTITY);
        this.setPermission(Rank.OFFICER, Action.THROW_POTION);
        this.setPermission(Rank.OFFICER, Action.SHOOT_ARROW);
        this.setPermission(Rank.OFFICER, Action.ATTACK_CITIZEN);
        this.setPermission(Rank.OFFICER, Action.ATTACK_ENTITY);
        this.setPermission(Rank.OFFICER, Action.ACCESS_FREE_BLOCKS);
        this.setPermission(Rank.OFFICER, Action.TELEPORT_TO_COLONY);
        this.permissionMap.put(Rank.FRIEND, 0);
        this.setPermission(Rank.FRIEND, Action.ACCESS_HUTS);
        this.setPermission(Rank.FRIEND, Action.USE_SCAN_TOOL);
        this.setPermission(Rank.FRIEND, Action.TOSS_ITEM);
        this.setPermission(Rank.FRIEND, Action.PICKUP_ITEM);
        this.setPermission(Rank.FRIEND, Action.RIGHTCLICK_BLOCK);
        this.setPermission(Rank.FRIEND, Action.RIGHTCLICK_ENTITY);
        this.setPermission(Rank.FRIEND, Action.THROW_POTION);
        this.setPermission(Rank.FRIEND, Action.SHOOT_ARROW);
        this.setPermission(Rank.FRIEND, Action.ATTACK_CITIZEN);
        this.setPermission(Rank.FRIEND, Action.ATTACK_ENTITY);
        this.setPermission(Rank.FRIEND, Action.ACCESS_FREE_BLOCKS);
        this.setPermission(Rank.FRIEND, Action.TELEPORT_TO_COLONY);
        this.permissionMap.put(Rank.NEUTRAL, 0);
        this.setPermission(Rank.NEUTRAL, Action.ACCESS_FREE_BLOCKS);
        this.permissionMap.put(Rank.HOSTILE, 0);
        this.setPermission(Rank.HOSTILE, Action.GUARDS_ATTACK);
        this.colony = colony;
        this.updatedPermissionAlready = true;
    }

    public final void setPermission(Rank rank, @NotNull Action action) {
        int flags = this.permissionMap.get((Object)rank);
        if (!Utils.testFlag(flags, action.flag)) {
            this.permissionMap.put(rank, Utils.setFlag(flags, action.flag));
            this.markDirty();
        }
    }

    private void updateNewPermissions() {
        this.setPermission(Rank.OWNER, Action.MANAGE_HUTS);
        this.setPermission(Rank.OWNER, Action.RECEIVE_MESSAGES);
        this.setPermission(Rank.OWNER, Action.USE_SCAN_TOOL);
        this.setPermission(Rank.OWNER, Action.PLACE_BLOCKS);
        this.setPermission(Rank.OWNER, Action.BREAK_BLOCKS);
        this.setPermission(Rank.OWNER, Action.TOSS_ITEM);
        this.setPermission(Rank.OWNER, Action.PICKUP_ITEM);
        this.setPermission(Rank.OWNER, Action.FILL_BUCKET);
        this.setPermission(Rank.OWNER, Action.OPEN_CONTAINER);
        this.setPermission(Rank.OWNER, Action.RIGHTCLICK_BLOCK);
        this.setPermission(Rank.OWNER, Action.RIGHTCLICK_ENTITY);
        this.setPermission(Rank.OWNER, Action.THROW_POTION);
        this.setPermission(Rank.OWNER, Action.SHOOT_ARROW);
        this.setPermission(Rank.OWNER, Action.ATTACK_CITIZEN);
        this.setPermission(Rank.OWNER, Action.ATTACK_ENTITY);
        this.setPermission(Rank.OWNER, Action.ACCESS_FREE_BLOCKS);
        this.setPermission(Rank.OWNER, Action.TELEPORT_TO_COLONY);
        this.setPermission(Rank.OFFICER, Action.MANAGE_HUTS);
        this.setPermission(Rank.OFFICER, Action.RECEIVE_MESSAGES);
        this.setPermission(Rank.OFFICER, Action.USE_SCAN_TOOL);
        this.setPermission(Rank.OFFICER, Action.PLACE_BLOCKS);
        this.setPermission(Rank.OFFICER, Action.BREAK_BLOCKS);
        this.setPermission(Rank.OFFICER, Action.TOSS_ITEM);
        this.setPermission(Rank.OFFICER, Action.PICKUP_ITEM);
        this.setPermission(Rank.OFFICER, Action.FILL_BUCKET);
        this.setPermission(Rank.OFFICER, Action.OPEN_CONTAINER);
        this.setPermission(Rank.OFFICER, Action.RIGHTCLICK_BLOCK);
        this.setPermission(Rank.OFFICER, Action.RIGHTCLICK_ENTITY);
        this.setPermission(Rank.OFFICER, Action.THROW_POTION);
        this.setPermission(Rank.OFFICER, Action.SHOOT_ARROW);
        this.setPermission(Rank.OFFICER, Action.ATTACK_CITIZEN);
        this.setPermission(Rank.OFFICER, Action.ATTACK_ENTITY);
        this.setPermission(Rank.OFFICER, Action.ACCESS_FREE_BLOCKS);
        this.setPermission(Rank.OFFICER, Action.TELEPORT_TO_COLONY);
        this.setPermission(Rank.FRIEND, Action.ACCESS_HUTS);
        this.setPermission(Rank.FRIEND, Action.USE_SCAN_TOOL);
        this.setPermission(Rank.FRIEND, Action.TOSS_ITEM);
        this.setPermission(Rank.FRIEND, Action.PICKUP_ITEM);
        this.setPermission(Rank.FRIEND, Action.RIGHTCLICK_BLOCK);
        this.setPermission(Rank.FRIEND, Action.RIGHTCLICK_ENTITY);
        this.setPermission(Rank.FRIEND, Action.THROW_POTION);
        this.setPermission(Rank.FRIEND, Action.SHOOT_ARROW);
        this.setPermission(Rank.FRIEND, Action.ATTACK_CITIZEN);
        this.setPermission(Rank.FRIEND, Action.ATTACK_ENTITY);
        this.setPermission(Rank.FRIEND, Action.ACCESS_FREE_BLOCKS);
        this.setPermission(Rank.FRIEND, Action.TELEPORT_TO_COLONY);
        this.setPermission(Rank.NEUTRAL, Action.ACCESS_FREE_BLOCKS);
        this.updatedPermissionAlready = true;
    }

    private void markDirty() {
        this.dirty = true;
    }

    private static void setPromotionRanks(Rank r, Rank p, Rank d) {
        promotionRanks.put(r, new RankPair(p, d));
    }

    public static Rank getPromotionRank(Rank rank) {
        if (promotionRanks.containsKey((Object)rank)) {
            return promotionRanks.get((Object)rank).promote;
        }
        return rank;
    }

    public static Rank getDemotionRank(Rank rank) {
        if (promotionRanks.containsKey((Object)rank)) {
            return promotionRanks.get((Object)rank).demote;
        }
        return rank;
    }

    public void loadPermissions(@NotNull NBTTagCompound compound) {
        Rank rank;
        NBTTagList ownerTagList = compound.getTagList(TAG_OWNERS, 10);
        for (int i = 0; i < ownerTagList.tagCount(); ++i) {
            NBTTagCompound ownerCompound = ownerTagList.getCompoundTagAt(i);
            UUID id = UUID.fromString(ownerCompound.getString(TAG_ID));
            rank = Rank.valueOf(ownerCompound.getString(TAG_RANK));
            GameProfile player = FMLCommonHandler.instance().getMinecraftServerInstance().getPlayerProfileCache().getProfileByUUID(id);
            if (player == null) continue;
            this.players.put(id, new Player(id, player.getName(), rank));
        }
        NBTTagList permissionsTagList = compound.getTagList(TAG_PERMISSIONS, 10);
        for (int i = 0; i < permissionsTagList.tagCount(); ++i) {
            NBTTagCompound permissionsCompound = permissionsTagList.getCompoundTagAt(i);
            rank = Rank.valueOf(permissionsCompound.getString(TAG_RANK));
            NBTTagList flagsTagList = permissionsCompound.getTagList(TAG_FLAGS, 8);
            int flags = 0;
            for (int j = 0; j < flagsTagList.tagCount(); ++j) {
                String flag = flagsTagList.getStringTagAt(j);
                flags = Utils.setFlag(flags, Action.valueOf(flag).flag);
            }
            this.permissionMap.put(rank, flags);
        }
        if (compound.hasKey(TAG_OWNER)) {
            this.ownerName = compound.getString(TAG_OWNER);
        }
        if (compound.hasKey(TAG_OWNER_ID)) {
            try {
                this.ownerUUID = UUID.fromString(compound.getString(TAG_OWNER_ID));
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
        }
        this.updatedPermissionAlready = compound.getBoolean(TAG_UPDATE);
        if (!this.updatedPermissionAlready) {
            this.updateNewPermissions();
        }
        this.restoreOwnerIfNull();
    }

    public boolean setOwner(EntityPlayer player) {
        this.players.remove(this.getOwner());
        this.ownerName = player.getName();
        this.ownerUUID = player.getUniqueID();
        this.players.put(this.ownerUUID, new Player(this.ownerUUID, player.getName(), Rank.OWNER));
        this.markDirty();
        return true;
    }

    public void restoreOwnerIfNull() {
        GameProfile player;
        Map.Entry<UUID, Player> owner = this.getOwnerEntry();
        if (owner == null && this.ownerUUID != null && (player = FMLCommonHandler.instance().getMinecraftServerInstance().getPlayerProfileCache().getProfileByUUID(this.ownerUUID)) != null) {
            this.players.put(this.ownerUUID, new Player(this.ownerUUID, player.getName(), Rank.OWNER));
        }
        this.markDirty();
    }

    @Nullable
    private Map.Entry<UUID, Player> getOwnerEntry() {
        for (Map.Entry<UUID, Player> entry : this.players.entrySet()) {
            if (!entry.getValue().rank.equals((Object)Rank.OWNER)) continue;
            return entry;
        }
        return null;
    }

    public void savePermissions(@NotNull NBTTagCompound compound) {
        NBTTagList ownerTagList = new NBTTagList();
        for (Player player : this.players.values()) {
            NBTTagCompound ownersCompound = new NBTTagCompound();
            ownersCompound.setString(TAG_ID, player.id.toString());
            ownersCompound.setString(TAG_RANK, player.rank.name());
            ownerTagList.appendTag((NBTBase)ownersCompound);
        }
        compound.setTag(TAG_OWNERS, (NBTBase)ownerTagList);
        NBTTagList permissionsTagList = new NBTTagList();
        for (Map.Entry<Rank, Integer> entry : this.permissionMap.entrySet()) {
            NBTTagCompound permissionsCompound = new NBTTagCompound();
            permissionsCompound.setString(TAG_RANK, entry.getKey().name());
            NBTTagList flagsTagList = new NBTTagList();
            for (Action action : Action.values()) {
                if (!Utils.testFlag(entry.getValue(), action.flag)) continue;
                flagsTagList.appendTag((NBTBase)new NBTTagString(action.name()));
            }
            permissionsCompound.setTag(TAG_FLAGS, (NBTBase)flagsTagList);
            permissionsTagList.appendTag((NBTBase)permissionsCompound);
        }
        compound.setTag(TAG_PERMISSIONS, (NBTBase)permissionsTagList);
        if (!this.ownerName.isEmpty()) {
            compound.setString(TAG_OWNER, this.ownerName);
        }
        if (this.ownerUUID != null) {
            compound.setString(TAG_OWNER_ID, this.ownerUUID.toString());
        }
        compound.setBoolean(TAG_UPDATE, this.updatedPermissionAlready);
    }

    @NotNull
    public Map<UUID, Player> getPlayers() {
        return Collections.unmodifiableMap(this.players);
    }

    public Set<UUID> getMessagePlayers() {
        return this.players.values().stream().filter(player -> this.hasPermission(((Player)player).rank, Action.RECEIVE_MESSAGES)).map(player -> ((Player)player).id).collect(Collectors.toSet());
    }

    public boolean hasPermission(Rank rank, @NotNull Action action) {
        return rank == Rank.OWNER && action != Action.GUARDS_ATTACK || Utils.testFlag(this.permissionMap.get((Object)rank), action.flag);
    }

    public Set<Player> getPlayersByRank(Rank rank) {
        return this.players.values().stream().filter(player -> ((Player)player).rank.equals((Object)rank)).collect(Collectors.toSet());
    }

    public Set<Player> getPlayersByRank(@NotNull Set<Rank> ranks) {
        return this.players.values().stream().filter(player -> ranks.contains((Object)((Player)player).rank)).collect(Collectors.toSet());
    }

    @NotNull
    public Map<Rank, Integer> getPermissionMap() {
        return this.permissionMap;
    }

    @Override
    public boolean hasPermission(@NotNull EntityPlayer player, @NotNull Action action) {
        return this.hasPermission(this.getRank(player), action);
    }

    @NotNull
    public Rank getRank(@NotNull EntityPlayer player) {
        return this.getRank(player.getGameProfile().getId());
    }

    public void removePermission(Rank rank, @NotNull Action action) {
        int flags = this.permissionMap.get((Object)rank);
        if (Utils.testFlag(flags, action.flag)) {
            this.permissionMap.put(rank, Utils.unsetFlag(flags, action.flag));
            this.markDirty();
        }
    }

    @Override
    @NotNull
    public Rank getRank(UUID id) {
        Player player = this.players.get(id);
        return player != null ? player.rank : Rank.NEUTRAL;
    }

    public void togglePermission(Rank rank, @NotNull Action action) {
        this.permissionMap.put(rank, Utils.toggleFlag(this.permissionMap.get((Object)rank), action.flag));
        this.markDirty();
    }

    public boolean setPlayerRank(UUID id, Rank rank, World world) {
        Player player = this.players.get(id);
        if (player == null) {
            GameProfile gameprofile = world.getMinecraftServer().getPlayerProfileCache().getProfileByUUID(id);
            return gameprofile != null && this.addPlayer(gameprofile, rank);
        }
        player.rank = rank;
        this.markDirty();
        AchievementUtils.syncAchievements(this.colony);
        return true;
    }

    private boolean addPlayer(@NotNull GameProfile gameprofile, Rank rank) {
        Player p = new Player(gameprofile.getId(), gameprofile.getName(), rank);
        if (this.players.containsKey(p.id)) {
            this.players.remove(p.id);
        }
        this.players.put(p.id, p);
        this.markDirty();
        AchievementUtils.syncAchievements(this.colony);
        return true;
    }

    public boolean addPlayer(@NotNull String player, Rank rank, World world) {
        if (player.isEmpty()) {
            return false;
        }
        GameProfile gameprofile = world.getMinecraftServer().getPlayerProfileCache().getGameProfileForUsername(player);
        return gameprofile != null && !this.players.containsKey(gameprofile.getId()) && this.addPlayer(gameprofile, rank);
    }

    public boolean removePlayer(UUID id) {
        Player player = this.players.get(id);
        AchievementUtils.syncAchievements(this.colony);
        if (player != null && player.getRank() != Rank.OWNER && this.players.remove(id) != null) {
            this.markDirty();
            return true;
        }
        return false;
    }

    @Nullable
    public UUID getOwner() {
        Map.Entry<UUID, Player> owner;
        if (this.ownerUUID == null && (owner = this.getOwnerEntry()) != null) {
            this.ownerUUID = owner.getKey();
        }
        return this.ownerUUID;
    }

    @Nullable
    public String getOwnerName() {
        Map.Entry<UUID, Player> owner;
        if (this.ownerName.isEmpty() && (owner = this.getOwnerEntry()) != null) {
            this.ownerName = owner.getValue().getName();
        }
        return this.ownerName;
    }

    public boolean isSubscriber(@NotNull EntityPlayer player) {
        return this.isSubscriber(player.getGameProfile().getId());
    }

    @Override
    public boolean isColonyMember(@NotNull EntityPlayer player) {
        return this.players.containsKey(player.getGameProfile().getId());
    }

    private boolean isSubscriber(UUID player) {
        return this.getRank((UUID)player).isSubscriber;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void clearDirty() {
        this.dirty = false;
    }

    public void serializeViewNetworkData(@NotNull ByteBuf buf, @NotNull Rank viewerRank) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)viewerRank.name());
        buf.writeInt(this.players.size());
        for (Map.Entry<UUID, Player> entry : this.players.entrySet()) {
            PacketUtils.writeUUID(buf, entry.getKey());
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)entry.getValue().name);
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)entry.getValue().rank.name());
        }
        buf.writeInt(this.permissionMap.size());
        for (Map.Entry<Object, Object> entry : this.permissionMap.entrySet()) {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)((Rank)((Object)entry.getKey())).name());
            buf.writeInt(((Integer)entry.getValue()).intValue());
        }
    }

    static {
        Permissions.setPromotionRanks(Rank.OFFICER, Rank.OFFICER, Rank.FRIEND);
        Permissions.setPromotionRanks(Rank.FRIEND, Rank.OFFICER, Rank.NEUTRAL);
        Permissions.setPromotionRanks(Rank.NEUTRAL, Rank.FRIEND, Rank.HOSTILE);
        Permissions.setPromotionRanks(Rank.HOSTILE, Rank.NEUTRAL, Rank.HOSTILE);
    }

    public static class View
    implements IPermissions {
        @NotNull
        private final Map<UUID, Player> players = new HashMap<UUID, Player>();
        @NotNull
        private final Map<Rank, Integer> permissions = new EnumMap<Rank, Integer>(Rank.class);
        private Rank userRank = Rank.NEUTRAL;

        public Rank getUserRank() {
            return this.userRank;
        }

        @NotNull
        public Map<UUID, Player> getPlayers() {
            return Collections.unmodifiableMap(this.players);
        }

        @NotNull
        public Set<Player> getPlayersByRank(Rank rank) {
            return Collections.unmodifiableSet(this.players.values().stream().filter(player -> ((Player)player).rank == rank).collect(Collectors.toSet()));
        }

        @NotNull
        public Set<Player> getPlayersByRank(@NotNull Set<Rank> ranks) {
            return Collections.unmodifiableSet(this.players.values().stream().filter(player -> ranks.contains((Object)((Player)player).rank)).collect(Collectors.toSet()));
        }

        @NotNull
        public Map<Rank, Integer> getPermissions() {
            return this.permissions;
        }

        public boolean hasPermission(UUID id, @NotNull Action action) {
            return this.hasPermission(this.getRank(id), action);
        }

        public boolean hasPermission(Rank rank, @NotNull Action action) {
            return rank == Rank.OWNER && action != Action.GUARDS_ATTACK || Utils.testFlag(this.permissions.get((Object)rank), action.flag);
        }

        public boolean setPermission(Rank rank, @NotNull Action action) {
            int flags = this.permissions.get((Object)rank);
            if (!Utils.testFlag(flags, action.flag)) {
                this.permissions.put(rank, Utils.setFlag(flags, action.flag));
                return true;
            }
            return false;
        }

        public boolean removePermission(Rank rank, @NotNull Action action) {
            int flags = this.permissions.get((Object)rank);
            if (Utils.testFlag(flags, action.flag)) {
                this.permissions.put(rank, Utils.unsetFlag(flags, action.flag));
                return true;
            }
            return false;
        }

        public void togglePermission(Rank rank, @NotNull Action action) {
            this.permissions.put(rank, Utils.toggleFlag(this.permissions.get((Object)rank), action.flag));
        }

        public void deserialize(@NotNull ByteBuf buf) {
            this.userRank = Rank.valueOf(ByteBufUtils.readUTF8String((ByteBuf)buf));
            this.players.clear();
            int numOwners = buf.readInt();
            for (int i = 0; i < numOwners; ++i) {
                UUID id = PacketUtils.readUUID(buf);
                String name = ByteBufUtils.readUTF8String((ByteBuf)buf);
                Rank rank = Rank.valueOf(ByteBufUtils.readUTF8String((ByteBuf)buf));
                this.players.put(id, new Player(id, name, rank));
            }
            this.permissions.clear();
            int numPermissions = buf.readInt();
            for (int i = 0; i < numPermissions; ++i) {
                Rank rank = Rank.valueOf(ByteBufUtils.readUTF8String((ByteBuf)buf));
                int flags = buf.readInt();
                this.permissions.put(rank, flags);
            }
        }

        @NotNull
        public Rank getRank(@NotNull EntityPlayer player) {
            return this.getRank(player.getUniqueID());
        }

        @Override
        @NotNull
        public Rank getRank(UUID id) {
            Player player = this.players.get(id);
            return player == null ? Rank.NEUTRAL : player.rank;
        }

        @Override
        public boolean hasPermission(@NotNull EntityPlayer player, @NotNull Action action) {
            return this.hasPermission(this.getRank(player), action);
        }

        @Override
        public boolean isColonyMember(@NotNull EntityPlayer player) {
            return this.players.containsKey(player.getUniqueID());
        }
    }

    private static class RankPair {
        private final Rank promote;
        private final Rank demote;

        RankPair(Rank p, Rank d) {
            this.promote = p;
            this.demote = d;
        }
    }

    public static class Player {
        private final UUID id;
        private final String name;
        private Rank rank;

        public Player(UUID id, String name, Rank rank) {
            this.id = id;
            this.name = name;
            this.rank = rank;
        }

        public UUID getID() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public Rank getRank() {
            return this.rank;
        }
    }

    public static enum Action {
        ACCESS_HUTS(0),
        GUARDS_ATTACK(1),
        PLACE_HUTS(2),
        BREAK_HUTS(3),
        CAN_PROMOTE(4),
        CAN_DEMOTE(5),
        SEND_MESSAGES(6),
        EDIT_PERMISSIONS(7),
        MANAGE_HUTS(8),
        RECEIVE_MESSAGES(9),
        USE_SCAN_TOOL(10),
        PLACE_BLOCKS(11),
        BREAK_BLOCKS(12),
        TOSS_ITEM(13),
        PICKUP_ITEM(14),
        FILL_BUCKET(15),
        OPEN_CONTAINER(16),
        RIGHTCLICK_BLOCK(17),
        RIGHTCLICK_ENTITY(18),
        THROW_POTION(19),
        SHOOT_ARROW(20),
        ATTACK_CITIZEN(21),
        ATTACK_ENTITY(22),
        ACCESS_FREE_BLOCKS(23),
        TELEPORT_TO_COLONY(24);

        private final int flag;

        private Action(int bit) {
            this.flag = 1 << bit;
        }

        public int getFlag() {
            return this.flag;
        }
    }

    public static enum Rank {
        OWNER(true),
        OFFICER(true),
        FRIEND(true),
        NEUTRAL(false),
        HOSTILE(false);

        public final boolean isSubscriber;

        private Rank(boolean isSubscriber) {
            this.isSubscriber = isSubscriber;
        }
    }
}

