/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.commands;

import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.ColonyManager;
import com.minecolonies.coremod.colony.IColony;
import com.minecolonies.coremod.colony.permissions.Permissions;
import com.minecolonies.coremod.commands.AbstractSingleCommand;
import com.mojang.authlib.GameProfile;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import org.jetbrains.annotations.NotNull;

public class DeleteColonyCommand
extends AbstractSingleCommand {
    public static final String DESC = "delete";
    private static final String NO_COLONY_FOUND_MESSAGE_ID = "Colony with ID %d not found.";
    private static final String NO_ARGUMENTS = "Please define a colony to delete";

    public DeleteColonyCommand(String ... parents) {
        super(parents);
    }

    @Override
    @NotNull
    public String getCommandUsage(@NotNull ICommandSender sender) {
        return super.getCommandUsage(sender) + "<ColonyId|OwnerName>";
    }

    @Override
    public void execute(@NotNull MinecraftServer server, @NotNull ICommandSender sender, String ... args) throws CommandException {
        EntityPlayer player;
        int colonyId;
        IColony colony;
        if (args.length == 0) {
            colony = null;
            if (sender instanceof EntityPlayer) {
                colony = ColonyManager.getIColonyByOwner(((EntityPlayer)sender).worldObj, (EntityPlayer)sender);
            }
            if (colony == null) {
                sender.getCommandSenderEntity().addChatMessage((ITextComponent)new TextComponentString(NO_ARGUMENTS));
                return;
            }
            colonyId = colony.getID();
        } else {
            colonyId = DeleteColonyCommand.getIthArgument(args, 0, -1);
        }
        colony = ColonyManager.getColony(colonyId);
        if (colony == null) {
            sender.getCommandSenderEntity().addChatMessage((ITextComponent)new TextComponentString(NO_COLONY_FOUND_MESSAGE_ID));
            return;
        }
        if (sender instanceof EntityPlayer && !this.canPlayerUseCommand(player = (EntityPlayer)sender, AbstractSingleCommand.Commands.DELETECOLONY, colonyId)) {
            sender.getCommandSenderEntity().addChatMessage((ITextComponent)new TextComponentString("You are not allowed to do that!"));
            return;
        }
        server.addScheduledTask(() -> DeleteColonyCommand.lambda$execute$50((Colony)colony));
    }

    @Override
    public boolean canRankUseCommand(@NotNull Colony colony, @NotNull EntityPlayer player) {
        return colony.getPermissions().getRank(player).equals((Object)Permissions.Rank.OWNER);
    }

    @NotNull
    private static UUID getUUIDFromName(@NotNull ICommandSender sender, String ... args) {
        GameProfile profile;
        MinecraftServer tempServer = sender.getEntityWorld().getMinecraftServer();
        if (tempServer != null && (profile = tempServer.getPlayerProfileCache().getGameProfileForUsername(args[0])) != null) {
            return profile.getId();
        }
        return null;
    }

    @Override
    @NotNull
    public List<String> getTabCompletionOptions(@NotNull MinecraftServer server, @NotNull ICommandSender sender, @NotNull String[] args, @Nullable BlockPos pos) {
        return Collections.emptyList();
    }

    @Override
    public boolean isUsernameIndex(@NotNull String[] args, int index) {
        return index == 0 && args.length > 0 && !args[0].isEmpty() && DeleteColonyCommand.getIthArgument(args, 0, Integer.MAX_VALUE) == Integer.MAX_VALUE;
    }

    private static /* synthetic */ void lambda$execute$50(Colony colony) {
        ColonyManager.deleteColony(colony.getID());
    }
}

