/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity;

import com.minecolonies.coremod.entity.EntityCitizen;
import com.minecolonies.coremod.util.MathUtils;
import java.util.Iterator;
import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class EntityFishHook
extends Entity {
    private static final int TTL = 360;
    private static final float ENTITY_SIZE = 0.25f;
    private static final double HALF_CIRCLE = 180.0;
    private static final double RANDOM_MOVEMENT_OFFSET = (double)0.0075f;
    private static final double INITIAL_MOVEMENT_LIMITER = 0.16;
    private static final double SUNKEN_OFFSET = (double)0.1f;
    private static final double NUM_BOUNDING_BOX_EDGES = 4.0;
    private static final double DISTANCE_FACTOR = 64.0;
    private static final double BOUNCE_MOVEMENT_LIMITER = 0.2;
    private static final float AIR_MOVEMENT_LIMITER = 0.92f;
    private static final double GROUND_MOVEMENT_LIMITER = 0.5;
    private static final double WATER_MOVEMENT_LIMITER = (double)0.04f;
    private static final double NO_CLEAR_SKY_CHANCE = 0.5;
    private static final int INCREASE_RARENESS_MODIFIER = 200;
    private EntityCitizen citizen;
    private int fishingSpeedEnchantment;
    private int fishingLootEnchantment;
    private boolean inGround;
    private int shake;
    private int countdownNoFish;
    private int countdownFishNear;
    private int countdownFishBites;
    private double relativeRotation;
    private final long creationTime;
    private boolean isFishCaugth = false;

    public EntityFishHook(World world, @NotNull EntityCitizen citizen) {
        this(world);
        this.citizen = citizen;
        this.setLocationAndAngles(citizen.posX, citizen.posY + 1.62 - citizen.getYOffset(), citizen.posZ, citizen.rotationYaw, citizen.rotationPitch);
        this.posX -= Math.cos((double)this.rotationYaw / 180.0 * Math.PI) * 0.16;
        this.posY -= (double)0.1f;
        this.posZ -= Math.sin((double)this.rotationYaw / 180.0 * Math.PI) * 0.16;
        this.setPosition(this.posX, this.posY, this.posZ);
        double f = 0.4;
        this.motionX = -Math.sin((double)this.rotationYaw / 180.0 * Math.PI) * Math.cos((double)this.rotationPitch / 180.0 * Math.PI) * 0.4;
        this.motionZ = Math.cos((double)this.rotationYaw / 180.0 * Math.PI) * Math.cos((double)this.rotationPitch / 180.0 * Math.PI) * 0.4;
        this.motionY = -Math.sin((double)this.rotationPitch / 180.0 * Math.PI) * 0.4;
        this.setPosition(this.motionX, this.motionY, this.motionZ, 1.5, 1.0);
        this.fishingSpeedEnchantment = EnchantmentHelper.getLureModifier((EntityLivingBase)citizen);
        this.fishingLootEnchantment = EnchantmentHelper.getLuckOfSeaModifier((EntityLivingBase)citizen);
    }

    public EntityFishHook(World world) {
        super(world);
        this.setSize(0.25f, 0.25f);
        this.ignoreFrustumCheck = true;
        this.creationTime = System.nanoTime();
        this.fishingLootEnchantment = 0;
        this.fishingSpeedEnchantment = 0;
    }

    private void setPosition(double x, double y, double z, double yaw, double pitch) {
        double squareRootXYZ = MathHelper.sqrt_double((double)(x * x + y * y + z * z));
        double newX = x / squareRootXYZ;
        double newY = y / squareRootXYZ;
        double newZ = z / squareRootXYZ;
        newX += this.rand.nextGaussian() * (double)0.0075f * pitch;
        newY += this.rand.nextGaussian() * (double)0.0075f * pitch;
        newZ += this.rand.nextGaussian() * (double)0.0075f * pitch;
        this.motionX = newX *= yaw;
        this.motionY = newY *= yaw;
        this.motionZ = newZ *= yaw;
        this.prevRotationYaw = this.rotationYaw = (float)(Math.atan2(newX, newZ) * 180.0 / Math.PI);
        this.prevRotationPitch = this.rotationPitch = (float)(Math.atan2(newY, Math.sqrt(newX * newX + newZ * newZ)) * 180.0 / Math.PI);
    }

    public EntityCitizen getCitizen() {
        return this.citizen;
    }

    protected void entityInit() {
    }

    public boolean equals(@Nullable Object o) {
        return o != null && ((Object)((Object)this)).getClass() == o.getClass() && super.equals(o);
    }

    public int hashCode() {
        return this.getEntityId();
    }

    public void onUpdate() {
        super.onUpdate();
        if (this.fishHookIsOverTimeToLive()) {
            this.setDead();
        }
        if (this.bounceFromGround() || this.inGround) {
            return;
        }
        this.moveSomeStuff();
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isInRangeToRenderDist(double range) {
        double maxLength = this.getEntityBoundingBox().getAverageEdgeLength() * 4.0;
        return range < (maxLength *= 64.0) * maxLength;
    }

    public void readEntityFromNBT(NBTTagCompound unused) {
        this.setDead();
    }

    public void writeEntityToNBT(NBTTagCompound unused) {
    }

    @SideOnly(value=Side.CLIENT)
    public void setVelocity(double vectorX, double vectorY, double vectorZ) {
        this.motionX = vectorX;
        this.motionY = vectorY;
        this.motionZ = vectorZ;
    }

    public boolean fishHookIsOverTimeToLive() {
        return MathUtils.nanoSecondsToSeconds(System.nanoTime() - this.creationTime) > 360L;
    }

    private boolean bounceFromGround() {
        if (this.shake > 0) {
            --this.shake;
        }
        if (!this.inGround) {
            return false;
        }
        this.inGround = false;
        this.motionX *= this.rand.nextDouble() * 0.2;
        this.motionY *= this.rand.nextDouble() * 0.2;
        this.motionZ *= this.rand.nextDouble() * 0.2;
        return false;
    }

    private void moveSomeStuff() {
        this.updateMotionAndRotation();
        double movementLimiter = 0.92f;
        if (this.onGround || this.isCollidedHorizontally) {
            movementLimiter = 0.5;
        }
        int numSteps = 5;
        double waterDensity = 0.0;
        for (int j = 0; j < 5; ++j) {
            double d3 = this.getEntityBoundingBox().minY + (this.getEntityBoundingBox().maxY - this.getEntityBoundingBox().minY) * (double)j / 5.0;
            double d4 = this.getEntityBoundingBox().minY + (this.getEntityBoundingBox().maxY - this.getEntityBoundingBox().minY) * (double)(j + 1) / 5.0;
            AxisAlignedBB axisAlignedBB1 = new AxisAlignedBB(this.getEntityBoundingBox().minX, d3, this.getEntityBoundingBox().minZ, this.getEntityBoundingBox().maxX, d4, this.getEntityBoundingBox().maxZ);
            if (!this.worldObj.isAABBInMaterial(axisAlignedBB1, Material.WATER)) continue;
            waterDensity += 0.2;
        }
        this.checkIfFishBites(waterDensity);
        double currentDistance = waterDensity * 2.0 - 1.0;
        this.motionY += (double)0.04f * currentDistance;
        if (waterDensity > 0.0) {
            movementLimiter *= 0.9;
            this.motionY *= 0.8;
        }
        this.motionX *= movementLimiter;
        this.motionY *= movementLimiter;
        this.motionZ *= movementLimiter;
        this.setPosition(this.posX, this.posY, this.posZ);
    }

    private void updateMotionAndRotation() {
        this.moveEntity(this.motionX, this.motionY, this.motionZ);
        double motion = Math.sqrt(this.motionX * this.motionX + this.motionZ * this.motionZ);
        this.rotationYaw = (float)(Math.atan2(this.motionY, this.motionZ) * 180.0 / Math.PI);
        this.rotationPitch = (float)(Math.atan2(this.motionY, motion) * 180.0 / Math.PI);
        while ((double)this.rotationPitch - (double)this.prevRotationPitch < -180.0) {
            this.prevRotationPitch = (float)((double)this.prevRotationPitch - 360.0);
        }
        while ((double)this.rotationPitch - (double)this.prevRotationPitch >= 180.0) {
            this.prevRotationPitch = (float)((double)this.prevRotationPitch + 360.0);
        }
        while ((double)this.rotationYaw - (double)this.prevRotationYaw < -180.0) {
            this.prevRotationYaw = (float)((double)this.prevRotationYaw - 360.0);
        }
        while ((double)this.rotationYaw - (double)this.prevRotationYaw >= 180.0) {
            this.prevRotationYaw = (float)((double)this.prevRotationYaw + 360.0);
        }
        this.rotationPitch = (float)((double)this.prevRotationPitch + ((double)this.rotationPitch - (double)this.prevRotationPitch) * 0.2);
        this.rotationYaw = (float)((double)this.prevRotationYaw + ((double)this.rotationYaw - (double)this.prevRotationYaw) * 0.2);
    }

    private void checkIfFishBites(double waterDensity) {
        if (!this.worldObj.isRemote && waterDensity > 0.0) {
            int fishingProgressStep = 1;
            if (this.rand.nextDouble() < 0.5 && !this.worldObj.canBlockSeeSky(new BlockPos(MathHelper.floor_double((double)this.posX), MathHelper.floor_double((double)this.posY) + 1, MathHelper.floor_double((double)this.posZ)))) {
                --fishingProgressStep;
            }
            if (this.countdownNoFish > 0) {
                this.updateNoFishCounter();
                return;
            }
            WorldServer worldServer = (WorldServer)this.worldObj;
            if (this.countdownFishNear > 0) {
                this.renderBubble(fishingProgressStep, worldServer);
                return;
            }
            if (this.countdownFishBites > 0) {
                this.countdownFishBites -= fishingProgressStep;
                this.renderFishBiteOrSwim(worldServer);
            } else {
                this.countdownFishNear = MathHelper.getRandomIntegerInRange((Random)this.rand, (int)100, (int)900);
                this.countdownFishNear -= this.fishingSpeedEnchantment * 20 * 5;
            }
        }
    }

    private void updateNoFishCounter() {
        --this.countdownNoFish;
        if (this.countdownNoFish <= 0) {
            this.countdownFishNear = 0;
            this.countdownFishBites = 0;
        } else {
            this.motionY -= this.rand.nextDouble() * this.rand.nextDouble() * this.rand.nextDouble() * 0.2;
        }
    }

    private void renderBubble(int fishingProgressStep, @NotNull WorldServer worldServer) {
        this.countdownFishNear -= fishingProgressStep;
        double bubbleY = 0.15;
        if (this.countdownFishNear < 20) {
            bubbleY += (double)(20 - this.countdownFishNear) * 0.05;
        } else if (this.countdownFishNear < 40) {
            bubbleY += (double)(40 - this.countdownFishNear) * 0.02;
        } else if (this.countdownFishNear < 60) {
            bubbleY += (double)(60 - this.countdownFishNear) * 0.01;
        }
        if (this.rand.nextDouble() < bubbleY) {
            this.renderLittleSplash(worldServer);
        }
        if (this.countdownFishNear <= 0) {
            this.relativeRotation = MathHelper.randomFloatClamp((Random)this.rand, (float)0.0f, (float)360.0f);
            this.countdownFishBites = MathHelper.getRandomIntegerInRange((Random)this.rand, (int)20, (int)80);
        }
    }

    private void renderFishBiteOrSwim(@NotNull WorldServer worldServer) {
        if (this.countdownFishBites <= 0) {
            this.showFishBiteAnimation(worldServer);
        } else {
            this.showFishSwimmingTowardsHookAnimation(worldServer);
        }
    }

    private void renderLittleSplash(@NotNull WorldServer worldServer) {
        double sinYPosition = (double)MathHelper.randomFloatClamp((Random)this.rand, (float)0.0f, (float)360.0f) * 0.017453292;
        double cosYPosition = MathHelper.randomFloatClamp((Random)this.rand, (float)25.0f, (float)60.0f);
        double bubbleX = this.posX + Math.sin(sinYPosition) * cosYPosition * 0.1;
        double increasedYPosition = Math.floor(this.getEntityBoundingBox().minY) + 1.0;
        double bubbleZ = this.posZ + Math.cos(sinYPosition) * cosYPosition * 0.1;
        worldServer.spawnParticle(EnumParticleTypes.WATER_SPLASH, bubbleX, increasedYPosition, bubbleZ, 2 + this.rand.nextInt(2), (double)0.1f, 0.0, (double)0.1f, 0.0, new int[0]);
    }

    private void showFishBiteAnimation(@NotNull WorldServer worldServer) {
        this.motionY -= (double)0.2f;
        this.playSound(SoundEvents.ENTITY_BOBBER_SPLASH, 0.25f, (float)(1.0 + this.rand.nextGaussian() * 0.4));
        double bubbleY = Math.floor(this.getEntityBoundingBox().minY);
        worldServer.spawnParticle(EnumParticleTypes.WATER_BUBBLE, this.posX, bubbleY + 1.0, this.posZ, (int)(1.0 + (double)this.width * 20.0), (double)this.width, 0.0, (double)this.width, (double)0.2f, new int[0]);
        worldServer.spawnParticle(EnumParticleTypes.WATER_WAKE, this.posX, bubbleY + 1.0, this.posZ, (int)(1.0 + (double)this.width * 20.0), (double)this.width, 0.0, (double)this.width, (double)0.2f, new int[0]);
        this.countdownNoFish = MathHelper.getRandomIntegerInRange((Random)this.rand, (int)10, (int)30);
        this.isFishCaugth = true;
    }

    private void showFishSwimmingTowardsHookAnimation(@NotNull WorldServer worldServer) {
        this.relativeRotation += this.rand.nextGaussian() * 4.0;
        double bubbleY = this.relativeRotation * 0.017453292;
        double sinYPosition = Math.sin(bubbleY);
        double cosYPosition = Math.cos(bubbleY);
        double bubbleX = this.posX + sinYPosition * (double)this.countdownFishBites * 0.1;
        double increasedYPosition = Math.floor(this.getEntityBoundingBox().minY) + 1.0;
        double bubbleZ = this.posZ + cosYPosition * (double)this.countdownFishBites * 0.1;
        if (this.rand.nextDouble() < 0.15) {
            worldServer.spawnParticle(EnumParticleTypes.WATER_BUBBLE, bubbleX, increasedYPosition - (double)0.1f, bubbleZ, 1, sinYPosition, 0.1, cosYPosition, 0.0, new int[0]);
        }
        double f3 = sinYPosition * 0.04;
        double f4 = cosYPosition * 0.04;
        worldServer.spawnParticle(EnumParticleTypes.WATER_WAKE, bubbleX, increasedYPosition, bubbleZ, 0, f4, 0.01, -f3, 1.0, new int[0]);
        worldServer.spawnParticle(EnumParticleTypes.WATER_WAKE, bubbleX, increasedYPosition, bubbleZ, 0, -f4, 0.01, f3, 1.0, new int[0]);
    }

    public int getDamage(@NotNull EntityCitizen citizen) {
        if (this.worldObj.isRemote) {
            this.setDead();
            return 0;
        }
        int itemDamage = 0;
        if (this.isFishCaugth) {
            if (this.countdownNoFish > 0) {
                this.spawnLootAndExp(citizen);
                itemDamage = 1;
            }
            if (this.inGround) {
                itemDamage = 0;
            }
        }
        this.setDead();
        return itemDamage;
    }

    private void spawnLootAndExp(@NotNull EntityCitizen citizen) {
        double citizenPosX = citizen.posX;
        double citizenPosY = citizen.posY;
        double citizenPosZ = citizen.posZ;
        EntityItem entityitem = new EntityItem(this.worldObj, this.posX, this.posY, this.posZ, this.getFishingLoot(citizen));
        double distanceX = citizenPosX - this.posX;
        double distanceY = citizenPosY - this.posY;
        double distanceZ = citizenPosZ - this.posZ;
        entityitem.motionX = distanceX * 0.1;
        entityitem.motionY = distanceY * 0.1 + Math.sqrt(Math.sqrt(distanceX * distanceX + distanceY * distanceY + distanceZ * distanceZ)) * 0.08;
        entityitem.motionZ = distanceZ * 0.1;
        this.worldObj.spawnEntityInWorld((Entity)entityitem);
        citizen.worldObj.spawnEntityInWorld((Entity)new EntityXPOrb(citizen.worldObj, citizenPosX, citizenPosY + 0.0, citizenPosZ + 0.5, this.rand.nextInt(6) + 1));
    }

    private ItemStack getFishingLoot(EntityCitizen citizen) {
        int lootBonus;
        int buildingLevel;
        int random = this.worldObj.rand.nextInt(200);
        if (random >= (buildingLevel = citizen.getWorkBuilding().getBuildingLevel()) * ((lootBonus = MathHelper.clamp_int((int)(this.fishingLootEnchantment - this.fishingSpeedEnchantment), (int)0, (int)Integer.MAX_VALUE)) + 1) || buildingLevel == 1) {
            if (random >= 200 - buildingLevel * (lootBonus + 1) && buildingLevel >= 2) {
                return this.getLootForLootTable(LootTableList.GAMEPLAY_FISHING_JUNK);
            }
            return this.getLootForLootTable(LootTableList.GAMEPLAY_FISHING_FISH);
        }
        return this.getLootForLootTable(LootTableList.GAMEPLAY_FISHING_TREASURE);
    }

    private ItemStack getLootForLootTable(ResourceLocation lootTable) {
        LootContext.Builder lootContextBuilder = new LootContext.Builder((WorldServer)this.worldObj);
        Iterator iterator = this.worldObj.getLootTableManager().getLootTableFromLocation(lootTable).generateLootForPools(this.rand, lootContextBuilder.build()).iterator();
        if (iterator.hasNext()) {
            ItemStack itemstack = (ItemStack)iterator.next();
            return itemstack;
        }
        return null;
    }

    public boolean caughtFish() {
        return this.isFishCaugth;
    }
}

