/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.citizen.builder;

import com.minecolonies.coremod.blocks.AbstractBlockHut;
import com.minecolonies.coremod.blocks.ModBlocks;
import com.minecolonies.coremod.colony.buildings.AbstractBuilding;
import com.minecolonies.coremod.colony.workorders.WorkOrderBuild;
import com.minecolonies.coremod.colony.workorders.WorkOrderBuildDecoration;
import com.minecolonies.coremod.configuration.Configurations;
import com.minecolonies.coremod.util.BlockUtils;
import com.minecolonies.coremod.util.StructureWrapper;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Mirror;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

public final class ConstructionTapeHelper {
    public static final PropertyDirection FACING = BlockHorizontal.FACING;
    public static final int MINHEIGHT = 1;
    public static final int MAXHEIGHT = 256;

    private ConstructionTapeHelper() {
    }

    public static int checkIfPlaceable(@NotNull int x, @NotNull int y, @NotNull int z, @NotNull World world) {
        int newY = y;
        boolean working = true;
        while (working) {
            BlockPos block = new BlockPos(x, newY, z);
            BlockPos blockMin1 = new BlockPos(x, newY - 1, z);
            if (world.getBlockState(block).getMaterial().isReplaceable()) {
                if (world.getBlockState(blockMin1).getMaterial().isReplaceable() && newY >= 1) {
                    --newY;
                    continue;
                }
                working = false;
                continue;
            }
            ++newY;
        }
        return newY > 0 ? newY : y;
    }

    public static void removeTapeIfNecessary(@NotNull World world, @NotNull BlockPos block, @NotNull Block tapeOrTapeCorner) {
        for (int y = 1; y <= 256; ++y) {
            BlockPos newBlock = new BlockPos(block.getX(), y, block.getZ());
            if (world.getBlockState(newBlock).getBlock() != tapeOrTapeCorner) continue;
            world.setBlockState(newBlock, Blocks.AIR.getDefaultState());
            break;
        }
    }

    public static void placeConstructionTape(@NotNull AbstractBuilding building, @NotNull World world) {
        ConstructionTapeHelper.placeConstructionTape(new WorkOrderBuild(building, 1), world);
    }

    public static void placeConstructionTape(@NotNull WorkOrderBuild workOrder, @NotNull World world) {
        if (Configurations.builderPlaceConstructionTape) {
            BlockPos row4;
            BlockPos row3;
            BlockPos row2;
            BlockPos row1;
            int newY;
            int i;
            StructureWrapper wrapper = new StructureWrapper(world, workOrder.getStructureName());
            BlockPos pos = workOrder.getBuildingLocation();
            int tempRotation = 0;
            IBlockState constructionTape = ModBlocks.blockConstructionTape.getDefaultState();
            IBlockState constructionTapeCorner = ModBlocks.blockConstructionTapeCorner.getDefaultState();
            if (workOrder.getRotation() == 0 && !(workOrder instanceof WorkOrderBuildDecoration)) {
                IBlockState blockState = world.getBlockState(pos);
                if (blockState.getBlock() instanceof AbstractBlockHut) {
                    tempRotation = BlockUtils.getRotationFromFacing((EnumFacing)blockState.getValue((IProperty)AbstractBlockHut.FACING));
                }
            } else {
                tempRotation = workOrder.getRotation();
            }
            wrapper.rotate(tempRotation, world, workOrder.getBuildingLocation(), workOrder.isMirrored() ? Mirror.FRONT_BACK : Mirror.NONE);
            wrapper.setPosition(pos);
            int x1 = wrapper.getPosition().getX() - wrapper.getOffset().getX() - 1;
            int z1 = wrapper.getPosition().getZ() - wrapper.getOffset().getZ() - 1;
            int x3 = wrapper.getPosition().getX() + (wrapper.getWidth() - wrapper.getOffset().getX());
            int z3 = wrapper.getPosition().getZ() + (wrapper.getLength() - wrapper.getOffset().getZ());
            int y = wrapper.getPosition().getY();
            if (x1 < x3) {
                for (i = x1 + 1; i < x3; ++i) {
                    newY = ConstructionTapeHelper.checkIfPlaceable(i, y, z1, world);
                    row1 = new BlockPos(i, newY, z1);
                    world.setBlockState(row1, constructionTape.withProperty((IProperty)FACING, (Comparable)EnumFacing.SOUTH));
                    newY = ConstructionTapeHelper.checkIfPlaceable(i, y, z3, world);
                    row2 = new BlockPos(i, newY, z3);
                    world.setBlockState(row2, constructionTape.withProperty((IProperty)FACING, (Comparable)EnumFacing.NORTH));
                }
            } else {
                for (i = x3 + 1; i < x1; ++i) {
                    newY = ConstructionTapeHelper.checkIfPlaceable(i, y, z1, world);
                    row1 = new BlockPos(i, newY, z1);
                    world.setBlockState(row1, constructionTape.withProperty((IProperty)FACING, (Comparable)EnumFacing.SOUTH));
                    newY = ConstructionTapeHelper.checkIfPlaceable(i, y, z3, world);
                    row2 = new BlockPos(i, newY, z3);
                    world.setBlockState(row2, constructionTape.withProperty((IProperty)FACING, (Comparable)EnumFacing.NORTH));
                }
            }
            if (z1 < z3) {
                for (i = z1 + 1; i < z3; ++i) {
                    newY = ConstructionTapeHelper.checkIfPlaceable(x1, y, i, world);
                    row3 = new BlockPos(x1, newY, i);
                    world.setBlockState(row3, constructionTape.withProperty((IProperty)FACING, (Comparable)EnumFacing.EAST));
                    newY = ConstructionTapeHelper.checkIfPlaceable(x3, y, i, world);
                    row4 = new BlockPos(x3, newY, i);
                    world.setBlockState(row4, constructionTape.withProperty((IProperty)FACING, (Comparable)EnumFacing.WEST));
                }
            } else {
                for (i = z3 + 1; i < z1; ++i) {
                    newY = ConstructionTapeHelper.checkIfPlaceable(x1, y, i, world);
                    row3 = new BlockPos(x1, newY, i);
                    world.setBlockState(row3, constructionTape.withProperty((IProperty)FACING, (Comparable)EnumFacing.EAST));
                    newY = ConstructionTapeHelper.checkIfPlaceable(x3, y, i, world);
                    row4 = new BlockPos(x3, newY, i);
                    world.setBlockState(row4, constructionTape.withProperty((IProperty)FACING, (Comparable)EnumFacing.WEST));
                }
            }
            newY = ConstructionTapeHelper.checkIfPlaceable(x1, y, z1, world);
            BlockPos corner1 = new BlockPos(x1, newY, z1);
            newY = ConstructionTapeHelper.checkIfPlaceable(x1, y, z3, world);
            BlockPos corner2 = new BlockPos(x1, newY, z3);
            newY = ConstructionTapeHelper.checkIfPlaceable(x3, y, z1, world);
            BlockPos corner3 = new BlockPos(x3, newY, z1);
            newY = ConstructionTapeHelper.checkIfPlaceable(x3, y, z3, world);
            BlockPos corner4 = new BlockPos(x3, newY, z3);
            world.setBlockState(corner1, constructionTapeCorner.withProperty((IProperty)FACING, (Comparable)EnumFacing.SOUTH));
            world.setBlockState(corner2, constructionTapeCorner.withProperty((IProperty)FACING, (Comparable)EnumFacing.EAST));
            world.setBlockState(corner3, constructionTapeCorner.withProperty((IProperty)FACING, (Comparable)EnumFacing.WEST));
            world.setBlockState(corner4, constructionTapeCorner.withProperty((IProperty)FACING, (Comparable)EnumFacing.NORTH));
        }
    }

    public static void removeConstructionTape(@NotNull AbstractBuilding building, @NotNull World world) {
        ConstructionTapeHelper.removeConstructionTape(new WorkOrderBuild(building, 1), world);
    }

    public static void removeConstructionTape(@NotNull WorkOrderBuild workOrder, @NotNull World world) {
        BlockPos block2;
        BlockPos block1;
        int i;
        StructureWrapper wrapper = new StructureWrapper(world, workOrder.getStructureName());
        BlockPos pos = workOrder.getBuildingLocation();
        int tempRotation = 0;
        if (workOrder.getRotation() == 0 && !(workOrder instanceof WorkOrderBuildDecoration)) {
            IBlockState blockState = world.getBlockState(pos);
            if (blockState.getBlock() instanceof AbstractBlockHut) {
                tempRotation = BlockUtils.getRotationFromFacing((EnumFacing)blockState.getValue((IProperty)AbstractBlockHut.FACING));
            }
        } else {
            tempRotation = workOrder.getRotation();
        }
        wrapper.rotate(tempRotation, world, workOrder.getBuildingLocation(), workOrder.isMirrored() ? Mirror.FRONT_BACK : Mirror.NONE);
        wrapper.setPosition(pos);
        int x1 = wrapper.getPosition().getX() - wrapper.getOffset().getX() - 1;
        int z1 = wrapper.getPosition().getZ() - wrapper.getOffset().getZ() - 1;
        int x3 = wrapper.getPosition().getX() + (wrapper.getWidth() - wrapper.getOffset().getX());
        int z3 = wrapper.getPosition().getZ() + (wrapper.getLength() - wrapper.getOffset().getZ());
        if (x1 < x3) {
            for (i = x1; i <= x3; ++i) {
                block1 = new BlockPos(i, 0, z1);
                block2 = new BlockPos(i, 0, z3);
                ConstructionTapeHelper.removeTapeIfNecessary(world, block1, ModBlocks.blockConstructionTape);
                ConstructionTapeHelper.removeTapeIfNecessary(world, block2, ModBlocks.blockConstructionTape);
            }
        } else {
            for (i = x3; i <= x1; ++i) {
                block1 = new BlockPos(i, 0, z1);
                block2 = new BlockPos(i, 0, z3);
                ConstructionTapeHelper.removeTapeIfNecessary(world, block1, ModBlocks.blockConstructionTape);
                ConstructionTapeHelper.removeTapeIfNecessary(world, block2, ModBlocks.blockConstructionTape);
            }
        }
        if (z1 < z3) {
            for (i = z1; i <= z3; ++i) {
                block1 = new BlockPos(x1, 0, i);
                block2 = new BlockPos(x3, 0, i);
                ConstructionTapeHelper.removeTapeIfNecessary(world, block1, ModBlocks.blockConstructionTape);
                ConstructionTapeHelper.removeTapeIfNecessary(world, block2, ModBlocks.blockConstructionTape);
            }
        } else {
            for (i = z3; i <= z1; ++i) {
                block1 = new BlockPos(x1, 0, i);
                block2 = new BlockPos(x3, 0, i);
                ConstructionTapeHelper.removeTapeIfNecessary(world, block1, ModBlocks.blockConstructionTape);
                ConstructionTapeHelper.removeTapeIfNecessary(world, block2, ModBlocks.blockConstructionTape);
            }
        }
        BlockPos corner1 = new BlockPos(x1, 0, z1);
        BlockPos corner2 = new BlockPos(x1, 0, z3);
        BlockPos corner3 = new BlockPos(x3, 0, z1);
        BlockPos corner4 = new BlockPos(x3, 0, z3);
        ConstructionTapeHelper.removeTapeIfNecessary(world, corner1, ModBlocks.blockConstructionTapeCorner);
        ConstructionTapeHelper.removeTapeIfNecessary(world, corner2, ModBlocks.blockConstructionTapeCorner);
        ConstructionTapeHelper.removeTapeIfNecessary(world, corner3, ModBlocks.blockConstructionTapeCorner);
        ConstructionTapeHelper.removeTapeIfNecessary(world, corner4, ModBlocks.blockConstructionTapeCorner);
    }
}

