/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.citizen.deliveryman;

import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.buildings.AbstractBuilding;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingWorker;
import com.minecolonies.coremod.colony.buildings.BuildingBuilder;
import com.minecolonies.coremod.colony.buildings.BuildingDeliveryman;
import com.minecolonies.coremod.colony.buildings.BuildingTownHall;
import com.minecolonies.coremod.colony.buildings.BuildingWareHouse;
import com.minecolonies.coremod.colony.jobs.JobDeliveryman;
import com.minecolonies.coremod.entity.ai.basic.AbstractEntityAIInteract;
import com.minecolonies.coremod.entity.ai.item.handling.ItemStorage;
import com.minecolonies.coremod.entity.ai.util.AIState;
import com.minecolonies.coremod.entity.ai.util.AITarget;
import com.minecolonies.coremod.inventory.InventoryCitizen;
import com.minecolonies.coremod.tileentities.TileEntityColonyBuilding;
import com.minecolonies.coremod.util.InventoryUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityAIWorkDeliveryman
extends AbstractEntityAIInteract<JobDeliveryman> {
    private static final int MIN_DISTANCE_TO_WAREHOUSE = 5;
    private static final double WALKING_SPEED_MULTIPLIER = 25.0;
    private static final int MIN_DISTANCE_TO_CHEST = 2;
    private static final double BASE_MOVEMENT_SPEED = 0.2;
    private static final int DUMP_AND_GATHER_DELAY = 10;
    private BuildingWareHouse wareHouse = null;
    private List<ItemStack> itemsToDeliver = new ArrayList<ItemStack>();
    private BlockPos gatherTarget = null;
    private int currentSlot = 0;
    private List<ItemStorage> alreadyKept = new ArrayList<ItemStorage>();

    public EntityAIWorkDeliveryman(@NotNull JobDeliveryman deliveryman) {
        super(deliveryman);
        super.registerTargets(new AITarget(this::checkIfExecute, AIState.IDLE), new AITarget(AIState.IDLE, () -> AIState.START_WORKING), new AITarget(AIState.START_WORKING, this::checkWareHouse), new AITarget(AIState.PREPARE_DELIVERY, this::prepareDelivery), new AITarget(AIState.GATHER_IN_WAREHOUSE, this::gatherItemsFromWareHouse), new AITarget(AIState.DELIVERY, this::deliver), new AITarget(AIState.GATHERING, this::gather), new AITarget(AIState.DUMPING, this::dump));
        this.worker.setSkillModifier(2 * this.worker.getCitizenData().getEndurance() + this.worker.getCitizenData().getCharisma());
        this.worker.setCanPickUpLoot(true);
    }

    public AIState gather() {
        if (this.gatherTarget == null) {
            this.gatherTarget = this.getRandomBuilding();
        }
        if (this.gatherTarget == null) {
            return AIState.START_WORKING;
        }
        if (!this.worker.isWorkerAtSiteWithMove(this.gatherTarget, 5)) {
            return AIState.GATHERING;
        }
        Colony colony = this.getOwnBuilding().getColony();
        if (colony != null) {
            AbstractBuilding building = colony.getBuilding(this.gatherTarget);
            if (building == null) {
                this.gatherTarget = null;
                return AIState.START_WORKING;
            }
            if (this.gatherFromBuilding(building) || this.cannotHoldMoreItems()) {
                this.alreadyKept = new ArrayList<ItemStorage>();
                this.currentSlot = 0;
                return AIState.DUMPING;
            }
            ++this.currentSlot;
            return AIState.GATHERING;
        }
        return AIState.START_WORKING;
    }

    private boolean cannotHoldMoreItems() {
        if (this.getOwnBuilding().getBuildingLevel() >= this.getOwnBuilding().getMaxBuildingLevel()) {
            return false;
        }
        return (double)InventoryUtils.getAmountOfStacksInItemHandler((IItemHandler)new InvWrapper((IInventory)this.worker.getInventoryCitizen())) >= Math.pow(2.0, (double)this.getOwnBuilding().getBuildingLevel() - 1.0);
    }

    private boolean gatherFromBuilding(@NotNull AbstractBuilding building) {
        if (this.currentSlot >= building.getTileEntity().getSizeInventory()) {
            return true;
        }
        ItemStack stack = building.getTileEntity().getStackInSlot(this.currentSlot);
        if (stack == null || EntityAIWorkDeliveryman.workerRequiresItem(building, stack, this.alreadyKept)) {
            return false;
        }
        InventoryUtils.transferItemStackIntoNextFreeSlotInItemHandlers(building.getTileEntity().getSingleChestHandler(), this.currentSlot, (IItemHandler)new InvWrapper((IInventory)this.worker.getInventoryCitizen()));
        building.markDirty();
        this.setDelay(10);
        return false;
    }

    private static boolean buildingRequiresCertainAmountOfItem(AbstractBuilding building, ItemStack stack, List<ItemStorage> localAlreadyKept) {
        for (Map.Entry<ItemStorage, Integer> entry : building.getRequiredItemsAndAmount().entrySet()) {
            if (entry.getKey().getItem() != stack.getItem() || entry.getKey().getDamageValue() != stack.getItemDamage() || localAlreadyKept.contains(entry.getKey())) continue;
            localAlreadyKept.add(entry.getKey());
            return true;
        }
        return false;
    }

    public static boolean workerRequiresItem(AbstractBuilding building, ItemStack stack, List<ItemStorage> localAlreadyKept) {
        return building instanceof BuildingBuilder && ((BuildingBuilder)building).requiresResourceForBuilding(stack) || building instanceof AbstractBuildingWorker && ((AbstractBuildingWorker)building).neededForWorker(stack) || EntityAIWorkDeliveryman.buildingRequiresCertainAmountOfItem(building, stack, localAlreadyKept);
    }

    @Nullable
    private BlockPos getRandomBuilding() {
        int random;
        if (this.worker.getColony() == null || this.getOwnBuilding() == null) {
            return null;
        }
        Collection<AbstractBuilding> buildingList = this.worker.getColony().getBuildings().values();
        Object[] buildingArray = buildingList.toArray();
        AbstractBuilding building = (AbstractBuilding)buildingArray[random = this.worker.getRandom().nextInt(buildingArray.length)];
        if (building instanceof BuildingWareHouse || building instanceof BuildingTownHall) {
            return null;
        }
        return building.getLocation();
    }

    public AIState dump() {
        if (!this.worker.isWorkerAtSiteWithMove(this.wareHouse.getLocation(), 5)) {
            return AIState.DUMPING;
        }
        this.wareHouse.getTileEntity().dumpInventoryIntoWareHouse(this.worker.getInventoryCitizen());
        this.gatherTarget = null;
        return AIState.START_WORKING;
    }

    private AIState deliver() {
        AbstractBuilding buildingToDeliver;
        AbstractBuildingWorker ownBuilding = this.getOwnBuilding();
        if (ownBuilding instanceof BuildingDeliveryman && (buildingToDeliver = ((BuildingDeliveryman)ownBuilding).getBuildingToDeliver()) != null) {
            if (!this.worker.isWorkerAtSiteWithMove(buildingToDeliver.getLocation(), 5)) {
                return AIState.DELIVERY;
            }
            InventoryCitizen workerInventory = this.worker.getInventoryCitizen();
            for (int i = 0; i < new InvWrapper((IInventory)this.worker.getInventoryCitizen()).getSlots(); ++i) {
                ItemStack stack = workerInventory.getStackInSlot(i);
                if (stack == null) continue;
                if (buildingToDeliver.transferStack(stack, this.world)) {
                    new InvWrapper((IInventory)this.worker.getInventoryCitizen()).extractItem(i, Integer.MAX_VALUE, false);
                    continue;
                }
                ItemStack tempStack = buildingToDeliver.forceTransferStack(stack, this.world);
                if (tempStack == null) {
                    this.chatSpamFilter.talkWithoutSpam("com.minecolonies.coremod.job.deliveryman.workerChestFull", new TextComponentString(" :" + buildingToDeliver.getSchematicName()));
                    continue;
                }
                InventoryUtils.addItemStackToItemHandler((IItemHandler)new InvWrapper((IInventory)this.worker.getInventoryCitizen()), tempStack);
            }
            this.worker.addExperience(1.0);
            buildingToDeliver.setOnGoingDelivery(false);
            ((BuildingDeliveryman)ownBuilding).setBuildingToDeliver(null);
        }
        return AIState.START_WORKING;
    }

    private AIState prepareDelivery() {
        AbstractBuilding buildingToDeliver;
        AbstractBuildingWorker ownBuilding = this.getOwnBuilding();
        if (ownBuilding instanceof BuildingDeliveryman && (buildingToDeliver = ((BuildingDeliveryman)ownBuilding).getBuildingToDeliver()) != null) {
            boolean ableToDeliver = this.wareHouse.getTileEntity().checkInWareHouse(buildingToDeliver, false);
            if (!ableToDeliver) {
                buildingToDeliver.setOnGoingDelivery(false);
                return AIState.START_WORKING;
            }
            this.itemsToDeliver = new ArrayList<ItemStack>(buildingToDeliver.getNeededItems());
            return AIState.GATHER_IN_WAREHOUSE;
        }
        return AIState.START_WORKING;
    }

    private AIState gatherItemsFromWareHouse() {
        AbstractBuilding buildingToDeliver;
        AbstractBuildingWorker ownBuilding = this.getOwnBuilding();
        if (ownBuilding instanceof BuildingDeliveryman && (buildingToDeliver = ((BuildingDeliveryman)ownBuilding).getBuildingToDeliver()) != null) {
            if (this.itemsToDeliver.isEmpty() && this.hasTools(buildingToDeliver)) {
                return AIState.DELIVERY;
            }
            if (this.gatherItems(buildingToDeliver)) {
                this.setDelay(10);
                return AIState.GATHER_IN_WAREHOUSE;
            }
            ((BuildingDeliveryman)ownBuilding).setBuildingToDeliver(null);
            this.itemsToDeliver.clear();
            return AIState.START_WORKING;
        }
        return AIState.START_WORKING;
    }

    private boolean hasTools(@NotNull AbstractBuilding buildingToDeliver) {
        String requiredTool = buildingToDeliver.getRequiredTool();
        if (requiredTool.isEmpty()) {
            return true;
        }
        if (requiredTool.equals("pickaxe")) {
            return InventoryUtils.isPickaxeInItemHandler((IItemHandler)new InvWrapper((IInventory)this.worker.getInventoryCitizen()), buildingToDeliver.getNeededPickaxeLevel(), buildingToDeliver.getBuildingLevel());
        }
        return InventoryUtils.isToolInItemHandler((IItemHandler)new InvWrapper((IInventory)this.worker.getInventoryCitizen()), requiredTool, buildingToDeliver.getBuildingLevel());
    }

    private boolean gatherItems(@NotNull AbstractBuilding buildingToDeliver) {
        BlockPos position;
        if (this.itemsToDeliver.isEmpty()) {
            String tool = buildingToDeliver.getRequiredTool();
            position = this.wareHouse.getTileEntity().getPositionOfChestWithTool(tool, "pickaxe".equals(tool) ? buildingToDeliver.getNeededPickaxeLevel() : buildingToDeliver.getBuildingLevel(), buildingToDeliver);
        } else {
            ItemStack stack = this.itemsToDeliver.get(0);
            position = this.wareHouse.getTileEntity().getPositionOfChestWithItemStack(stack);
        }
        if (position == null) {
            return false;
        }
        if (!this.worker.isWorkerAtSiteWithMove(position, 2)) {
            return true;
        }
        TileEntity tileEntity = this.world.getTileEntity(position);
        if (tileEntity instanceof TileEntityChest) {
            if (!(tileEntity instanceof TileEntityColonyBuilding)) {
                if (((TileEntityChest)tileEntity).numPlayersUsing == 0) {
                    this.world.addBlockEvent(tileEntity.getPos(), tileEntity.getBlockType(), 1, 1);
                    this.world.notifyNeighborsOfStateChange(tileEntity.getPos(), tileEntity.getBlockType());
                    this.world.notifyNeighborsOfStateChange(tileEntity.getPos().down(), tileEntity.getBlockType());
                    this.setDelay(10);
                    return true;
                }
                this.world.addBlockEvent(tileEntity.getPos(), tileEntity.getBlockType(), 1, 0);
                this.world.notifyNeighborsOfStateChange(tileEntity.getPos(), tileEntity.getBlockType());
                this.world.notifyNeighborsOfStateChange(tileEntity.getPos().down(), tileEntity.getBlockType());
            }
            if (this.itemsToDeliver.isEmpty() && !this.isToolInTileEntity((TileEntityChest)tileEntity, buildingToDeliver.getRequiredTool(), buildingToDeliver.getBuildingLevel())) {
                return false;
            }
            if (!this.itemsToDeliver.isEmpty()) {
                ItemStack stack = this.itemsToDeliver.get(0);
                if (this.isInTileEntity((TileEntityChest)tileEntity, stack)) {
                    this.itemsToDeliver.remove(0);
                    return true;
                }
                return false;
            }
        }
        return true;
    }

    private AIState checkWareHouse() {
        if (!this.worker.isWorkerAtSiteWithMove(this.wareHouse.getLocation(), 5)) {
            return AIState.START_WORKING;
        }
        AbstractBuildingWorker ownBuilding = this.getOwnBuilding();
        AbstractBuilding buildingToDeliver = this.wareHouse.getTileEntity().getTask();
        if (ownBuilding instanceof BuildingDeliveryman) {
            if (buildingToDeliver == null) {
                ((BuildingDeliveryman)ownBuilding).setBuildingToDeliver(null);
                return AIState.GATHERING;
            }
            ((BuildingDeliveryman)ownBuilding).setBuildingToDeliver(buildingToDeliver);
        }
        return AIState.PREPARE_DELIVERY;
    }

    private boolean checkIfExecute() {
        this.worker.setAIMoveSpeed((float)(0.2 + 0.2 * (double)this.worker.getLevel() / 25.0));
        if (this.wareHouse != null && this.wareHouse.getTileEntity() != null) {
            return false;
        }
        Map<BlockPos, AbstractBuilding> buildings = ((JobDeliveryman)this.job).getColony().getBuildings();
        for (AbstractBuilding building : buildings.values()) {
            if (building == null) continue;
            Colony buildingColony = building.getColony();
            Colony ownColony = this.worker.getColony();
            if (!(building instanceof BuildingWareHouse) || ownColony == null || buildingColony == null || buildingColony.getID() != ownColony.getID() || !((BuildingWareHouse)building).registerWithWareHouse((BuildingDeliveryman)this.getOwnBuilding())) continue;
            this.wareHouse = (BuildingWareHouse)building;
            return false;
        }
        this.chatSpamFilter.talkWithoutSpam("com.minecolonies.coremod.job.deliveryman.noWarehouse", new Object[0]);
        return true;
    }
}

