/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.citizen.farmer;

import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.ColonyManager;
import com.minecolonies.coremod.colony.permissions.Permissions;
import com.minecolonies.coremod.inventory.InventoryField;
import com.minecolonies.coremod.tileentities.ScarecrowTileEntity;
import com.minecolonies.coremod.util.BlockPosUtil;
import com.minecolonies.coremod.util.LanguageHandler;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Field
extends Container {
    private static final int MAX_INVENTORY_INDEX = 28;
    private static final int INVENTORY_BAR_SIZE = 8;
    private static final int X_OFFSET = 80;
    private static final int Y_OFFSET = 34;
    private static final String TAG_LOCATION = "location";
    private static final String TAG_TAKEN = "taken";
    private static final String TAG_LENGTH_PLUS = "length+";
    private static final String TAG_WIDTH_PLUS = "width+";
    private static final String TAG_LENGTH_MINUS = "length-";
    private static final String TAG_WIDTH_MINUS = "width-";
    private static final String TAG_STAGE = "stage";
    private static final String TAG_OWNER = "owner";
    private static final String TAG_INITIALIZED = "initialized";
    private static final int PLAYER_INVENTORY_ROWS = 3;
    private static final int PLAYER_INVENTORY_COLUMNS = 9;
    private static final int PLAYER_INVENTORY_INITIAL_X_OFFSET = 8;
    private static final int PLAYER_INVENTORY_INITIAL_Y_OFFSET = 84;
    private static final int PLAYER_INVENTORY_OFFSET_EACH = 18;
    private static final int PLAYER_INVENTORY_HOTBAR_OFFSET = 142;
    private static final int MAX_RANGE = 5;
    @Nullable
    private final Colony colony;
    private BlockPos location;
    private boolean taken = false;
    private boolean needsWork = true;
    private boolean initialized = false;
    private FieldStage fieldStage = FieldStage.EMPTY;
    private int lengthPlusX;
    private int widthPlusZ;
    private int lengthMinusX;
    private int widthMinusZ;
    private InventoryField inventory;
    @NotNull
    private String owner = "";

    private Field(Colony colony) {
        this.colony = colony;
    }

    public Field(@NotNull ScarecrowTileEntity scarecrowTileEntity, InventoryPlayer playerInventory, @NotNull World world, @NotNull BlockPos location) {
        int i;
        this.colony = ColonyManager.getColony(world, location);
        this.location = location;
        this.inventory = scarecrowTileEntity.getInventoryField();
        this.addSlotToContainer(new Slot((IInventory)this.inventory, 0, 80, 34));
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlotToContainer(new Slot((IInventory)playerInventory, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.addSlotToContainer(new Slot((IInventory)playerInventory, i, 8 + i * 18, 142));
        }
    }

    protected final Slot addSlotToContainer(Slot slotToAdd) {
        return super.addSlotToContainer(slotToAdd);
    }

    @Nullable
    public ItemStack transferStackInSlot(@NotNull EntityPlayer playerIn, int slotIndex) {
        if (slotIndex == 0) {
            playerIn.inventory.addItemStackToInventory(this.inventory.getStackInSlot(0));
            this.inventory.setInventorySlotContents(0, null);
        } else if (this.inventory.getStackInSlot(0) == null) {
            int playerIndex;
            int n = playerIndex = slotIndex < 28 ? slotIndex + 8 : slotIndex - 28;
            if (playerIn.inventory.getStackInSlot(playerIndex) != null) {
                ItemStack stack = playerIn.inventory.getStackInSlot(playerIndex).splitStack(1);
                this.inventory.setInventorySlotContents(0, stack);
                if (playerIn.inventory.getStackInSlot((int)playerIndex).stackSize == 0) {
                    playerIn.inventory.removeStackFromSlot(playerIndex);
                }
            }
        }
        return null;
    }

    public boolean canInteractWith(@NotNull EntityPlayer playerIn) {
        return this.getColony().getPermissions().hasPermission(playerIn, Permissions.Action.ACCESS_HUTS);
    }

    @Nullable
    public Colony getColony() {
        return this.colony;
    }

    @NotNull
    public static Field createFromNBT(Colony colony, @NotNull NBTTagCompound compound) {
        Field field = new Field(colony);
        field.readFromNBT(compound);
        return field;
    }

    public void readFromNBT(@NotNull NBTTagCompound compound) {
        this.location = BlockPosUtil.readFromNBT(compound, TAG_LOCATION);
        this.taken = compound.getBoolean(TAG_TAKEN);
        this.fieldStage = FieldStage.values()[compound.getInteger(TAG_STAGE)];
        this.lengthPlusX = compound.getInteger(TAG_LENGTH_PLUS);
        this.widthPlusZ = compound.getInteger(TAG_WIDTH_PLUS);
        this.lengthMinusX = compound.getInteger(TAG_LENGTH_MINUS);
        this.widthMinusZ = compound.getInteger(TAG_WIDTH_MINUS);
        this.inventory = new InventoryField("");
        this.inventory.readFromNBT(compound);
        this.setOwner(compound.getString(TAG_OWNER));
        this.initialized = compound.getBoolean(TAG_INITIALIZED);
    }

    private static int getMaxRange() {
        return 5;
    }

    public final void calculateSize(@NotNull World world, @NotNull BlockPos position) {
        this.lengthPlusX = this.searchNextBlock(0, position.east(), EnumFacing.EAST, world);
        this.lengthMinusX = this.searchNextBlock(0, position.west(), EnumFacing.WEST, world);
        this.widthPlusZ = this.searchNextBlock(0, position.south(), EnumFacing.SOUTH, world);
        this.widthMinusZ = this.searchNextBlock(0, position.north(), EnumFacing.NORTH, world);
    }

    private int searchNextBlock(int blocksChecked, @NotNull BlockPos position, EnumFacing direction, @NotNull World world) {
        if (blocksChecked >= Field.getMaxRange() || this.isNoPartOfField(world, position)) {
            return blocksChecked;
        }
        return this.searchNextBlock(blocksChecked + 1, position.offset(direction), direction, world);
    }

    public boolean isNoPartOfField(@NotNull World world, @NotNull BlockPos position) {
        return world.isAirBlock(position) || world.getBlockState(position.up()).getMaterial().isSolid();
    }

    public BlockPos getID() {
        return this.location;
    }

    public void writeToNBT(@NotNull NBTTagCompound compound) {
        BlockPosUtil.writeToNBT(compound, TAG_LOCATION, this.location);
        compound.setBoolean(TAG_TAKEN, this.taken);
        compound.setInteger(TAG_STAGE, this.fieldStage.ordinal());
        compound.setInteger(TAG_LENGTH_PLUS, this.lengthPlusX);
        compound.setInteger(TAG_WIDTH_PLUS, this.widthPlusZ);
        compound.setInteger(TAG_LENGTH_MINUS, this.lengthMinusX);
        compound.setInteger(TAG_WIDTH_MINUS, this.widthMinusZ);
        this.inventory.writeToNBT(compound);
        compound.setString(TAG_OWNER, this.owner);
        compound.setBoolean(TAG_INITIALIZED, this.initialized);
    }

    public boolean isTaken() {
        return this.taken;
    }

    public void setTaken(boolean taken) {
        this.taken = taken;
    }

    public FieldStage getFieldStage() {
        return this.fieldStage;
    }

    public void setFieldStage(FieldStage fieldStage) {
        this.fieldStage = fieldStage;
    }

    public boolean needsWork() {
        return this.needsWork;
    }

    public void setNeedsWork(boolean needsWork) {
        this.needsWork = needsWork;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void setInitialized(boolean initialized) {
        this.initialized = initialized;
    }

    @Nullable
    public ItemStack getSeed() {
        if (this.inventory.getStackInSlot(0) != null && this.inventory.getStackInSlot(0).getItem() instanceof IPlantable) {
            return this.inventory.getStackInSlot(0);
        }
        return null;
    }

    public int getLengthPlusX() {
        return this.lengthPlusX;
    }

    public int getWidthPlusZ() {
        return this.widthPlusZ;
    }

    public int getLengthMinusX() {
        return this.lengthMinusX;
    }

    public int getWidthMinusZ() {
        return this.widthMinusZ;
    }

    public BlockPos getLocation() {
        return this.location;
    }

    @NotNull
    public InventoryField getInventoryField() {
        return this.inventory;
    }

    public void setInventoryField(InventoryField inventory) {
        this.inventory = inventory;
    }

    @NotNull
    public String getOwner() {
        return this.owner;
    }

    public void setOwner(@NotNull String owner) {
        if (owner.isEmpty()) {
            this.inventory.setCustomName(LanguageHandler.format("com.minecolonies.coremod.gui.scarecrow.user", LanguageHandler.format("com.minecolonies.coremod.gui.scarecrow.user.noone", new Object[0])));
        } else {
            this.inventory.setCustomName(LanguageHandler.format("com.minecolonies.coremod.gui.scarecrow.user", owner));
        }
        this.owner = owner;
    }

    public void setCustomName(String customName) {
        this.inventory.setCustomName(customName);
    }

    public static enum FieldStage {
        EMPTY,
        HOED,
        PLANTED;

    }
}

