/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.citizen.fisherman;

import com.minecolonies.coremod.util.BlockPosUtil;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Pond {
    private static final String TAG_LOCATION = "Location";
    private static final int WATER_POOL_WIDTH_REQUIREMENT = 6;
    private static final int WATER_POOL_HEIGHT_REQUIREMENT = 3;
    private final BlockPos location;

    private Pond(BlockPos water) {
        this.location = water;
    }

    public static Pond createWater(@NotNull IBlockAccess world, @NotNull BlockPos water) {
        if (Pond.checkWater(world, water)) {
            return new Pond(water);
        }
        return null;
    }

    private static boolean checkWater(@NotNull IBlockAccess world, @NotNull BlockPos water) {
        int z;
        int y;
        if (world.getBlockState(water).getBlock() != Blocks.WATER || !world.isAirBlock(water.up())) {
            return false;
        }
        int x = water.getX();
        return Pond.checkWaterPoolInDirectionXThenZ(world, x, y = water.getY(), z = water.getZ(), 1) || Pond.checkWaterPoolInDirectionXThenZ(world, x, y, z, -1) || Pond.checkWaterPoolInDirectionZThenX(world, x, y, z, 1) || Pond.checkWaterPoolInDirectionZThenX(world, x, y, z, -1);
    }

    private static boolean checkWaterPoolInDirectionXThenZ(@NotNull IBlockAccess world, int x, int y, int z, int vector) {
        for (int dx = x + 6 * vector; dx <= x + 6 * vector; ++dx) {
            if (world.getBlockState(new BlockPos(dx, y, z)).getBlock() == Blocks.WATER) continue;
            return false;
        }
        return Pond.checkWaterPoolInDirectionZ(world, x + 3 * vector, y, z, 1) && Pond.checkWaterPoolInDirectionZ(world, x + 3 * vector, y, z, -1);
    }

    private static boolean checkWaterPoolInDirectionZThenX(@NotNull IBlockAccess world, int x, int y, int z, int vector) {
        for (int dz = z + 6 * vector; dz <= z + 6 * vector; ++dz) {
            if (world.getBlockState(new BlockPos(x, y, dz)).getBlock() == Blocks.WATER) continue;
            return false;
        }
        return Pond.checkWaterPoolInDirectionX(world, x, y, z + 3 * vector, 1) && Pond.checkWaterPoolInDirectionX(world, x, y, z + 3 * vector, -1);
    }

    private static boolean checkWaterPoolInDirectionZ(@NotNull IBlockAccess world, int x, int y, int z, int vector) {
        for (int dz = z + 3 * vector; dz <= z + 3 * vector; ++dz) {
            if (world.getBlockState(new BlockPos(x, y, dz)).getBlock() == Blocks.WATER) continue;
            return false;
        }
        return true;
    }

    private static boolean checkWaterPoolInDirectionX(@NotNull IBlockAccess world, int x, int y, int z, int vector) {
        for (int dx = x + 3 * vector; dx <= x + 3 * vector; ++dx) {
            if (world.getBlockState(new BlockPos(dx, y, z)).getBlock() == Blocks.WATER) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public static Pond readFromNBT(@NotNull NBTTagCompound compound) {
        return new Pond(BlockPosUtil.readFromNBT(compound, TAG_LOCATION));
    }

    public int hashCode() {
        return this.location.hashCode();
    }

    public boolean equals(@Nullable Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        Pond wobj = (Pond)obj;
        return this.location.equals((Object)wobj.getLocation());
    }

    public BlockPos getLocation() {
        return this.location;
    }

    public void writeToNBT(@NotNull NBTTagCompound compound) {
        BlockPosUtil.writeToNBT(compound, TAG_LOCATION, this.location);
    }
}

