/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.citizen.guard;

import com.minecolonies.coremod.colony.jobs.JobGuard;
import com.minecolonies.coremod.entity.ai.citizen.guard.AbstractEntityAIGuard;
import com.minecolonies.coremod.entity.ai.util.AIState;
import com.minecolonies.coremod.entity.ai.util.AITarget;
import com.minecolonies.coremod.util.InventoryFunctions;
import com.minecolonies.coremod.util.Utils;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import org.jetbrains.annotations.NotNull;

public class EntityAIMeleeGuard
extends AbstractEntityAIGuard {
    private static final int BASE_RELOAD_TIME = 30;
    private static final double PITCH_DIVIDER = 1.0;
    private static final double BASE_PITCH = 0.8;
    private static final double PITCH_MULTIPLIER = 0.4;
    private static final double MOVE_MINIMAL = 0.01;
    private static final double TURN_AROUND = 180.0;
    private static final double BASIC_VOLUME = 1.0;
    private static final double XP_EACH_HIT = 0.2;
    private static final int BASE_FOLLOW_SPEED = 1;
    private static final double BASE_FOLLOW_SPEED_MULTIPLIER = 0.25;
    private static final double MIN_ATTACK_DISTANCE = 2.0;
    private static final double DAMAGE_PER_ATTACK = 0.5;
    private static final int FIRE_CHANCE_MULTIPLIER = 4;

    public EntityAIMeleeGuard(@NotNull JobGuard job) {
        super(job);
        super.registerTargets(new AITarget(AIState.GUARD_SEARCH_TARGET, this::searchTarget), new AITarget(AIState.GUARD_GET_TARGET, this::getTarget), new AITarget(AIState.GUARD_HUNT_DOWN_TARGET, this::huntDown), new AITarget(AIState.GUARD_PATROL, this::patrol), new AITarget(AIState.GUARD_RESTOCK, this::goToBuilding));
        if (this.worker.getCitizenData() != null) {
            this.worker.setSkillModifier(2 * this.worker.getCitizenData().getStrength() + this.worker.getCitizenData().getEndurance());
            this.worker.setCanPickUpLoot(true);
        }
    }

    @Override
    protected AIState searchTarget() {
        if (this.checkForWeapon()) {
            return AIState.GUARD_SEARCH_TARGET;
        }
        InventoryFunctions.matchFirstInProvider((ICapabilityProvider)this.worker, stack -> stack != null && Utils.doesItemServeAsWeapon(stack), this.worker::setHeldItem);
        return super.searchTarget();
    }

    protected AIState huntDown() {
        if (!this.targetEntity.isEntityAlive() || this.checkForWeapon()) {
            this.targetEntity = null;
            this.worker.setAIMoveSpeed(1.0f);
            return AIState.GUARD_GATHERING;
        }
        if (this.worker.getEntitySenses().canSee((Entity)this.targetEntity) && (double)this.worker.getDistanceToEntity((Entity)this.targetEntity) <= 2.0) {
            this.worker.resetActiveHand();
            this.attackEntity(this.targetEntity, 0.5f);
            this.setDelay(this.getReloadTime());
            ++this.attacksExecuted;
            this.currentSearchDistance = 5;
            if (this.attacksExecuted >= this.getMaxAttacksUntilRestock()) {
                return AIState.GUARD_RESTOCK;
            }
            return AIState.GUARD_HUNT_DOWN_TARGET;
        }
        if (this.shouldReturnToTarget(this.targetEntity.getPosition(), 10.0)) {
            return AIState.GUARD_PATROL;
        }
        this.worker.setAIMoveSpeed((float)(1.0 + 0.25 * (double)this.worker.getExperienceLevel()));
        this.worker.isWorkerAtSiteWithMove(this.targetEntity.getPosition(), 2);
        return AIState.GUARD_SEARCH_TARGET;
    }

    private void attackEntity(@NotNull EntityLivingBase entityToAttack, float baseDamage) {
        ItemStack heldItem;
        double damgeToBeDealt = baseDamage;
        if (this.worker.getHealth() <= 2.0f) {
            damgeToBeDealt *= 2.0;
        }
        if ((heldItem = this.worker.getHeldItem(EnumHand.MAIN_HAND)) != null) {
            if (heldItem.getItem() instanceof ItemSword) {
                damgeToBeDealt += (double)((ItemSword)heldItem.getItem()).getDamageVsEntity();
            }
            damgeToBeDealt += (double)EnchantmentHelper.getModifierForCreature((ItemStack)heldItem, (EnumCreatureAttribute)this.targetEntity.getCreatureAttribute());
        }
        this.targetEntity.attackEntityFrom(new DamageSource(this.worker.getName()), (float)damgeToBeDealt);
        this.targetEntity.setRevengeTarget((EntityLivingBase)this.worker);
        int fireAspectModifier = EnchantmentHelper.getFireAspectModifier((EntityLivingBase)this.worker);
        if (fireAspectModifier > 0) {
            this.targetEntity.setFire(fireAspectModifier * 4);
        }
        this.worker.addExperience(0.2);
        if (this.targetEntity.getHealth() <= 0.0f) {
            this.onKilledEntity(this.targetEntity);
        }
        this.worker.faceEntity((Entity)entityToAttack, 180.0f, 180.0f);
        this.worker.getLookHelper().setLookPositionWithEntity((Entity)entityToAttack, 180.0f, 180.0f);
        double xDiff = this.targetEntity.posX - this.worker.posX;
        double zDiff = this.targetEntity.posZ - this.worker.posZ;
        double goToX = xDiff > 0.0 ? 0.01 : -0.01;
        double goToZ = zDiff > 0.0 ? 0.01 : -0.01;
        this.worker.moveEntity(goToX, 0.0, goToZ);
        this.worker.swingArm(EnumHand.MAIN_HAND);
        this.worker.playSound(SoundEvents.ENTITY_PLAYER_ATTACK_SWEEP, 1.0f, (float)this.getRandomPitch());
        this.worker.damageItemInHand(1);
    }

    private int getReloadTime() {
        return 30 / (this.worker.getExperienceLevel() + 1);
    }

    private double getRandomPitch() {
        return 1.0 / (this.worker.getRNG().nextDouble() * 0.4 + 0.8);
    }
}

