/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.citizen.guard;

import com.minecolonies.coremod.colony.jobs.JobGuard;
import com.minecolonies.coremod.entity.ai.citizen.guard.AbstractEntityAIGuard;
import com.minecolonies.coremod.entity.ai.citizen.guard.GuardArrow;
import com.minecolonies.coremod.entity.ai.util.AIState;
import com.minecolonies.coremod.entity.ai.util.AITarget;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.projectile.EntityTippedArrow;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import org.jetbrains.annotations.NotNull;

public class EntityAIRangeGuard
extends AbstractEntityAIGuard
implements IRangedAttackMob {
    private static final int BASE_RELOAD_TIME = 60;
    private static final double BASE_POWER_ENCHANTMENT_DAMAGE = 0.5;
    private static final double POWER_ENCHANTMENT_DAMAGE_MULTIPLIER = 0.5;
    private static final double BASE_DAMAGE_MULTIPLIER = 2.0;
    private static final double RANDOM_DAMAGE_MULTPLIER = 0.25;
    private static final double DIFFICULTY_DAMAGE_INCREASE = 0.11;
    private static final int FIRE_EFFECT_CHANCE = 100;
    private static final double PITCH_DIVIDER = 1.0;
    private static final double BASE_PITCH = 0.8;
    private static final double PITCH_MULTIPLIER = 0.4;
    private static final double MOVE_MINIMAL = 0.01;
    private static final double TURN_AROUND = 180.0;
    private static final double AIM_SLIGHTLY_HIGHER_MULTIPLIER = (double)0.2f;
    private static final double BASIC_VOLUME = 1.0;
    private static final double AIM_HEIGHT = 3.0;
    private static final double XP_EACH_ARROW = 0.2;
    private static final double HIT_CHANCE_DIVIDER = 15.0;
    private static final double ARROW_SPEED = 1.6;
    private static final int BASE_FOLLOW_SPEED = 1;
    private static final double BASE_FOLLOW_SPEED_MULTIPLIER = 0.25;
    private static final double MAX_ATTACK_DISTANCE = 20.0;
    private static final int DAMAGE_PER_ATTACK = 2;
    private static final int MOVE_CLOSE = 3;

    public EntityAIRangeGuard(@NotNull JobGuard job) {
        super(job);
        super.registerTargets(new AITarget(AIState.GUARD_SEARCH_TARGET, this::searchTarget), new AITarget(AIState.GUARD_GET_TARGET, this::getTarget), new AITarget(AIState.GUARD_HUNT_DOWN_TARGET, this::huntDown), new AITarget(AIState.GUARD_PATROL, this::patrol), new AITarget(AIState.GUARD_RESTOCK, this::goToBuilding));
        if (this.worker.getCitizenData() != null) {
            this.worker.setSkillModifier(2 * this.worker.getCitizenData().getIntelligence() + this.worker.getCitizenData().getStrength());
            this.worker.setCanPickUpLoot(true);
        }
    }

    @Override
    protected AIState searchTarget() {
        if (this.checkOrRequestItems(false, new ItemStack((Item)Items.BOW))) {
            return AIState.GUARD_SEARCH_TARGET;
        }
        this.worker.setHeldItem(this.worker.findFirstSlotInInventoryWith((Item)Items.BOW, -1));
        return super.searchTarget();
    }

    protected AIState huntDown() {
        if (!this.targetEntity.isEntityAlive() || this.checkOrRequestItems(false, new ItemStack((Item)Items.BOW))) {
            this.targetEntity = null;
            this.worker.setAIMoveSpeed(1.0f);
            return AIState.GUARD_GATHERING;
        }
        if (this.worker.getEntitySenses().canSee((Entity)this.targetEntity) && (double)this.worker.getDistanceToEntity((Entity)this.targetEntity) <= 20.0) {
            this.worker.resetActiveHand();
            this.attackEntityWithRangedAttack(this.targetEntity, 2.0f);
            this.setDelay(this.getReloadTime());
            ++this.attacksExecuted;
            if (this.attacksExecuted >= this.getMaxAttacksUntilRestock()) {
                return AIState.GUARD_RESTOCK;
            }
            return AIState.GUARD_HUNT_DOWN_TARGET;
        }
        if (this.shouldReturnToTarget(this.targetEntity.getPosition(), 30.0)) {
            return AIState.GUARD_PATROL;
        }
        this.worker.setAIMoveSpeed((float)(1.0 + 0.25 * (double)this.worker.getExperienceLevel()));
        this.worker.isWorkerAtSiteWithMove(this.targetEntity.getPosition(), 3);
        return AIState.GUARD_SEARCH_TARGET;
    }

    public void attackEntityWithRangedAttack(@NotNull EntityLivingBase entityToAttack, float baseDamage) {
        GuardArrow arrowEntity = new GuardArrow(this.worker.worldObj, this.worker);
        double xVector = entityToAttack.posX - this.worker.posX;
        double yVector = entityToAttack.getEntityBoundingBox().minY + (double)entityToAttack.height / 3.0 - arrowEntity.posY;
        double zVector = entityToAttack.posZ - this.worker.posZ;
        double distance = MathHelper.sqrt_double((double)(xVector * xVector + zVector * zVector));
        double damage = baseDamage;
        double chance = 15.0 / (double)(this.worker.getExperienceLevel() + 1);
        arrowEntity.setThrowableHeading(xVector, yVector + distance * (double)0.2f, zVector, 1.6f, (float)chance);
        if (this.worker.getHealth() <= 2.0f) {
            damage *= 2.0;
        }
        this.addEffectsToArrow(arrowEntity, damage);
        this.worker.addExperience(0.2);
        this.worker.faceEntity((Entity)entityToAttack, 180.0f, 180.0f);
        this.worker.getLookHelper().setLookPositionWithEntity((Entity)entityToAttack, 180.0f, 180.0f);
        double xDiff = this.targetEntity.posX - this.worker.posX;
        double zDiff = this.targetEntity.posZ - this.worker.posZ;
        double goToX = xDiff > 0.0 ? 0.01 : -0.01;
        double goToZ = zDiff > 0.0 ? 0.01 : -0.01;
        this.worker.moveEntity(goToX, 0.0, goToZ);
        this.worker.swingArm(EnumHand.MAIN_HAND);
        this.worker.playSound(SoundEvents.ENTITY_SKELETON_SHOOT, 1.0f, (float)this.getRandomPitch());
        this.worker.worldObj.spawnEntityInWorld((Entity)arrowEntity);
        this.worker.damageItemInHand(1);
    }

    private int getReloadTime() {
        return 60 / (this.worker.getExperienceLevel() + 1);
    }

    private void addEffectsToArrow(EntityTippedArrow arrowEntity, double baseDamage) {
        ItemStack holdItem;
        int powerEntchantment = EnchantmentHelper.getMaxEnchantmentLevel((Enchantment)Enchantments.POWER, (EntityLivingBase)this.worker);
        int punchEntchantment = EnchantmentHelper.getMaxEnchantmentLevel((Enchantment)Enchantments.PUNCH, (EntityLivingBase)this.worker);
        DifficultyInstance difficulty = this.worker.worldObj.getDifficultyForLocation(new BlockPos((Entity)this.worker));
        arrowEntity.setDamage(baseDamage * 2.0 + this.worker.getRandom().nextGaussian() * 0.25 + (double)this.worker.worldObj.getDifficulty().getDifficultyId() * 0.11);
        if (powerEntchantment > 0) {
            arrowEntity.setDamage(arrowEntity.getDamage() + (double)powerEntchantment * 0.5 + 0.5);
        }
        if (punchEntchantment > 0) {
            arrowEntity.setKnockbackStrength(punchEntchantment);
        }
        boolean onFire = this.worker.isBurning() && difficulty.func_190083_c() && this.worker.getRandom().nextBoolean();
        boolean bl = onFire = onFire || EnchantmentHelper.getMaxEnchantmentLevel((Enchantment)Enchantments.FLAME, (EntityLivingBase)this.worker) > 0;
        if (onFire) {
            arrowEntity.setFire(100);
        }
        if ((holdItem = this.worker.getHeldItem(EnumHand.OFF_HAND)) != null && holdItem.getItem() == Items.TIPPED_ARROW) {
            arrowEntity.setPotionEffect(holdItem);
        }
    }

    private double getRandomPitch() {
        return 1.0 / (this.worker.getRNG().nextDouble() * 0.4 + 0.8);
    }
}

