/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.citizen.miner;

import com.minecolonies.coremod.colony.buildings.BuildingMiner;
import com.minecolonies.coremod.entity.ai.citizen.miner.Node;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Random;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Level {
    private static final String TAG_DEPTH = "Depth";
    private static final String TAG_NODES = "Nodes";
    private static final String TAG_LADDERX = "LadderX";
    private static final String TAG_LADDERZ = "LadderZ";
    private static final String TAG_OPEN_NODES = "OpenNodes";
    private static final int ROTATE_ONCE = 1;
    private static final int ROTATE_TWICE = 2;
    private static final int ROTATE_THREE_TIMES = 3;
    private static final int MAX_ROTATIONS = 4;
    private int depth;
    private static final Random rand = new Random();
    private static final int RANDOM_TYPES = 4;
    @NotNull
    private final HashMap<Point2D, Node> nodes = new HashMap();
    @NotNull
    private static final Comparator<Node> NODE_COMPARATOR = (n1, n2) -> rand.nextInt(100) > 50 ? 1 : -1;
    @NotNull
    private final Queue<Node> openNodes = new PriorityQueue<Node>(11, NODE_COMPARATOR);
    @Nullable
    private Node ladderNode = null;

    private Level() {
    }

    public Level(@NotNull BuildingMiner buildingMiner, int depth) {
        this.depth = depth;
        int cobbleX = buildingMiner.getCobbleLocation().getX();
        int cobbleZ = buildingMiner.getCobbleLocation().getZ();
        Point2D.Double cobbleCenter = new Point2D.Double(cobbleX - buildingMiner.getVectorX() * 3, cobbleZ - buildingMiner.getVectorZ() * 3);
        Point2D.Double ladderCenter = new Point2D.Double(cobbleX + buildingMiner.getVectorX() * 4, cobbleZ + buildingMiner.getVectorZ() * 4);
        Node cobbleNode = new Node(((Point2D)cobbleCenter).getX(), ((Point2D)cobbleCenter).getY(), ladderCenter);
        cobbleNode.setStyle(Node.NodeType.LADDER_BACK);
        cobbleNode.setStatus(Node.NodeStatus.COMPLETED);
        this.nodes.put(cobbleCenter, cobbleNode);
        this.ladderNode = new Node(((Point2D)ladderCenter).getX(), ((Point2D)ladderCenter).getY(), null);
        this.ladderNode.setStyle(Node.NodeType.SHAFT);
        this.ladderNode.setStatus(Node.NodeStatus.COMPLETED);
        this.nodes.put(ladderCenter, this.ladderNode);
        ArrayList<Point2D.Double> nodeCenterList = new ArrayList<Point2D.Double>();
        nodeCenterList.add(this.ladderNode.getNorthNodeCenter());
        nodeCenterList.add(this.ladderNode.getSouthNodeCenter());
        nodeCenterList.add(this.ladderNode.getEastNodeCenter());
        nodeCenterList.add(this.ladderNode.getWesthNodeCenter());
        for (Point2D.Double pos : nodeCenterList) {
            if (cobbleCenter.equals(pos) || ladderCenter.equals(pos)) continue;
            Node tempNode = new Node(pos.getX(), pos.getY(), ladderCenter);
            tempNode.setStyle(Node.NodeType.TUNNEL);
            this.nodes.put(pos, tempNode);
            this.openNodes.add(tempNode);
        }
    }

    public Node getRandomNode() {
        return this.openNodes.peek();
    }

    public void closeNextNode(int rotation) {
        Node tempNode = this.openNodes.poll();
        ArrayList<Point2D.Double> nodeCenterList = new ArrayList<Point2D.Double>();
        switch (tempNode.getStyle()) {
            case TUNNEL: {
                nodeCenterList.add(Level.getNextNodePositionFromNodeWithRotation(tempNode, rotation, 0));
                break;
            }
            case BEND: {
                nodeCenterList.add(Level.getNextNodePositionFromNodeWithRotation(tempNode, rotation, 3));
                break;
            }
            case CROSSROAD: {
                nodeCenterList.add(Level.getNextNodePositionFromNodeWithRotation(tempNode, rotation, 0));
                nodeCenterList.add(Level.getNextNodePositionFromNodeWithRotation(tempNode, rotation, 1));
                nodeCenterList.add(Level.getNextNodePositionFromNodeWithRotation(tempNode, rotation, 3));
                break;
            }
            default: {
                return;
            }
        }
        for (Point2D.Double pos : nodeCenterList) {
            if (this.nodes.containsKey(pos)) continue;
            Node tempNodeToAdd = new Node(pos.getX(), pos.getY(), new Point2D.Double(tempNode.getX(), tempNode.getZ()));
            int randNumber = rand.nextInt(4);
            tempNodeToAdd.setStyle(randNumber <= 1 ? Node.NodeType.TUNNEL : (randNumber == 2 ? Node.NodeType.BEND : Node.NodeType.CROSSROAD));
            this.nodes.put(pos, tempNodeToAdd);
            this.openNodes.add(tempNodeToAdd);
        }
        this.nodes.get(new Point2D.Double(tempNode.getX(), tempNode.getZ())).setStatus(Node.NodeStatus.COMPLETED);
    }

    private static Point2D.Double getNextNodePositionFromNodeWithRotation(Node node, int rotation, int additionalRotation) {
        int realRotation = Math.floorMod(rotation + additionalRotation, 4);
        switch (realRotation) {
            case 1: {
                return node.getSouthNodeCenter();
            }
            case 2: {
                return node.getWesthNodeCenter();
            }
            case 3: {
                return node.getNorthNodeCenter();
            }
        }
        return node.getEastNodeCenter();
    }

    @NotNull
    public static Level createFromNBT(@NotNull NBTTagCompound compound) {
        Level level = new Level();
        level.depth = compound.getInteger(TAG_DEPTH);
        NBTTagList nodeTagList = compound.getTagList(TAG_NODES, 10);
        for (int i = 0; i < nodeTagList.tagCount(); ++i) {
            Node node = Node.createFromNBT(nodeTagList.getCompoundTagAt(i));
            level.nodes.put(new Point2D.Double(node.getX(), node.getZ()), node);
        }
        double ladderX = compound.getDouble(TAG_LADDERX);
        double ladderZ = compound.getDouble(TAG_LADDERZ);
        level.ladderNode = level.nodes.get(new Point2D.Double(ladderX, ladderZ));
        NBTTagList openNodeTagList = compound.getTagList(TAG_OPEN_NODES, 10);
        for (int i = 0; i < openNodeTagList.tagCount(); ++i) {
            Node node = Node.createFromNBT(openNodeTagList.getCompoundTagAt(i));
            level.openNodes.add(node);
        }
        return level;
    }

    @NotNull
    public String toString() {
        return "Level{depth=" + this.depth + ", nodes=" + this.nodes + ", ladderNode=" + this.ladderNode + '}';
    }

    public void writeToNBT(@NotNull NBTTagCompound compound) {
        compound.setInteger(TAG_DEPTH, this.depth);
        NBTTagList nodeTagList = new NBTTagList();
        for (Node node : this.nodes.values()) {
            NBTTagCompound nodeCompound = new NBTTagCompound();
            node.writeToNBT(nodeCompound);
            nodeTagList.appendTag((NBTBase)nodeCompound);
        }
        compound.setTag(TAG_NODES, (NBTBase)nodeTagList);
        compound.setDouble(TAG_LADDERX, this.ladderNode.getX());
        compound.setDouble(TAG_LADDERZ, this.ladderNode.getZ());
        NBTTagList openNodeTagList = new NBTTagList();
        for (Node node : this.openNodes) {
            NBTTagCompound nodeCompound = new NBTTagCompound();
            node.writeToNBT(nodeCompound);
            openNodeTagList.appendTag((NBTBase)nodeCompound);
        }
        compound.setTag(TAG_OPEN_NODES, (NBTBase)openNodeTagList);
    }

    @NotNull
    public Map<Point2D, Node> getNodes() {
        return Collections.unmodifiableMap(this.nodes);
    }

    public int getNumberOfNodes() {
        return this.nodes.size();
    }

    public int getDepth() {
        return this.depth;
    }

    @Nullable
    public Node getLadderNode() {
        return this.ladderNode;
    }

    public void addNode(Node newNode) {
        this.nodes.put(new Point2D.Double(newNode.getX(), newNode.getZ()), newNode);
    }

    public Node getNode(Point2D key) {
        return this.nodes.get(key);
    }
}

