/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.citizen.miner;

import java.awt.geom.Point2D;
import net.minecraft.nbt.NBTTagCompound;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Node {
    private static final String TAG_X = "idX";
    private static final String TAG_Z = "idZ";
    private static final String TAG_STYLE = "Style";
    private static final String TAG_STATUS = "Status";
    private static final String TAG_PARENTX = "ParentX";
    private static final String TAG_PARENTZ = "ParentZ";
    private static final int DISTANCE_TO_NEXT_NODE = 7;
    private final double x;
    private final double z;
    @NotNull
    private NodeType style;
    @NotNull
    private NodeStatus status;
    @Nullable
    private final Point2D parent;

    public Node(double x, double z, @Nullable Point2D parent) {
        this.x = x;
        this.z = z;
        this.style = NodeType.CROSSROAD;
        this.status = NodeStatus.AVAILABLE;
        this.parent = parent;
    }

    @NotNull
    public static Node createFromNBT(@NotNull NBTTagCompound compound) {
        double x = compound.getDouble(TAG_X);
        double z = compound.getDouble(TAG_Z);
        NodeType style = NodeType.valueOf(compound.getString(TAG_STYLE));
        NodeStatus status = NodeStatus.valueOf(compound.getString(TAG_STATUS));
        Point2D.Double tempParent = compound.hasKey(TAG_PARENTX) ? new Point2D.Double(compound.getDouble(TAG_PARENTX), compound.getDouble(TAG_PARENTZ)) : null;
        Node node = new Node(x, z, tempParent);
        node.setStyle(style);
        node.setStatus(status);
        return node;
    }

    public void writeToNBT(@NotNull NBTTagCompound compound) {
        compound.setDouble(TAG_X, this.x);
        compound.setDouble(TAG_Z, this.z);
        compound.setString(TAG_STYLE, this.style.name());
        compound.setString(TAG_STATUS, this.status.name());
        if (this.parent != null) {
            compound.setDouble(TAG_PARENTX, this.parent.getX());
            compound.setDouble(TAG_PARENTZ, this.parent.getY());
        }
    }

    public double getX() {
        return this.x;
    }

    public double getZ() {
        return this.z;
    }

    @NotNull
    public NodeStatus getStatus() {
        return this.status;
    }

    public void setStatus(@NotNull NodeStatus status) {
        this.status = status;
    }

    @Nullable
    public Point2D getParent() {
        return this.parent;
    }

    @NotNull
    public String toString() {
        return "Node{x=" + this.x + ", z=" + this.z + ", style=" + (Object)((Object)this.style) + ", status=" + (Object)((Object)this.status) + '}';
    }

    @NotNull
    public NodeType getStyle() {
        return this.style;
    }

    public void setStyle(@NotNull NodeType style) {
        this.style = style;
    }

    public Point2D.Double getNorthNodeCenter() {
        return new Point2D.Double(this.getX(), this.getZ() - 7.0);
    }

    public Point2D.Double getSouthNodeCenter() {
        return new Point2D.Double(this.getX(), this.getZ() + 7.0);
    }

    public Point2D.Double getEastNodeCenter() {
        return new Point2D.Double(this.getX() + 7.0, this.getZ());
    }

    public Point2D.Double getWesthNodeCenter() {
        return new Point2D.Double(this.getX() - 7.0, this.getZ());
    }

    public static enum NodeType {
        SHAFT,
        LADDER_BACK,
        TUNNEL,
        CROSSROAD,
        BEND;

    }

    static enum NodeStatus {
        AVAILABLE,
        IN_PROGRESS,
        COMPLETED;

    }
}

