/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.minimal;

import com.minecolonies.coremod.colony.jobs.JobGuard;
import com.minecolonies.coremod.entity.EntityCitizen;
import java.util.Optional;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.player.EntityPlayer;
import org.jetbrains.annotations.Nullable;

public class EntityAICitizenAvoidEntity
extends EntityAIBase {
    private static final double TOO_CLOSE_TO_MOB = 49.0;
    private final EntityCitizen theEntity;
    private final double farSpeed;
    private final double nearSpeed;
    @Nullable
    private Entity closestLivingEntity;
    private final float distanceFromEntity;
    private final Class<? extends Entity> targetEntityClass;

    public EntityAICitizenAvoidEntity(EntityCitizen entity, Class<? extends Entity> targetEntityClass, float distanceFromEntity, double farSpeed, double nearSpeed) {
        this.theEntity = entity;
        this.targetEntityClass = targetEntityClass;
        this.distanceFromEntity = distanceFromEntity;
        this.farSpeed = farSpeed;
        this.nearSpeed = nearSpeed;
        super.setMutexBits(1);
    }

    public boolean shouldExecute() {
        this.closestLivingEntity = this.getClosestToAvoid();
        return this.closestLivingEntity != null && !(this.theEntity.getColonyJob() instanceof JobGuard) && this.theEntity.canEntityBeSeen(this.closestLivingEntity);
    }

    private Entity getClosestToAvoid() {
        if (this.targetEntityClass == EntityPlayer.class) {
            return this.theEntity.worldObj.getClosestPlayerToEntity((Entity)this.theEntity, (double)this.distanceFromEntity);
        }
        Optional<Entity> entityOptional = this.theEntity.worldObj.getEntitiesInAABBexcluding((Entity)this.theEntity, this.theEntity.getEntityBoundingBox().expand((double)this.distanceFromEntity, 3.0, (double)this.distanceFromEntity), target -> target.isEntityAlive() && this.theEntity.getEntitySenses().canSee(target)).stream().filter(this.targetEntityClass::isInstance).findFirst();
        return entityOptional.isPresent() ? entityOptional.get() : null;
    }

    public boolean continueExecuting() {
        return !this.theEntity.getNavigator().noPath();
    }

    public void startExecuting() {
        this.performMoveAway();
    }

    private void performMoveAway() {
        this.theEntity.getNavigator().moveAwayFromEntityLiving(this.closestLivingEntity, (double)this.distanceFromEntity * 2.0, this.nearSpeed);
    }

    public void resetTask() {
        this.closestLivingEntity = null;
    }

    public void updateTask() {
        Entity newClosest = this.getClosestToAvoid();
        if (newClosest != null && newClosest != this.closestLivingEntity) {
            this.closestLivingEntity = newClosest;
            this.performMoveAway();
            return;
        }
        if (this.theEntity.getDistanceSqToEntity(this.closestLivingEntity) < 49.0) {
            this.theEntity.getNavigator().setSpeed(this.nearSpeed);
        } else {
            this.theEntity.getNavigator().setSpeed(this.farSpeed);
        }
    }
}

