/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.pathfinding;

import com.minecolonies.coremod.configuration.Configurations;
import com.minecolonies.coremod.entity.pathfinding.AbstractPathJob;
import com.minecolonies.coremod.entity.pathfinding.Node;
import com.minecolonies.coremod.util.Log;
import net.minecraft.pathfinding.Path;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PathJobMoveAwayFromLocation
extends AbstractPathJob {
    private static final double TIE_BREAKER = 1.001;
    @NotNull
    protected final BlockPos avoid;
    @NotNull
    protected final BlockPos heuristicPoint;
    protected final int avoidDistance;

    public PathJobMoveAwayFromLocation(World world, @NotNull BlockPos start, @NotNull BlockPos avoid, int avoidDistance, int range) {
        super(world, start, avoid, range);
        this.avoid = new BlockPos((Vec3i)avoid);
        this.avoidDistance = avoidDistance;
        double dx = start.getX() - avoid.getX();
        double dz = start.getZ() - avoid.getZ();
        double scalar = (double)avoidDistance / Math.sqrt(dx * dx + dz * dz);
        this.heuristicPoint = new BlockPos(start.getX() + (int)(dx *= scalar), start.getY(), start.getZ() + (int)(dz *= scalar));
    }

    @Override
    @Nullable
    protected Path search() {
        if (Configurations.pathfindingDebugVerbosity > 0) {
            Log.getLogger().info(String.format("Pathfinding from [%d,%d,%d] away from [%d,%d,%d]", this.start.getX(), this.start.getY(), this.start.getZ(), this.avoid.getX(), this.avoid.getY(), this.avoid.getZ()));
        }
        return super.search();
    }

    @Override
    protected double computeHeuristic(@NotNull BlockPos pos) {
        int dx = pos.getX() - this.heuristicPoint.getX();
        int dy = pos.getY() - this.heuristicPoint.getY();
        int dz = pos.getZ() - this.heuristicPoint.getZ();
        return (double)(Math.abs(dx) + Math.abs(dy) + Math.abs(dz)) * 1.001;
    }

    @Override
    protected boolean isAtDestination(@NotNull Node n) {
        return this.getNodeResultScore(n) >= (double)(this.avoidDistance * this.avoidDistance);
    }

    @Override
    protected double getNodeResultScore(@NotNull Node n) {
        return this.avoid.distanceSq((double)n.pos.getX(), (double)n.pos.getY(), (double)n.pos.getZ());
    }
}

