/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.pathfinding;

import com.minecolonies.coremod.configuration.Configurations;
import com.minecolonies.coremod.entity.pathfinding.AbstractPathJob;
import com.minecolonies.coremod.entity.pathfinding.Node;
import com.minecolonies.coremod.util.Log;
import net.minecraft.pathfinding.Path;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PathJobMoveToLocation
extends AbstractPathJob {
    private static final float DESTINATION_SLACK_NONE = 0.1f;
    private static final float DESTINATION_SLACK_ADJACENT = 3.1f;
    private static final double TIE_BREAKER = 1.001;
    @NotNull
    private final BlockPos destination;
    private float destinationSlack = 0.1f;

    public PathJobMoveToLocation(World world, @NotNull BlockPos start, @NotNull BlockPos end, int range) {
        super(world, start, end, range);
        this.destination = new BlockPos((Vec3i)end);
    }

    @Override
    @Nullable
    protected Path search() {
        if (Configurations.pathfindingDebugVerbosity > 0) {
            Log.getLogger().info(String.format("Pathfinding from [%d,%d,%d] to [%d,%d,%d]", this.start.getX(), this.start.getY(), this.start.getZ(), this.destination.getX(), this.destination.getY(), this.destination.getZ()));
        }
        if (this.getGroundHeight(null, this.destination) != this.destination.getY()) {
            this.destinationSlack = 3.1f;
        }
        return super.search();
    }

    @Override
    protected double computeHeuristic(@NotNull BlockPos pos) {
        int dx = pos.getX() - this.destination.getX();
        int dy = pos.getY() - this.destination.getY();
        int dz = pos.getZ() - this.destination.getZ();
        return (double)(Math.abs(dx) + Math.abs(dy) + Math.abs(dz)) * 1.001;
    }

    @Override
    protected boolean isAtDestination(@NotNull Node n) {
        if (this.destinationSlack <= 0.1f) {
            return n.pos.getX() == this.destination.getX() && n.pos.getY() == this.destination.getY() && n.pos.getZ() == this.destination.getZ();
        }
        return this.destination.distanceSq((double)n.pos.getX(), (double)n.pos.getY(), (double)n.pos.getZ()) <= (double)this.destinationSlack;
    }

    @Override
    protected double getNodeResultScore(@NotNull Node n) {
        return -this.destination.distanceSq((double)n.pos.getX(), (double)n.pos.getY(), (double)n.pos.getZ());
    }
}

