/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.event;

import com.minecolonies.coremod.blocks.AbstractBlockHut;
import com.minecolonies.coremod.blocks.BlockHutTownHall;
import com.minecolonies.coremod.colony.ColonyManager;
import com.minecolonies.coremod.colony.IColony;
import com.minecolonies.coremod.colony.buildings.AbstractBuilding;
import com.minecolonies.coremod.colony.permissions.Permissions;
import com.minecolonies.coremod.util.LanguageHandler;
import com.minecolonies.coremod.util.Log;
import com.minecolonies.coremod.util.MathUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSilverfish;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;

public class EventHandler {
    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onDebugOverlay(RenderGameOverlayEvent.Text event) {
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            Minecraft mc = Minecraft.getMinecraft();
            if (mc.gameSettings.showDebugInfo) {
                WorldClient world = mc.theWorld;
                EntityPlayerSP player = mc.thePlayer;
                IColony colony = ColonyManager.getIColony((World)world, player.getPosition());
                double minDistance = ColonyManager.getMinimumDistanceBetweenTownHalls();
                if (colony == null) {
                    colony = ColonyManager.getClosestIColony((World)world, player.getPosition());
                    if (colony == null || Math.sqrt(colony.getDistanceSquared(player.getPosition())) > 2.0 * minDistance) {
                        event.getLeft().add(LanguageHandler.format("com.minecolonies.coremod.gui.debugScreen.noCloseColony", new Object[0]));
                        return;
                    }
                    event.getLeft().add(LanguageHandler.format("com.minecolonies.coremod.gui.debugScreen.nextColony", (int)Math.sqrt(colony.getDistanceSquared(player.getPosition())), minDistance));
                    return;
                }
                event.getLeft().add(colony.getName() + " : " + LanguageHandler.format("com.minecolonies.coremod.gui.debugScreen.blocksFromCenter", (int)Math.sqrt(colony.getDistanceSquared(player.getPosition()))));
            }
        }
    }

    @SubscribeEvent
    public void onBlockBreak(@NotNull BlockEvent.BreakEvent event) {
        World world = event.getWorld();
        if (!world.isRemote && event.getState().getBlock() instanceof AbstractBlockHut) {
            AbstractBuilding building = ColonyManager.getBuilding(world, event.getPos());
            if (building == null) {
                return;
            }
            if (!building.getColony().getPermissions().hasPermission(event.getPlayer(), Permissions.Action.BREAK_HUTS)) {
                event.setCanceled(true);
                return;
            }
            building.destroy();
        }
    }

    @SubscribeEvent
    public void onPlayerInteract(@NotNull PlayerInteractEvent.RightClickBlock event) {
        EntityPlayer player = event.getEntityPlayer();
        World world = event.getWorld();
        if (event.getHand() == EnumHand.MAIN_HAND && !event.getWorld().isRemote) {
            if (EventHandler.playerRightClickInteract(player, world, event.getPos()) && world.getBlockState(event.getPos()).getBlock() instanceof AbstractBlockHut) {
                IColony colony = ColonyManager.getIColony(world, event.getPos());
                if (colony != null && !colony.getPermissions().hasPermission(player, Permissions.Action.ACCESS_HUTS)) {
                    event.setCanceled(true);
                }
                return;
            }
            if (event.getEntityPlayer() != null && "pmardle".equalsIgnoreCase(event.getEntityPlayer().getName()) && event.getItemStack() != null && Block.getBlockFromItem((Item)event.getItemStack().getItem()) instanceof BlockSilverfish) {
                LanguageHandler.sendPlayerMessage(event.getEntityPlayer(), "Stop that you twat!!!", new Object[0]);
                event.setCanceled(true);
            }
            if (player.getHeldItemMainhand() == null || player.getHeldItemMainhand().getItem() == null) {
                return;
            }
            EventHandler.handleEventCancellation((PlayerInteractEvent)event, player);
        }
    }

    private static boolean playerRightClickInteract(@NotNull EntityPlayer player, World world, BlockPos pos) {
        return !player.isSneaking() || player.getHeldItemMainhand() == null || player.getHeldItemMainhand().getItem() == null || player.getHeldItemMainhand().getItem().doesSneakBypassUse(player.getHeldItemMainhand(), (IBlockAccess)world, pos, player);
    }

    private static void handleEventCancellation(@NotNull PlayerInteractEvent event, @NotNull EntityPlayer player) {
        Block heldBlock = Block.getBlockFromItem((Item)player.getHeldItemMainhand().getItem());
        if (heldBlock instanceof AbstractBlockHut) {
            event.setCanceled(!EventHandler.onBlockHutPlaced(event.getWorld(), player, heldBlock, event.getPos().offset(event.getFace())));
        }
    }

    public static boolean onBlockHutPlaced(@NotNull World world, @NotNull EntityPlayer player, Block block, BlockPos pos) {
        if (block instanceof BlockHutTownHall) {
            return EventHandler.onTownHallPlaced(world, player, pos);
        }
        return EventHandler.onBlockHutPlaced(world, player, pos);
    }

    static boolean onTownHallPlaced(@NotNull World world, @NotNull EntityPlayer player, BlockPos pos) {
        IColony colony = ColonyManager.getIColonyByOwner(world, player);
        if (colony != null) {
            return EventHandler.canOwnerPlaceTownHallHere(world, player, colony, pos);
        }
        colony = ColonyManager.getClosestIColony(world, pos);
        if (colony == null) {
            return true;
        }
        return EventHandler.canPlayerPlaceTownHallHere(world, player, pos, colony);
    }

    private static boolean onBlockHutPlaced(World world, @NotNull EntityPlayer player, BlockPos pos) {
        IColony colony = ColonyManager.getIColony(world, pos);
        if (colony == null) {
            LanguageHandler.sendPlayerMessage(player, "tile.blockHut.messageNoTownHall", new Object[0]);
            return false;
        }
        if (!colony.getPermissions().hasPermission(player, Permissions.Action.PLACE_HUTS)) {
            LanguageHandler.sendPlayerMessage(player, "tile.blockHut.messageNoPermission", colony.getName());
            return false;
        }
        return true;
    }

    private static boolean canOwnerPlaceTownHallHere(World world, @NotNull EntityPlayer player, @NotNull IColony colony, BlockPos pos) {
        if (!colony.isCoordInColony(world, pos) || colony.hasTownHall()) {
            LanguageHandler.sendPlayerMessage(player, "tile.blockHutTownHall.messagePlacedAlready", new Object[0]);
            return false;
        }
        IColony currentColony = ColonyManager.getIColony(world, pos);
        if (currentColony != colony) {
            LanguageHandler.sendPlayerMessage(player, "tile.blockHutTownhall.messageTooFar", new Object[0]);
            return false;
        }
        return true;
    }

    private static boolean canPlayerPlaceTownHallHere(@NotNull World world, @NotNull EntityPlayer player, BlockPos pos, @NotNull IColony closestColony) {
        if (closestColony.isCoordInColony(world, pos)) {
            if (closestColony.hasTownHall() || !closestColony.getPermissions().isColonyMember(player)) {
                Log.getLogger().info("Can't place at: " + pos.getX() + "." + pos.getY() + "." + pos.getZ() + ". Because of townhall of: " + closestColony.getName() + " at " + closestColony.getCenter().getX() + "." + closestColony.getCenter().getY() + "." + closestColony.getCenter().getZ());
                LanguageHandler.sendPlayerMessage(player, "tile.blockHutTownHall.messageTooClose", new Object[0]);
                return false;
            }
            if (!closestColony.getPermissions().hasPermission(player, Permissions.Action.PLACE_HUTS)) {
                LanguageHandler.sendPlayerMessage(player, "tile.blockHut.messageNoPermissionPlace", closestColony.getName());
                return false;
            }
            return true;
        }
        if ((double)closestColony.getDistanceSquared(pos) <= MathUtils.square(ColonyManager.getMinimumDistanceBetweenTownHalls())) {
            Log.getLogger().info("Can't place at: " + pos.getX() + "." + pos.getY() + "." + pos.getZ() + ". Because of townhall of: " + closestColony.getName() + " at " + closestColony.getCenter().getX() + "." + closestColony.getCenter().getY() + "." + closestColony.getCenter().getZ());
            LanguageHandler.sendPlayerMessage(player, "tile.blockHutTownHall.messageTooClose", new Object[0]);
            return false;
        }
        return true;
    }

    @SubscribeEvent
    public void onWorldLoad(@NotNull WorldEvent.Load event) {
        ColonyManager.onWorldLoad(event.getWorld());
    }

    @SubscribeEvent
    public void onWorldUnload(@NotNull WorldEvent.Unload event) {
        ColonyManager.onWorldUnload(event.getWorld());
    }

    @SubscribeEvent
    public void onWorldSave(@NotNull WorldEvent.Save event) {
        ColonyManager.onWorldSave(event.getWorld());
    }
}

