/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.inventory;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemSeeds;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InventoryField
implements IInventory {
    private static final String TAG_SLOT = "slot";
    private static final String TAG_ITEMS = "items";
    private static final String TAG_CUSTOM_NAME = "name";
    private static final String TAG_INVENTORY = "inventory";
    private static final int NO_SLOT = -1;
    @NotNull
    private ItemStack[] stackResult = new ItemStack[1];
    private String customName = "";
    private boolean inventoryChanged = false;

    public InventoryField(String title) {
        this.customName = title;
    }

    public boolean hasInventoryChanged() {
        if (this.inventoryChanged) {
            this.inventoryChanged = false;
            return true;
        }
        return false;
    }

    public void readFromNBT(@NotNull NBTTagCompound compound) {
        NBTTagList nbttaglist = compound.getTagList(TAG_ITEMS, 10);
        this.stackResult = new ItemStack[this.getSizeInventory()];
        for (int i = 0; i < nbttaglist.tagCount(); ++i) {
            NBTTagCompound nbttagcompound = nbttaglist.getCompoundTagAt(i);
            int j = nbttagcompound.getByte(TAG_SLOT) & 0x7F;
            if (j == -1 || j >= this.stackResult.length) continue;
            this.stackResult[j] = ItemStack.loadItemStackFromNBT((NBTTagCompound)nbttagcompound);
        }
        if (compound.hasKey(TAG_CUSTOM_NAME, 8)) {
            this.customName = compound.getString(TAG_CUSTOM_NAME);
        }
    }

    public int getSizeInventory() {
        return 1;
    }

    public ItemStack getStackInSlot(int index) {
        return this.stackResult[0];
    }

    @Nullable
    public ItemStack decrStackSize(int index, int count) {
        if (this.stackResult[index] == null) {
            return null;
        }
        if (this.stackResult[index].stackSize <= count) {
            ItemStack itemStack1 = this.stackResult[index];
            this.stackResult[index] = null;
            this.markDirty();
            return itemStack1;
        }
        ItemStack itemstack = this.stackResult[index].splitStack(count);
        if (this.stackResult[index].stackSize == 0) {
            this.stackResult[index] = null;
        }
        this.markDirty();
        return itemstack;
    }

    @Nullable
    public ItemStack removeStackFromSlot(int index) {
        if (this.stackResult[index] == null) {
            return null;
        }
        ItemStack itemstack = this.stackResult[index];
        this.stackResult[index] = null;
        return itemstack;
    }

    public void setInventorySlotContents(int index, @Nullable ItemStack stack) {
        this.stackResult[index] = stack;
        if (stack != null && stack.stackSize > this.getInventoryStackLimit()) {
            stack.stackSize = this.getInventoryStackLimit();
        }
        this.markDirty();
    }

    public int getInventoryStackLimit() {
        return 1;
    }

    public void markDirty() {
        this.inventoryChanged = true;
    }

    public boolean isUseableByPlayer(EntityPlayer entityPlayer) {
        return true;
    }

    public void openInventory(EntityPlayer entityPlayer) {
    }

    public void closeInventory(EntityPlayer entityPlayer) {
    }

    public boolean isItemValidForSlot(int index, @Nullable ItemStack itemStack) {
        return index == 0 && itemStack != null && itemStack.getItem() instanceof ItemSeeds;
    }

    public int getField(int id) {
        return 0;
    }

    public void setField(int id, int value) {
    }

    public int getFieldCount() {
        return 0;
    }

    public void clear() {
        for (int i = 0; i < this.stackResult.length; ++i) {
            this.stackResult[i] = null;
        }
    }

    public void writeToNBT(@NotNull NBTTagCompound compound) {
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.stackResult.length; ++i) {
            if (this.stackResult[i] == null) continue;
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            nbttagcompound.setByte(TAG_SLOT, (byte)i);
            this.stackResult[i].writeToNBT(nbttagcompound);
            nbttaglist.appendTag((NBTBase)nbttagcompound);
        }
        compound.setTag(TAG_ITEMS, (NBTBase)nbttaglist);
        if (this.hasCustomName()) {
            compound.setString(TAG_CUSTOM_NAME, this.customName);
        }
        compound.setTag(TAG_INVENTORY, (NBTBase)nbttaglist);
    }

    public void setCustomName(String customName) {
        this.customName = customName;
    }

    public boolean hasCustomName() {
        return true;
    }

    @NotNull
    public ITextComponent getDisplayName() {
        return new TextComponentTranslation(this.getName(), new Object[0]);
    }

    @NotNull
    public String getName() {
        return this.hasCustomName() ? this.customName : "field.inventory";
    }
}

