/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.items;

import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.creativetab.ModCreativeTabs;
import com.minecolonies.coremod.items.AbstractItemMinecolonies;
import com.minecolonies.coremod.network.messages.SaveScanMessage;
import com.minecolonies.coremod.util.BlockPosUtil;
import com.minecolonies.coremod.util.LanguageHandler;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraft.world.gen.structure.template.TemplateManager;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemScanTool
extends AbstractItemMinecolonies {
    public ItemScanTool() {
        super("scepterSteel");
        super.setCreativeTab(ModCreativeTabs.MINECOLONIES);
        this.setMaxStackSize(1);
    }

    @NotNull
    public EnumActionResult onItemUse(ItemStack stack, EntityPlayer playerIn, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        NBTTagCompound compound;
        if (!stack.hasTagCompound()) {
            stack.setTagCompound(new NBTTagCompound());
        }
        if (!(compound = stack.getTagCompound()).hasKey("pos1")) {
            BlockPosUtil.writeToNBT(compound, "pos1", pos);
            if (worldIn.isRemote) {
                LanguageHandler.sendPlayerMessage(playerIn, "item.scepterSteel.point", new Object[0]);
            }
            return EnumActionResult.SUCCESS;
        }
        if (!compound.hasKey("pos2")) {
            BlockPos pos2 = pos;
            BlockPos pos1 = BlockPosUtil.readFromNBT(compound, "pos1");
            if (pos2.distanceSq((Vec3i)pos1) > 0.0) {
                BlockPosUtil.writeToNBT(compound, "pos2", pos2);
                if (worldIn.isRemote) {
                    LanguageHandler.sendPlayerMessage(playerIn, "item.scepterSteel.point2", new Object[0]);
                }
                return EnumActionResult.SUCCESS;
            }
            if (worldIn.isRemote) {
                LanguageHandler.sendPlayerMessage(playerIn, "item.scepterSteel.samePoint", new Object[0]);
            }
            return EnumActionResult.FAIL;
        }
        BlockPos pos1 = BlockPosUtil.readFromNBT(compound, "pos1");
        BlockPos pos2 = BlockPosUtil.readFromNBT(compound, "pos2");
        if (!worldIn.isRemote) {
            ItemScanTool.saveStructure(worldIn, pos1, pos2, playerIn);
        }
        compound.removeTag("pos1");
        compound.removeTag("pos2");
        return EnumActionResult.SUCCESS;
    }

    private static void saveStructure(@Nullable World world, @Nullable BlockPos from, @Nullable BlockPos to, @NotNull EntityPlayer player) {
        if (world == null || from == null || to == null) {
            throw new IllegalArgumentException("Invalid method call, arguments can't be null. Contact a developer.");
        }
        BlockPos blockpos = new BlockPos(Math.min(from.getX(), to.getX()), Math.min(from.getY(), to.getY()), Math.min(from.getZ(), to.getZ()));
        BlockPos blockpos1 = new BlockPos(Math.max(from.getX(), to.getX()), Math.max(from.getY(), to.getY()), Math.max(from.getZ(), to.getZ()));
        BlockPos size = blockpos1.subtract((Vec3i)blockpos).add(1, 1, 1);
        WorldServer worldserver = (WorldServer)world;
        MinecraftServer minecraftserver = world.getMinecraftServer();
        TemplateManager templatemanager = worldserver.getStructureTemplateManager();
        String currentMillis = Long.toString(System.currentTimeMillis());
        String fileName = "/minecolonies/scans/" + LanguageHandler.format("item.scepterSteel.scanFormat", "", currentMillis + ".nbt");
        Template template = templatemanager.getTemplate(minecraftserver, new ResourceLocation(fileName));
        template.takeBlocksFromWorld(world, blockpos, size, true, Blocks.STRUCTURE_VOID);
        template.setAuthor("minecolonies");
        MineColonies.getNetwork().sendTo((IMessage)new SaveScanMessage(template.writeToNBT(new NBTTagCompound()), currentMillis), (EntityPlayerMP)player);
    }
}

