/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages;

import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.ColonyManager;
import com.minecolonies.coremod.colony.ColonyView;
import com.minecolonies.coremod.colony.permissions.Permissions;
import com.minecolonies.coremod.network.messages.AbstractMessage;
import com.minecolonies.coremod.util.BlockPosUtil;
import io.netty.buffer.ByteBuf;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.jetbrains.annotations.NotNull;

public class ChangeFreeToInteractBlockMessage
extends AbstractMessage<ChangeFreeToInteractBlockMessage, IMessage> {
    private int colonyId;
    private BlockPos pos = new BlockPos(0, 0, 0);
    private Block block = Blocks.DIRT;
    private MessageType type;

    public ChangeFreeToInteractBlockMessage() {
    }

    public ChangeFreeToInteractBlockMessage(@NotNull ColonyView colony, @NotNull Block block, @NotNull MessageType type) {
        this.colonyId = colony.getID();
        this.pos = new BlockPos(0, 0, 0);
        this.block = block;
        this.type = type;
    }

    public ChangeFreeToInteractBlockMessage(@NotNull ColonyView colony, @NotNull BlockPos pos, @NotNull MessageType type) {
        this.colonyId = colony.getID();
        this.pos = pos;
        this.block = Blocks.DIRT;
        this.type = type;
    }

    public void fromBytes(@NotNull ByteBuf buf) {
        this.colonyId = buf.readInt();
        this.block = Block.getBlockFromName((String)ByteBufUtils.readUTF8String((ByteBuf)buf));
        this.pos = BlockPosUtil.readFromByteBuf(buf);
        this.type = MessageType.values()[buf.readInt()];
    }

    public void toBytes(@NotNull ByteBuf buf) {
        buf.writeInt(this.colonyId);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.block.getRegistryName().toString());
        BlockPosUtil.writeToByteBuf(buf, this.pos);
        buf.writeInt(this.type.ordinal());
    }

    @Override
    public void messageOnServerThread(ChangeFreeToInteractBlockMessage message, EntityPlayerMP player) {
        Colony colony = ColonyManager.getColony(message.colonyId);
        if (colony != null) {
            if (!colony.getPermissions().hasPermission((EntityPlayer)player, Permissions.Action.EDIT_PERMISSIONS)) {
                return;
            }
            if (message.type == MessageType.ADD_BLOCK) {
                if (message.pos.getX() != 0 || message.pos.getZ() != 0 || message.pos.getY() != 0) {
                    colony.addFreePosition(message.pos);
                } else {
                    colony.addFreeBlock(message.block);
                }
            } else if (message.pos.getX() != 0 || message.pos.getZ() != 0 || message.pos.getY() != 0) {
                colony.removeFreePosition(message.pos);
            } else {
                colony.removeFreeBlock(message.block);
            }
        }
    }

    public static enum MessageType {
        REMOVE_BLOCK,
        ADD_BLOCK;

    }
}

