/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages;

import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.ColonyManager;
import com.minecolonies.coremod.colony.buildings.AbstractBuilding;
import com.minecolonies.coremod.network.messages.AbstractMessage;
import com.minecolonies.coremod.util.BlockPosUtil;
import com.minecolonies.coremod.util.Log;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.jetbrains.annotations.NotNull;

public class MarkBuildingDirtyMessage
extends AbstractMessage<MarkBuildingDirtyMessage, IMessage> {
    private BlockPos buildingId;
    private int colonyId;

    public MarkBuildingDirtyMessage() {
    }

    public MarkBuildingDirtyMessage(@NotNull AbstractBuilding.View building) {
        this.colonyId = building.getColony().getID();
        this.buildingId = building.getID();
    }

    public void fromBytes(@NotNull ByteBuf buf) {
        this.colonyId = buf.readInt();
        this.buildingId = BlockPosUtil.readFromByteBuf(buf);
    }

    public void toBytes(@NotNull ByteBuf buf) {
        buf.writeInt(this.colonyId);
        BlockPosUtil.writeToByteBuf(buf, this.buildingId);
    }

    @Override
    public void messageOnServerThread(MarkBuildingDirtyMessage message, EntityPlayerMP player) {
        Colony colony = ColonyManager.getColony(message.colonyId);
        if (colony == null) {
            Log.getLogger().warn("TransferItemsRequestMessage colony is null");
            return;
        }
        AbstractBuilding building = colony.getBuilding(message.buildingId);
        if (building == null) {
            Log.getLogger().warn("TransferItemsRequestMessage building is null");
            return;
        }
        building.getTileEntity().markDirty();
    }
}

