/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.permissions;

import com.minecolonies.coremod.blocks.AbstractBlockHut;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.jobs.JobGuard;
import com.minecolonies.coremod.colony.permissions.Permissions;
import com.minecolonies.coremod.configuration.Configurations;
import com.minecolonies.coremod.entity.EntityCitizen;
import com.minecolonies.coremod.items.ItemScanTool;
import com.minecolonies.coremod.util.EntityUtils;
import com.minecolonies.coremod.util.LanguageHandler;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemPotion;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.player.ArrowLooseEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.FillBucketEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ColonyPermissionEventHandler {
    private final Colony colony;

    public ColonyPermissionEventHandler(Colony colony) {
        this.colony = colony;
    }

    @SubscribeEvent
    public void on(BlockEvent.PlaceEvent event) {
        if (Configurations.enableColonyProtection && this.checkBlockEventDenied(event.getWorld(), event.getPos(), event.getPlayer(), event.getPlacedBlock(), event.getPlacedBlock().getBlock() instanceof AbstractBlockHut ? Permissions.Action.PLACE_HUTS : Permissions.Action.PLACE_BLOCKS)) {
            ColonyPermissionEventHandler.cancelEvent((Event)event, event.getPlayer());
        }
    }

    private boolean checkBlockEventDenied(World worldIn, BlockPos posIn, EntityPlayer playerIn, IBlockState blockState, Permissions.Action action) {
        EntityPlayer player = EntityUtils.getPlayerOfFakePlayer(playerIn, worldIn);
        if (this.colony.isCoordInColony(worldIn, posIn)) {
            if (!this.colony.getPermissions().isColonyMember(player)) {
                return true;
            }
            if (blockState.getBlock() instanceof AbstractBlockHut && this.colony.getPermissions().hasPermission(player, action)) {
                return false;
            }
            return !this.colony.getPermissions().hasPermission(player, action);
        }
        return false;
    }

    private static void cancelEvent(Event event, @Nullable EntityPlayer player) {
        event.setResult(Event.Result.DENY);
        if (event.isCancelable()) {
            event.setCanceled(true);
            if (player == null || player instanceof FakePlayer) {
                return;
            }
            LanguageHandler.sendPlayerMessage(player, "com.minecolonies.coremod.permission.no", new Object[0]);
        }
    }

    @SubscribeEvent
    public void on(BlockEvent.BreakEvent event) {
        if (Configurations.enableColonyProtection && this.checkBlockEventDenied(event.getWorld(), event.getPos(), event.getPlayer(), event.getWorld().getBlockState(event.getPos()), event.getWorld().getBlockState(event.getPos()).getBlock() instanceof AbstractBlockHut ? Permissions.Action.BREAK_HUTS : Permissions.Action.BREAK_BLOCKS)) {
            ColonyPermissionEventHandler.cancelEvent((Event)event, event.getPlayer());
        }
    }

    @SubscribeEvent
    public void on(ExplosionEvent.Detonate event) {
        if (!Configurations.enableColonyProtection || !Configurations.turnOffExplosionsInColonies) {
            return;
        }
        World eventWorld = event.getWorld();
        Predicate<BlockPos> getBlocksInColony = pos -> this.colony.isCoordInColony(eventWorld, (BlockPos)pos);
        Predicate<Entity> getEntitiesInColony = entity -> this.colony.isCoordInColony(entity.getEntityWorld(), entity.getPosition());
        List blocksToRemove = event.getAffectedBlocks().stream().filter(getBlocksInColony).collect(Collectors.toList());
        List entitiesToRemove = event.getAffectedEntities().stream().filter(getEntitiesInColony).collect(Collectors.toList());
        event.getAffectedBlocks().removeAll(blocksToRemove);
        event.getAffectedEntities().removeAll(entitiesToRemove);
    }

    @SubscribeEvent
    public void on(ExplosionEvent.Start event) {
        if (Configurations.enableColonyProtection && Configurations.turnOffExplosionsInColonies && this.colony.isCoordInColony(event.getWorld(), new BlockPos(event.getExplosion().getPosition()))) {
            ColonyPermissionEventHandler.cancelEvent((Event)event, null);
        }
    }

    @SubscribeEvent
    public void on(PlayerInteractEvent event) {
        if (this.colony.isCoordInColony(event.getWorld(), event.getPos()) && !(event instanceof PlayerInteractEvent.EntityInteract) && !(event instanceof PlayerInteractEvent.EntityInteractSpecific)) {
            Block block = event.getWorld().getBlockState(event.getPos()).getBlock();
            if (block instanceof AbstractBlockHut && !this.colony.getPermissions().hasPermission(event.getEntityPlayer(), Permissions.Action.ACCESS_HUTS)) {
                ColonyPermissionEventHandler.cancelEvent((Event)event, event.getEntityPlayer());
            }
            Permissions perms = this.colony.getPermissions();
            if (this.isFreeToInteractWith(event.getWorld().getBlockState(event.getPos()).getBlock(), event.getPos()) && perms.hasPermission(event.getEntityPlayer(), Permissions.Action.ACCESS_FREE_BLOCKS)) {
                return;
            }
            if (Configurations.enableColonyProtection) {
                if (!perms.hasPermission(event.getEntityPlayer(), Permissions.Action.RIGHTCLICK_BLOCK) && event.getWorld().getBlockState(event.getPos()).getBlock() != null) {
                    ColonyPermissionEventHandler.cancelEvent((Event)event, event.getEntityPlayer());
                }
                if (event.getWorld().getBlockState(event.getPos()).getBlock() instanceof BlockContainer && !perms.hasPermission(event.getEntityPlayer(), Permissions.Action.OPEN_CONTAINER)) {
                    ColonyPermissionEventHandler.cancelEvent((Event)event, event.getEntityPlayer());
                }
                if (event.getWorld().getTileEntity(event.getPos()) != null && !perms.hasPermission(event.getEntityPlayer(), Permissions.Action.RIGHTCLICK_ENTITY)) {
                    ColonyPermissionEventHandler.cancelEvent((Event)event, event.getEntityPlayer());
                }
                if (event.getItemStack() != null && event.getItemStack().getItem() instanceof ItemPotion && !perms.hasPermission(event.getEntityPlayer(), Permissions.Action.THROW_POTION)) {
                    ColonyPermissionEventHandler.cancelEvent((Event)event, event.getEntityPlayer());
                }
                if (event.getItemStack() != null && event.getItemStack().getItem() instanceof ItemScanTool && !perms.hasPermission(event.getEntityPlayer(), Permissions.Action.USE_SCAN_TOOL)) {
                    ColonyPermissionEventHandler.cancelEvent((Event)event, event.getEntityPlayer());
                }
            }
        }
    }

    private void checkEventCancelation(Permissions.Action action, @NotNull EntityPlayer playerIn, @NotNull World world, @NotNull Event event) {
        EntityPlayer player = EntityUtils.getPlayerOfFakePlayer(playerIn, world);
        if (Configurations.enableColonyProtection && this.colony.isCoordInColony(player.getEntityWorld(), player.getPosition()) && !this.colony.getPermissions().hasPermission(player, action)) {
            ColonyPermissionEventHandler.cancelEvent(event, player);
        }
    }

    @SubscribeEvent
    public void on(PlayerInteractEvent.EntityInteract event) {
        if (this.isFreeToInteractWith(null, event.getPos()) && this.colony.getPermissions().hasPermission(event.getEntityPlayer(), Permissions.Action.ACCESS_FREE_BLOCKS)) {
            return;
        }
        this.checkEventCancelation(Permissions.Action.RIGHTCLICK_ENTITY, event.getEntityPlayer(), event.getWorld(), (Event)event);
    }

    @SubscribeEvent
    public void on(PlayerInteractEvent.EntityInteractSpecific event) {
        if (this.isFreeToInteractWith(null, event.getPos()) && this.colony.getPermissions().hasPermission(event.getEntityPlayer(), Permissions.Action.ACCESS_FREE_BLOCKS)) {
            return;
        }
        this.checkEventCancelation(Permissions.Action.RIGHTCLICK_ENTITY, event.getEntityPlayer(), event.getWorld(), (Event)event);
    }

    private boolean isFreeToInteractWith(@Nullable Block block, BlockPos pos) {
        return block != null && this.colony.getFreeBlocks().stream().anyMatch(b -> b.equals(block)) || this.colony.getFreePositions().stream().anyMatch(position -> position.equals((Object)pos));
    }

    @SubscribeEvent
    public void on(ItemTossEvent event) {
        this.checkEventCancelation(Permissions.Action.TOSS_ITEM, event.getPlayer(), event.getPlayer().getEntityWorld(), (Event)event);
    }

    @SubscribeEvent
    public void on(EntityItemPickupEvent event) {
        this.checkEventCancelation(Permissions.Action.PICKUP_ITEM, event.getEntityPlayer(), event.getEntityPlayer().getEntityWorld(), (Event)event);
    }

    @SubscribeEvent
    public void on(FillBucketEvent event) {
        this.checkEventCancelation(Permissions.Action.FILL_BUCKET, event.getEntityPlayer(), event.getEntityPlayer().getEntityWorld(), (Event)event);
    }

    @SubscribeEvent
    public void on(ArrowLooseEvent event) {
        this.checkEventCancelation(Permissions.Action.SHOOT_ARROW, event.getEntityPlayer(), event.getEntityPlayer().getEntityWorld(), (Event)event);
    }

    @SubscribeEvent
    public void on(AttackEntityEvent event) {
        if (event.getTarget() instanceof EntityMob) {
            return;
        }
        EntityPlayer player = EntityUtils.getPlayerOfFakePlayer(event.getEntityPlayer(), event.getEntityPlayer().getEntityWorld());
        if (Configurations.enableColonyProtection && this.colony.isCoordInColony(player.getEntityWorld(), player.getPosition())) {
            Permissions perms = this.colony.getPermissions();
            if (event.getTarget() instanceof EntityCitizen) {
                EntityCitizen citizen = (EntityCitizen)event.getTarget();
                if (citizen.getColonyJob() instanceof JobGuard && perms.hasPermission(event.getEntityPlayer(), Permissions.Action.GUARDS_ATTACK)) {
                    return;
                }
                if (perms.hasPermission(event.getEntityPlayer(), Permissions.Action.ATTACK_CITIZEN)) {
                    return;
                }
                ColonyPermissionEventHandler.cancelEvent((Event)event, player);
                return;
            }
            if (!perms.hasPermission(event.getEntityPlayer(), Permissions.Action.ATTACK_ENTITY)) {
                ColonyPermissionEventHandler.cancelEvent((Event)event, player);
            }
        }
    }
}

