/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.tileentities;

import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.ColonyManager;
import com.minecolonies.coremod.colony.ColonyView;
import com.minecolonies.coremod.colony.buildings.AbstractBuilding;
import com.minecolonies.coremod.colony.permissions.Permissions;
import com.minecolonies.coremod.util.Log;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.math.BlockPos;
import org.jetbrains.annotations.NotNull;

public class TileEntityColonyBuilding
extends TileEntityChest {
    private static final String TAG_COLONY = "colony";
    private static final String TAG_MIRROR = "mirror";
    private static final String TAG_STYLE = "style";
    private int colonyId = 0;
    private Colony colony;
    private AbstractBuilding building;
    private boolean mirror;
    private String style = "";

    public SPacketUpdateTileEntity getUpdatePacket() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.setInteger(TAG_COLONY, this.colonyId);
        return new SPacketUpdateTileEntity(this.getPosition(), 0, compound);
    }

    @NotNull
    public NBTTagCompound getUpdateTag() {
        return this.writeToNBT(new NBTTagCompound());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        NBTTagCompound compound = packet.getNbtCompound();
        this.colonyId = compound.getInteger(TAG_COLONY);
    }

    public void onChunkUnload() {
        if (this.building != null) {
            this.building.setTileEntity(null);
        }
    }

    public BlockPos getPosition() {
        return this.pos;
    }

    public int getColonyId() {
        return this.colonyId;
    }

    public Colony getColony() {
        if (this.colony == null) {
            this.updateColonyReferences();
        }
        return this.colony;
    }

    private void updateColonyReferences() {
        if (this.colony == null && this.worldObj != null) {
            this.colony = this.colonyId == 0 ? ColonyManager.getColony(this.worldObj, this.getPos()) : ColonyManager.getColony(this.colonyId);
            if (this.colony == null && !this.worldObj.isRemote) {
                Log.getLogger().warn(String.format("TileEntityColonyBuilding at %s:[%d,%d,%d] had colony.", this.worldObj.getWorldInfo().getWorldName(), this.pos.getX(), this.pos.getY(), this.pos.getZ()));
            }
        }
        if (this.building == null && this.colony != null) {
            this.building = this.colony.getBuilding(this.getPosition());
            if (!(this.building == null || this.worldObj != null && this.worldObj.isRemote)) {
                this.building.setTileEntity(this);
            }
        }
    }

    public void update() {
        Colony tempColony;
        super.update();
        if (!this.worldObj.isRemote && this.colonyId == 0 && (tempColony = ColonyManager.getColony(this.worldObj, this.getPosition())) != null) {
            this.colonyId = tempColony.getID();
        }
    }

    public void setColony(Colony c) {
        this.colony = c;
        this.colonyId = c.getID();
        this.markDirty();
    }

    public AbstractBuilding getBuilding() {
        if (this.building == null) {
            this.updateColonyReferences();
        }
        return this.building;
    }

    public void setBuilding(AbstractBuilding b) {
        this.building = b;
    }

    public void markDirty() {
        super.markDirty();
        if (this.building != null) {
            this.building.markDirty();
        }
    }

    public AbstractBuilding.View getBuildingView() {
        ColonyView c = ColonyManager.getColonyView(this.colonyId);
        return c == null ? null : c.getBuilding(this.getPosition());
    }

    public void readFromNBT(NBTTagCompound compound) {
        super.readFromNBT(compound);
        if (compound.hasKey(TAG_COLONY)) {
            this.colonyId = compound.getInteger(TAG_COLONY);
        }
        this.updateColonyReferences();
        this.mirror = compound.getBoolean(TAG_MIRROR);
        this.style = compound.getString(TAG_STYLE);
    }

    @NotNull
    public NBTTagCompound writeToNBT(@NotNull NBTTagCompound compound) {
        super.writeToNBT(compound);
        compound.setInteger(TAG_COLONY, this.colonyId);
        compound.setBoolean(TAG_MIRROR, this.mirror);
        compound.setString(TAG_STYLE, this.style);
        return compound;
    }

    public boolean isUseableByPlayer(@NotNull EntityPlayer player) {
        return super.isUseableByPlayer(player) && this.hasAccessPermission(player);
    }

    public boolean hasAccessPermission(EntityPlayer player) {
        return this.building == null || this.building.getColony().getPermissions().hasPermission(player, Permissions.Action.ACCESS_HUTS);
    }

    public void setMirror(boolean mirror) {
        this.mirror = mirror;
    }

    public boolean isMirrored() {
        return this.mirror;
    }

    public void setStyle(String style) {
        this.style = style;
    }

    public String getStyle() {
        return this.style;
    }
}

