/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.util;

import com.minecolonies.coremod.util.LanguageHandler;
import com.minecolonies.coremod.util.Log;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

public final class ClientStructureWrapper {
    private ClientStructureWrapper() {
    }

    public static void handleSaveScanMessage(NBTTagCompound nbttagcompound, String currentMillis) {
        String fileName = "/minecolonies/scans/" + LanguageHandler.format("item.scepterSteel.scanFormat", currentMillis, ".nbt");
        File file = new File(Minecraft.getMinecraft().mcDataDir, fileName);
        ClientStructureWrapper.createScanDirectory((World)Minecraft.getMinecraft().theWorld);
        try (FileOutputStream outputstream = new FileOutputStream(file);){
            CompressedStreamTools.writeCompressed((NBTTagCompound)nbttagcompound, (OutputStream)outputstream);
        }
        catch (IOException e) {
            LanguageHandler.sendPlayerMessage((EntityPlayer)Minecraft.getMinecraft().thePlayer, "item.scepterSteel.scanFailure", new Object[0]);
            Log.getLogger().warn("Exception while trying to scan.", (Throwable)e);
            return;
        }
        LanguageHandler.sendPlayerMessage((EntityPlayer)Minecraft.getMinecraft().thePlayer, "item.scepterSteel.scanSuccess", fileName);
    }

    private static void createScanDirectory(@NotNull World world) {
        File minecolonies;
        if (world.isRemote) {
            minecolonies = new File(Minecraft.getMinecraft().mcDataDir, "minecolonies/");
        } else {
            MinecraftServer server = world.getMinecraftServer();
            if (server == null) {
                return;
            }
            minecolonies = server.getFile("minecolonies/");
        }
        ClientStructureWrapper.checkDirectory(minecolonies);
        File scans = new File(minecolonies, "scans/");
        ClientStructureWrapper.checkDirectory(scans);
    }

    private static void checkDirectory(@NotNull File directory) {
        if (!directory.exists() && !directory.mkdirs()) {
            Log.getLogger().error("Directory doesn't exist and failed to be created: " + directory.toString());
        }
    }
}

