/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.util;

import com.minecolonies.coremod.inventory.api.IWorldNameableModifiable;
import com.minecolonies.coremod.util.InventoryUtils;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class IItemHandlerToIInventoryWrapper
implements IInventory {
    private static final int CONSTANT_MAX_STACKSIZE = 64;
    private final IItemHandlerModifiable wrapped;
    private final IWorldNameableModifiable named;

    public IItemHandlerToIInventoryWrapper(IItemHandlerModifiable wrapped, IWorldNameableModifiable named) {
        this.wrapped = wrapped;
        this.named = named;
    }

    public int getSizeInventory() {
        return this.wrapped.getSlots();
    }

    @Nullable
    public ItemStack getStackInSlot(int index) {
        return this.wrapped.getStackInSlot(index);
    }

    @Nullable
    public ItemStack decrStackSize(int index, int count) {
        return this.wrapped.extractItem(index, count, false);
    }

    @Nullable
    public ItemStack removeStackFromSlot(int index) {
        return this.decrStackSize(index, Integer.MAX_VALUE);
    }

    public void setInventorySlotContents(int index, @Nullable ItemStack stack) {
        this.wrapped.setStackInSlot(index, stack);
    }

    public int getInventoryStackLimit() {
        return 64;
    }

    public void markDirty() {
    }

    public boolean isUseableByPlayer(EntityPlayer player) {
        return true;
    }

    public void openInventory(EntityPlayer player) {
    }

    public void closeInventory(EntityPlayer player) {
    }

    public boolean isItemValidForSlot(int index, ItemStack stack) {
        return this.wrapped.insertItem(index, stack, true) == InventoryUtils.EMPTY;
    }

    public int getField(int id) {
        return 0;
    }

    public void setField(int id, int value) {
    }

    public int getFieldCount() {
        return 0;
    }

    public void clear() {
        InventoryUtils.clearItemHandler((IItemHandler)this.wrapped);
    }

    public String getName() {
        return this.named.getName();
    }

    public boolean hasCustomName() {
        return this.named.hasCustomName();
    }

    public ITextComponent getDisplayName() {
        return this.named.getDisplayName();
    }
}

