/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.util;

import com.minecolonies.coremod.util.InventoryUtils;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.ObjIntConsumer;
import java.util.function.Predicate;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InventoryFunctions {
    public static void doNothing(Object ... o) {
    }

    public static boolean matchFirstInProvider(ICapabilityProvider provider, @NotNull Predicate<ItemStack> tester, @NotNull Consumer<Integer> action) {
        return InventoryFunctions.matchFirstInProvider(provider, (ICapabilityProvider inv) -> slot -> stack -> {
            if (tester.test((ItemStack)stack)) {
                action.accept((Integer)slot);
                return true;
            }
            return false;
        });
    }

    private static boolean matchFirstInProvider(ICapabilityProvider provider, @NotNull Function<ICapabilityProvider, Function<Integer, Predicate<ItemStack>>> tester) {
        return InventoryFunctions.matchInProvider(provider, tester, true);
    }

    private static boolean matchInProvider(@Nullable ICapabilityProvider provider, @NotNull Function<ICapabilityProvider, Function<Integer, Predicate<ItemStack>>> tester, boolean stopAfterFirst) {
        if (provider == null) {
            return false;
        }
        boolean foundOne = false;
        for (IItemHandler handler : InventoryUtils.getItemHandlersFromProvider(provider)) {
            int size = handler.getSlots();
            for (int slot = 0; slot < size; ++slot) {
                ItemStack stack = handler.getStackInSlot(slot);
                if (!tester.apply(provider).apply(slot).test(stack)) continue;
                foundOne = true;
                if (!stopAfterFirst) continue;
                return true;
            }
        }
        return foundOne;
    }

    public static boolean matchFirstInProviderWithAction(ICapabilityProvider provider, @NotNull Predicate<ItemStack> tester, @NotNull IMatchActionResult action) {
        return InventoryFunctions.matchFirstInProvider(provider, (ICapabilityProvider inv) -> slot -> stack -> {
            if (tester.test((ItemStack)stack)) {
                action.accept(provider, (int)slot);
                return true;
            }
            return false;
        });
    }

    public static boolean matchFirstInProvider(ICapabilityProvider inventory, @NotNull BiPredicate<Integer, ItemStack> tester) {
        return InventoryFunctions.matchFirstInProvider(inventory, (ICapabilityProvider inv) -> slot -> stack -> tester.test((Integer)slot, (ItemStack)stack));
    }

    @FunctionalInterface
    public static interface IMatchActionResult
    extends ObjIntConsumer<ICapabilityProvider> {
        @Override
        public void accept(ICapabilityProvider var1, int var2);
    }
}

