/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.util;

import com.minecolonies.coremod.blocks.ModBlocks;
import com.minecolonies.coremod.configuration.Configurations;
import com.minecolonies.coremod.util.BlockPosUtil;
import com.minecolonies.coremod.util.BlockUtils;
import com.minecolonies.coremod.util.Log;
import com.minecolonies.structures.helpers.StructureProxy;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class StructureWrapper {
    private static final BlockPos NULL_POS = new BlockPos(-1, -1, -1);
    private final BlockPos.MutableBlockPos progressPos = new BlockPos.MutableBlockPos(-1, -1, -1);
    private final World world;
    private final StructureProxy structure;
    private BlockPos position;
    private final String name;

    public StructureWrapper(World worldObj, String name) {
        this(worldObj, new StructureProxy(worldObj, name), name);
    }

    private StructureWrapper(World worldObj, StructureProxy structure, String name) {
        this.world = worldObj;
        this.structure = structure;
        this.name = name;
    }

    @NotNull
    private static ResourceLocation getResourceLocation(@NotNull String name) {
        return new ResourceLocation("minecolonies:schematics/" + name + ".nbt");
    }

    public static InputStream getStream(@NotNull ResourceLocation res) {
        try {
            if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
                return Minecraft.getMinecraft().getResourceManager().getResource(res).getInputStream();
            }
            return StructureWrapper.class.getResourceAsStream(String.format("/assets/%s/%s", res.getResourceDomain(), res.getResourcePath()));
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not load stream!", e);
        }
    }

    public static void loadAndPlaceStructureWithRotation(World worldObj, @NotNull String name, @NotNull BlockPos pos, int rotations, @NotNull Mirror mirror) {
        try {
            StructureWrapper structureWrapper = new StructureWrapper(worldObj, name);
            structureWrapper.rotate(rotations, worldObj, pos, mirror);
            structureWrapper.placeStructure(pos);
        }
        catch (IllegalStateException e) {
            Log.getLogger().warn("Could not load structure!", (Throwable)e);
        }
    }

    public static boolean tryToLoadAndPlaceSupplyCampWithRotation(World worldObj, @NotNull String name, @NotNull BlockPos pos, int rotations, @NotNull Mirror mirror) {
        try {
            StructureWrapper structureWrapper = new StructureWrapper(worldObj, name);
            structureWrapper.rotate(rotations, worldObj, pos, mirror);
            if (structureWrapper.checkForFreeSpace(pos)) {
                structureWrapper.placeStructure(pos);
                return true;
            }
            return false;
        }
        catch (IllegalStateException e) {
            Log.getLogger().warn("Could not load structure!", (Throwable)e);
            return false;
        }
    }

    public void rotate(int times, @NotNull World world, @NotNull BlockPos rotatePos, @NotNull Mirror mirror) {
        this.structure.rotateWithMirror(times, world, rotatePos, mirror);
    }

    private boolean checkForFreeSpace(@NotNull BlockPos pos) {
        this.setLocalPosition(pos);
        for (int j = 0; j < this.structure.getHeight(); ++j) {
            for (int k = 0; k < this.structure.getLength(); ++k) {
                for (int i = 0; i < this.structure.getWidth(); ++i) {
                    BlockPos localPos = new BlockPos(i, j, k);
                    BlockPos worldPos = pos.add((Vec3i)localPos);
                    if (worldPos.getY() <= pos.getY() && !this.world.getBlockState(worldPos.down()).getMaterial().isSolid()) {
                        return false;
                    }
                    IBlockState worldState = this.world.getBlockState(worldPos);
                    if (worldState.getBlock() == Blocks.BEDROCK) {
                        return false;
                    }
                    if (worldPos.getY() <= pos.getY() || worldState.getBlock() == Blocks.AIR) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private void placeStructure(@NotNull BlockPos pos) {
        this.setLocalPosition(pos);
        ArrayList<BlockPos> delayedBlocks = new ArrayList<BlockPos>();
        for (int j = 0; j < this.structure.getHeight(); ++j) {
            for (int k = 0; k < this.structure.getLength(); ++k) {
                for (int i = 0; i < this.structure.getWidth(); ++i) {
                    BlockPos localPos = new BlockPos(i, j, k);
                    IBlockState localState = this.structure.getBlockState(localPos);
                    Block localBlock = localState.getBlock();
                    BlockPos worldPos = pos.add((Vec3i)localPos);
                    IBlockState worldState = this.world.getBlockState(worldPos);
                    if (localBlock == ModBlocks.blockSubstitution) continue;
                    if (localBlock == ModBlocks.blockSolidSubstitution) {
                        if (worldState.getMaterial().isSolid()) continue;
                        IBlockState subBlock = BlockUtils.getSubstitutionBlockAtWorld(this.world, worldPos);
                        this.placeBlock(subBlock, subBlock.getBlock(), worldPos);
                        continue;
                    }
                    if (localBlock == Blocks.AIR && !worldState.getMaterial().isSolid()) {
                        this.world.setBlockToAir(worldPos);
                        continue;
                    }
                    if (localState.getMaterial().isSolid()) {
                        this.placeBlock(localState, localBlock, worldPos);
                        continue;
                    }
                    delayedBlocks.add(localPos);
                }
            }
        }
        for (BlockPos coords : delayedBlocks) {
            IBlockState localState = this.structure.getBlockState(coords);
            Block localBlock = localState.getBlock();
            BlockPos newWorldPos = pos.add((Vec3i)coords);
            this.placeBlock(localState, localBlock, newWorldPos);
        }
    }

    private void placeBlock(IBlockState localState, @NotNull Block localBlock, @NotNull BlockPos worldPos) {
        this.world.setBlockState(worldPos, localState, 3);
        if (this.world.getBlockState(worldPos).getBlock() == localBlock) {
            if (this.world.getBlockState(worldPos) != localState) {
                this.world.setBlockState(worldPos, localState, 3);
            }
            localBlock.onBlockAdded(this.world, worldPos, localState);
        }
    }

    public boolean findNextBlock() {
        int count = 0;
        do {
            ++count;
            if (this.incrementBlock()) continue;
            return false;
        } while (this.doesStructureBlockEqualWorldBlock() && count < Configurations.maxBlocksCheckedByBuilder);
        return true;
    }

    public boolean incrementBlock() {
        if (this.progressPos.equals((Object)NULL_POS)) {
            this.progressPos.setPos(-1, 0, 0);
        }
        this.progressPos.setPos(this.progressPos.getX() + 1, this.progressPos.getY(), this.progressPos.getZ());
        if (this.progressPos.getX() == this.structure.getWidth()) {
            this.progressPos.setPos(0, this.progressPos.getY(), this.progressPos.getZ() + 1);
            if (this.progressPos.getZ() == this.structure.getLength()) {
                this.progressPos.setPos(this.progressPos.getX(), this.progressPos.getY() + 1, 0);
                if (this.progressPos.getY() == this.structure.getHeight()) {
                    this.reset();
                    return false;
                }
            }
        }
        return true;
    }

    public boolean doesStructureBlockEqualWorldBlock() {
        IBlockState structureBlockState = this.structure.getBlockState(this.getLocalPosition());
        Block structureBlock = structureBlockState.getBlock();
        if (structureBlock == ModBlocks.blockSubstitution) {
            return true;
        }
        BlockPos worldPos = this.getBlockPosition();
        IBlockState worldBlockState = this.world.getBlockState(worldPos);
        if (structureBlock instanceof BlockDoor || structureBlock == Blocks.FLOWER_POT) {
            return structureBlock == worldBlockState.getBlock();
        }
        if (structureBlock instanceof BlockStairs && structureBlockState == worldBlockState) {
            return true;
        }
        Template.EntityInfo entityInfo = this.structure.getEntityinfo(this.getLocalPosition());
        if (entityInfo != null) {
            return false;
        }
        return worldPos.getY() <= 0 || structureBlockState == worldBlockState;
    }

    public void reset() {
        BlockPosUtil.set(this.progressPos, NULL_POS);
    }

    @NotNull
    public BlockPos getLocalPosition() {
        return this.progressPos.toImmutable();
    }

    public void setLocalPosition(@NotNull BlockPos localPosition) {
        BlockPosUtil.set(this.progressPos, localPosition);
    }

    public BlockPos getBlockPosition() {
        return this.progressPos.add((Vec3i)this.getOffsetPosition());
    }

    public BlockPos getOffsetPosition() {
        return this.position.subtract((Vec3i)this.getOffset());
    }

    public BlockPos getOffset() {
        return this.structure.getOffset();
    }

    public boolean findNextBlockToClear() {
        int count = 0;
        do {
            ++count;
            if (this.decrementBlock()) continue;
            return false;
        } while ((this.worldBlockAir() || this.doesStructureBlockEqualWorldBlock()) && count < Configurations.maxBlocksCheckedByBuilder);
        return true;
    }

    public boolean findNextBlockSolid() {
        int count = 0;
        do {
            ++count;
            if (this.incrementBlock()) continue;
            return false;
        } while ((this.doesStructureBlockEqualWorldBlock() || this.isBlockNonSolid()) && count < Configurations.maxBlocksCheckedByBuilder);
        return true;
    }

    private boolean isBlockNonSolid() {
        IBlockState state = this.getBlockState();
        return state != null && !state.getMaterial().isSolid();
    }

    @Nullable
    public IBlockState getBlockState() {
        if (this.progressPos.equals((Object)NULL_POS)) {
            return null;
        }
        return this.structure.getBlockState((BlockPos)this.progressPos);
    }

    @Nullable
    public Block getBlock() {
        IBlockState state = this.getBlockState();
        if (state == null) {
            return null;
        }
        return state.getBlock();
    }

    public boolean findNextBlockNonSolid() {
        int count = 0;
        do {
            ++count;
            if (this.incrementBlock()) continue;
            return false;
        } while ((this.doesStructureBlockEqualWorldBlock() || this.isBlockSolid()) && count < Configurations.maxBlocksCheckedByBuilder);
        return true;
    }

    private boolean isBlockSolid() {
        IBlockState state = this.getBlockState();
        return state != null && state.getMaterial().isSolid();
    }

    public boolean decrementBlock() {
        if (this.progressPos.equals((Object)NULL_POS)) {
            this.progressPos.setPos(this.structure.getWidth(), this.structure.getHeight() - 1, this.structure.getLength() - 1);
        }
        this.progressPos.setPos(this.progressPos.getX() - 1, this.progressPos.getY(), this.progressPos.getZ());
        if (this.progressPos.getX() == -1) {
            this.progressPos.setPos(this.structure.getWidth() - 1, this.progressPos.getY(), this.progressPos.getZ() - 1);
            if (this.progressPos.getZ() == -1) {
                this.progressPos.setPos(this.progressPos.getX(), this.progressPos.getY() - 1, this.structure.getLength() - 1);
                if (this.progressPos.getY() == -1) {
                    this.reset();
                    return false;
                }
            }
        }
        return true;
    }

    private boolean worldBlockAir() {
        BlockPos pos = this.getBlockPosition();
        return pos.getY() <= 0 || this.world.isAirBlock(pos);
    }

    @NotNull
    public List<Template.EntityInfo> getEntities() {
        return this.structure.getTileEntities();
    }

    public BlockPos getPosition() {
        if (this.position == null) {
            return new BlockPos(0, 0, 0);
        }
        return this.position;
    }

    public void setPosition(BlockPos position) {
        this.position = position;
    }

    @Nullable
    public Item getItem() {
        Block block = this.getBlock();
        IBlockState blockState = this.getBlockState();
        if (block == null || blockState == null || block == Blocks.AIR || blockState.getMaterial().isLiquid()) {
            return null;
        }
        return BlockUtils.getItemStackFromBlockState(blockState).getItem();
    }

    public String getName() {
        return this.name;
    }

    public int getHeight() {
        return this.structure.getHeight();
    }

    public int getWidth() {
        return this.structure.getWidth();
    }

    public int getLength() {
        return this.structure.getLength();
    }

    public StructureProxy structure() {
        return this.structure;
    }

    @Nullable
    public Template.BlockInfo getBlockInfo() {
        if (this.progressPos.equals((Object)NULL_POS)) {
            return null;
        }
        return this.structure.getBlockInfo((BlockPos)this.progressPos);
    }

    @Nullable
    public Template.EntityInfo getEntityinfo() {
        if (this.progressPos.equals((Object)NULL_POS)) {
            return null;
        }
        return this.structure.getEntityinfo((BlockPos)this.progressPos);
    }
}

