/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.util;

import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.ColonyManager;
import com.minecolonies.coremod.colony.IColony;
import com.minecolonies.coremod.colony.buildings.BuildingTownHall;
import com.minecolonies.coremod.commands.MinecoloniesCommand;
import com.minecolonies.coremod.configuration.Configurations;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import org.jetbrains.annotations.NotNull;

public final class TeleportToColony {
    private static final String CANT_FIND_COLONY = "No Colony found for teleport, please define one.";
    private static final String CANT_FIND_PLAYER = "No player found for teleport, please define one.";
    private static final String NO_TOWNHALL = "Target colony has no town hall, can't teleport.";

    private TeleportToColony() {
    }

    @NotNull
    public static void colonyTeleport(@NotNull MinecraftServer server, @NotNull ICommandSender sender, String ... args) {
        int colonyId;
        EntityPlayer playerToTeleport;
        if (sender instanceof EntityPlayer) {
            if (args.length == 0) {
                playerToTeleport = (EntityPlayer)sender;
                IColony colony = ColonyManager.getIColonyByOwner(((EntityPlayer)sender).worldObj, (EntityPlayer)sender);
                colonyId = colony.getID();
            } else {
                playerToTeleport = (EntityPlayer)sender;
                colonyId = Integer.valueOf(args[0]);
            }
        } else {
            sender.getCommandSenderEntity().addChatMessage((ITextComponent)new TextComponentString(CANT_FIND_PLAYER));
            return;
        }
        if (MinecoloniesCommand.canExecuteCommand((EntityPlayer)sender)) {
            TeleportToColony.teleportPlayer(playerToTeleport, colonyId, sender);
            return;
        }
        sender.getCommandSenderEntity().addChatMessage((ITextComponent)new TextComponentString("Please wait at least " + Configurations.teleportBuffer + " seconds to teleport again"));
    }

    private static void teleportPlayer(EntityPlayer playerToTeleport, int colID, ICommandSender sender) {
        Colony colony = ColonyManager.getColony(colID);
        BuildingTownHall townHall = colony.getTownHall();
        if (townHall == null) {
            sender.getCommandSenderEntity().addChatMessage((ITextComponent)new TextComponentString(NO_TOWNHALL));
            return;
        }
        playerToTeleport.getCommandSenderEntity().addChatMessage((ITextComponent)new TextComponentString("We got places to go, kid..."));
        BlockPos position = townHall.getLocation();
        if (colID >= 1) {
            playerToTeleport.setPositionAndUpdate((double)position.getX(), (double)position.getY() + 2.0, (double)position.getZ());
        } else {
            playerToTeleport.getCommandSenderEntity().addChatMessage((ITextComponent)new TextComponentString(CANT_FIND_COLONY));
        }
    }
}

