/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.util;

import com.minecolonies.compatibility.Compatibility;
import com.minecolonies.coremod.util.BlockPosUtil;
import java.util.Objects;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Utils {
    public static final String PICKAXE = "pickaxe";
    public static final String SHOVEL = "shovel";
    public static final String AXE = "axe";
    public static final String HOE = "hoe";
    public static final String WEAPON = "weapon";
    private static final int FORTUNE_ENCHANT_ID = 35;

    private Utils() {
    }

    @Nullable
    public static BlockPos scanForBlockNearPoint(@NotNull World world, @NotNull BlockPos point, int radiusX, int radiusY, int radiusZ, int height, Block ... blocks) {
        BlockPos closestCoords = null;
        double minDistance = Double.MAX_VALUE;
        for (int i = point.getX() - radiusX; i <= point.getX() + radiusX; ++i) {
            for (int j = point.getY() - radiusY; j <= point.getY() + radiusY; ++j) {
                for (int k = point.getZ() - radiusZ; k <= point.getZ() + radiusZ; ++k) {
                    if (!Utils.checkHeight(world, i, j, k, height, blocks)) continue;
                    BlockPos tempCoords = new BlockPos(i, j, k);
                    double distance = BlockPosUtil.getDistanceSquared(tempCoords, point);
                    if (closestCoords != null && !(distance < minDistance)) continue;
                    closestCoords = tempCoords;
                    minDistance = distance;
                }
            }
        }
        return closestCoords;
    }

    private static boolean checkHeight(@NotNull World world, int x, int y, int z, int height, Block ... blocks) {
        for (int dy = 0; dy < height; ++dy) {
            if (Utils.arrayContains(blocks, world.getBlockState(new BlockPos(x, y + dy, z)).getBlock())) continue;
            return false;
        }
        return true;
    }

    private static boolean arrayContains(@NotNull Object[] array, Object key) {
        for (Object o : array) {
            if (!Objects.equals(key, o)) continue;
            return true;
        }
        return false;
    }

    public static boolean isStackAxe(@Nullable ItemStack stack) {
        return stack != null && stack.getItem().getToolClasses(stack).contains(AXE);
    }

    public static boolean doesItemServeAsWeapon(@NotNull ItemStack stack) {
        return stack.getItem() instanceof ItemSword || stack.getItem() instanceof ItemTool;
    }

    public static boolean isBlockInRange(@NotNull World world, Block block, int posX, int posY, int posZ, int range) {
        for (int x = posX - range; x < posX + range; ++x) {
            for (int z = posZ - range; z < posZ + range; ++z) {
                for (int y = posY - range; y < posY + range; ++y) {
                    if (!Objects.equals(world.getBlockState(new BlockPos(x, y, z)).getBlock(), block)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static int findTopGround(@NotNull World world, int x, int z) {
        int yHolder = 1;
        while (!world.canBlockSeeSky(new BlockPos(x, yHolder, z))) {
            ++yHolder;
        }
        while (!world.getBlockState(new BlockPos(x, yHolder, z)).isOpaqueCube() || Utils.arrayContains(new Block[]{Blocks.AIR, Blocks.LEAVES, Blocks.LEAVES2}, world.getBlockState(new BlockPos(x, yHolder, z)).getBlock())) {
            --yHolder;
        }
        return yHolder;
    }

    public static boolean testFlag(int data, int flag) {
        return Utils.mask(data, flag) == flag;
    }

    public static int mask(int data, int mask) {
        return data & mask;
    }

    public static int setFlag(int data, int flag) {
        return data | flag;
    }

    public static int unsetFlag(int data, int flag) {
        return data & ~flag;
    }

    public static int toggleFlag(int data, int flag) {
        return data ^ flag;
    }

    public static boolean checkIfPickaxeQualifies(int requiredLevel, int toolLevel) {
        return Utils.checkIfPickaxeQualifies(requiredLevel, toolLevel, false);
    }

    public static boolean checkIfPickaxeQualifies(int requiredLevel, int toolLevel, boolean requireEfficientTool) {
        if (requiredLevel < 0) {
            return true;
        }
        if (requireEfficientTool && requiredLevel == 0) {
            return toolLevel >= 0 && toolLevel <= 1;
        }
        return toolLevel >= requiredLevel;
    }

    public static boolean isMiningTool(@Nullable ItemStack itemStack) {
        return Utils.isPickaxe(itemStack) || Utils.isShovel(itemStack);
    }

    public static boolean isShovel(@Nullable ItemStack itemStack) {
        return Utils.isTool(itemStack, SHOVEL);
    }

    public static boolean isHoe(@Nullable ItemStack itemStack) {
        return Utils.isTool(itemStack, HOE);
    }

    public static boolean isTool(@Nullable ItemStack itemStack, String toolType) {
        return Utils.getMiningLevel(itemStack, toolType) >= 0 || itemStack != null && itemStack.getItem() instanceof ItemHoe && HOE.equals(toolType);
    }

    public static int getMiningLevel(@Nullable ItemStack stack, @Nullable String tool) {
        if (tool == null) {
            return stack == null ? 0 : 1;
        }
        if (stack == null) {
            return -1;
        }
        if (!Compatibility.getMiningLevelCompatibility(stack, tool)) {
            return -1;
        }
        return stack.getItem().getHarvestLevel(stack, tool);
    }

    public static boolean isAxe(@Nullable ItemStack itemStack) {
        return Utils.isTool(itemStack, AXE);
    }

    public static boolean isPickaxe(@Nullable ItemStack itemStack) {
        return Utils.isTool(itemStack, PICKAXE);
    }

    public static int getFortuneOf(@Nullable ItemStack tool) {
        if (tool == null) {
            return 0;
        }
        int fortune = 0;
        if (tool.isItemEnchanted()) {
            NBTTagList t = tool.getEnchantmentTagList();
            for (int i = 0; i < t.tagCount(); ++i) {
                short id = t.getCompoundTagAt(i).getShort("id");
                if (id != 35) continue;
                fortune = t.getCompoundTagAt(i).getShort("lvl");
            }
        }
        return fortune;
    }
}

