/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.structures.helpers;

import com.minecolonies.coremod.blocks.ModBlocks;
import com.minecolonies.coremod.util.BlockUtils;
import com.minecolonies.coremod.util.Log;
import com.minecolonies.structures.fake.FakeEntity;
import com.minecolonies.structures.fake.FakeWorld;
import com.minecolonies.structures.lib.ModelHolder;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.model.pipeline.LightUtil;
import net.minecraftforge.fml.common.FMLCommonHandler;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.opengl.GL11;

public class Structure {
    private static final double NINETY_DEGREES = 90.0;
    private static final double TWO_HUNDRED_SEVENTY_DEGREES = 270.0;
    private static final double ONE_HUNDED_EIGHTY_DEGREES = 270.0;
    private static final double SCALE = 1.001;
    private Template template;
    private Minecraft mc;
    private PlacementSettings settings;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Structure(@Nullable World world, String structureName, PlacementSettings settings) {
        InputStream inputstream = MinecraftServer.class.getResourceAsStream("/assets/minecolonies/schematics/" + structureName + ".nbt");
        if (world == null || world.isRemote) {
            this.settings = settings;
            this.mc = Minecraft.getMinecraft();
        }
        if (inputstream == null) {
            try {
                File decorationFolder = FMLCommonHandler.instance().getMinecraftServerInstance() == null ? new File(Minecraft.getMinecraft().mcDataDir, "minecolonies/") : new File(FMLCommonHandler.instance().getMinecraftServerInstance().getDataDirectory(), "minecolonies/");
                if (!decorationFolder.exists()) {
                    throw new FileNotFoundException("Unable to find structure: " + structureName);
                }
                inputstream = new FileInputStream(decorationFolder.getPath() + "/" + structureName + ".nbt");
            }
            catch (FileNotFoundException e) {
                Log.getLogger().warn("Couldn't find any structure with this name anywhere", (Throwable)e);
            }
        }
        if (inputstream == null) {
            return;
        }
        try {
            this.template = Structure.readTemplateFromStream(inputstream);
        }
        catch (IOException e) {
            Log.getLogger().warn(String.format("Failed to load template %s", structureName), (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputstream);
        }
    }

    private static Template readTemplateFromStream(InputStream stream) throws IOException {
        NBTTagCompound nbttagcompound = CompressedStreamTools.readCompressed((InputStream)stream);
        Template template = new Template();
        template.read(nbttagcompound);
        return template;
    }

    public boolean isTemplateMissing() {
        return this.template == null;
    }

    public Template.BlockInfo[] getBlockInfo() {
        Template.BlockInfo[] blockList = new Template.BlockInfo[this.template.blocks.size()];
        blockList = this.template.blocks.toArray(blockList);
        return blockList;
    }

    public Entity[] getEntityInfo(World world, BlockPos pos) {
        Template.EntityInfo[] entityInfoList = new Template.EntityInfo[this.template.entities.size()];
        entityInfoList = this.template.blocks.toArray(entityInfoList);
        Entity[] entityList = null;
        for (int i = 0; i < entityInfoList.length; ++i) {
            Entity finalEntity = EntityList.createEntityFromNBT((NBTTagCompound)entityInfoList[i].entityData, (World)world);
            Vec3d entityVec = entityInfoList[i].pos.add(new Vec3d((Vec3i)pos));
            finalEntity.setPosition(entityVec.xCoord, entityVec.yCoord, entityVec.zCoord);
        }
        return entityList;
    }

    public BlockPos getSize(Rotation rotation) {
        return this.template.transformedSize(rotation);
    }

    public void setPlacementSettings(PlacementSettings settings) {
        this.settings = settings;
    }

    public void renderStructure(@NotNull BlockPos startingPos, @NotNull World clientWorld, @NotNull EntityPlayer player, float partialTicks) {
        Template.BlockInfo[] blockList = this.getBlockInfoWithSettings(this.settings);
        Entity[] entityList = this.getEntityInfoWithSettings(clientWorld, startingPos, this.settings);
        for (Template.BlockInfo blockInfo : blockList) {
            Block block = blockInfo.blockState.getBlock();
            IBlockState iblockstate = blockInfo.blockState;
            if (block == ModBlocks.blockSubstitution) continue;
            if (block == ModBlocks.blockSolidSubstitution) {
                iblockstate = BlockUtils.getSubstitutionBlockAtWorld(clientWorld, startingPos);
                block = iblockstate.getBlock();
            }
            BlockPos blockpos = blockInfo.pos.add((Vec3i)startingPos);
            IBlockState iBlockExtendedState = block.getExtendedState(iblockstate, (IBlockAccess)clientWorld, blockpos);
            IBakedModel ibakedmodel = Minecraft.getMinecraft().getBlockRendererDispatcher().getModelForState(iblockstate);
            TileEntity tileentity = null;
            if (block.hasTileEntity(iblockstate) && blockInfo.tileentityData != null) {
                tileentity = block.createTileEntity(clientWorld, iblockstate);
                tileentity.readFromNBT(blockInfo.tileentityData);
            }
            ModelHolder models = new ModelHolder(blockpos, iblockstate, iBlockExtendedState, tileentity, ibakedmodel);
            Structure.getQuads(models, models.quads);
            this.renderGhost(clientWorld, models, player, partialTicks);
        }
        for (Template.BlockInfo blockInfo : entityList) {
            if (blockInfo == null) continue;
            Minecraft.getMinecraft().getRenderManager().renderEntityStatic((Entity)blockInfo, 0.0f, true);
        }
    }

    public Template.BlockInfo[] getBlockInfoWithSettings(PlacementSettings settings) {
        Template.BlockInfo[] blockList = new Template.BlockInfo[this.template.blocks.size()];
        blockList = this.template.blocks.toArray(blockList);
        for (int i = 0; i < blockList.length; ++i) {
            Template.BlockInfo finalInfo;
            IBlockState finalState = blockList[i].blockState.withMirror(settings.getMirror()).withRotation(settings.getRotation());
            BlockPos finalPos = Template.transformedBlockPos((PlacementSettings)settings, (BlockPos)blockList[i].pos);
            blockList[i] = finalInfo = new Template.BlockInfo(finalPos, finalState, blockList[i].tileentityData);
        }
        return blockList;
    }

    public Template.EntityInfo transformEntityInfoWithSettings(Template.EntityInfo entityInfo, World world, BlockPos pos, PlacementSettings settings) {
        Entity finalEntity = EntityList.createEntityFromNBT((NBTTagCompound)entityInfo.entityData, (World)world);
        Vec3d entityVec = Structure.transformedVec3d(settings, entityInfo.pos).add(new Vec3d((Vec3i)pos));
        if (finalEntity != null) {
            finalEntity.prevRotationYaw = (float)((double)finalEntity.getMirroredYaw(settings.getMirror()) - 90.0);
            double rotationYaw = (double)finalEntity.getMirroredYaw(settings.getMirror()) + ((double)finalEntity.rotationYaw - (double)finalEntity.getRotatedYaw(settings.getRotation()));
            finalEntity.setLocationAndAngles(entityVec.xCoord, entityVec.yCoord, entityVec.zCoord, (float)rotationYaw, finalEntity.rotationPitch);
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            finalEntity.writeToNBTOptional(nbttagcompound);
            return new Template.EntityInfo(entityInfo.pos, entityInfo.blockPos, nbttagcompound);
        }
        return null;
    }

    public double getRotatedYaw(Rotation transformRotation, double previousYaw) {
        switch (transformRotation) {
            case CLOCKWISE_180: {
                return previousYaw + 90.0;
            }
            case COUNTERCLOCKWISE_90: {
                return previousYaw + 270.0;
            }
            case CLOCKWISE_90: {
                return previousYaw + 270.0;
            }
        }
        return previousYaw;
    }

    public Entity[] getEntityInfoWithSettings(World world, BlockPos pos, PlacementSettings settings) {
        Template.EntityInfo[] entityInfoList = new Template.EntityInfo[this.template.entities.size()];
        entityInfoList = this.template.entities.toArray(entityInfoList);
        Entity[] entityList = new Entity[entityInfoList.length];
        for (int i = 0; i < entityInfoList.length; ++i) {
            Entity finalEntity = EntityList.createEntityFromNBT((NBTTagCompound)entityInfoList[i].entityData, (World)world);
            Vec3d entityVec = Structure.transformedVec3d(settings, entityInfoList[i].pos).add(new Vec3d((Vec3i)pos));
            if (finalEntity != null) {
                finalEntity.prevRotationYaw = (float)((double)finalEntity.getMirroredYaw(settings.getMirror()) - 90.0);
                double rotation = (double)finalEntity.getMirroredYaw(settings.getMirror()) + ((double)finalEntity.rotationYaw - (double)finalEntity.getRotatedYaw(settings.getRotation()));
                finalEntity.setLocationAndAngles(entityVec.xCoord, entityVec.yCoord, entityVec.zCoord, (float)rotation, finalEntity.rotationPitch);
            }
            entityList[i] = finalEntity;
        }
        return entityList;
    }

    private static void getQuads(ModelHolder holder, List<BakedQuad> quads) {
        if (holder.actualState.getRenderType() == EnumBlockRenderType.MODEL) {
            BlockRenderLayer originalLayer = MinecraftForgeClient.getRenderLayer();
            for (BlockRenderLayer layer : BlockRenderLayer.values()) {
                if (!holder.actualState.getBlock().canRenderInLayer(holder.actualState, layer)) continue;
                ForgeHooksClient.setRenderLayer((BlockRenderLayer)layer);
                for (EnumFacing facing : EnumFacing.values()) {
                    quads.addAll(holder.model.getQuads(holder.extendedState, facing, 0L));
                }
                quads.addAll(holder.model.getQuads(holder.extendedState, null, 0L));
            }
            ForgeHooksClient.setRenderLayer((BlockRenderLayer)originalLayer);
        }
    }

    private void renderGhost(World world, ModelHolder holder, EntityPlayer player, float partialTicks) {
        boolean existingModel = !this.mc.theWorld.isAirBlock(holder.pos);
        IBlockState actualState = holder.actualState;
        Block block = actualState.getBlock();
        if (actualState.getRenderType() == EnumBlockRenderType.MODEL) {
            BlockRenderLayer originalLayer = MinecraftForgeClient.getRenderLayer();
            for (BlockRenderLayer layer : BlockRenderLayer.values()) {
                if (!block.canRenderInLayer(actualState, layer)) continue;
                this.mc.getTextureManager().bindTexture(TextureMap.LOCATION_BLOCKS_TEXTURE);
                ForgeHooksClient.setRenderLayer((BlockRenderLayer)layer);
                this.renderGhostBlock(world, holder, player, layer, existingModel, partialTicks);
                holder.setRendered(true);
            }
            ForgeHooksClient.setRenderLayer((BlockRenderLayer)originalLayer);
        }
        if (holder.te != null && !holder.isRendered()) {
            TileEntity te = holder.te;
            te.setPos(holder.pos);
            FakeWorld fakeWorld = new FakeWorld(holder.actualState, world.getSaveHandler(), world.getWorldInfo(), world.provider, world.theProfiler, true);
            te.setWorldObj((World)fakeWorld);
            boolean pass = false;
            if (te.shouldRenderInPass(0)) {
                TileEntityRendererDispatcher terd = TileEntityRendererDispatcher.instance;
                terd.func_190056_a((World)fakeWorld, Minecraft.getMinecraft().renderEngine, Minecraft.getMinecraft().fontRendererObj, (Entity)new FakeEntity(fakeWorld), null, 0.0f);
                GL11.glPushMatrix();
                terd.renderEngine = Minecraft.getMinecraft().renderEngine;
                terd.preDrawBatch();
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                terd.renderTileEntity(te, partialTicks, -1);
                terd.drawBatch(0);
                GL11.glPopMatrix();
            }
        }
    }

    public static Vec3d transformedVec3d(PlacementSettings settings, Vec3d vec) {
        Mirror mirrorIn = settings.getMirror();
        Rotation rotationIn = settings.getRotation();
        double xCoord = vec.xCoord;
        double yCoord = vec.yCoord;
        double zCoord = vec.zCoord;
        boolean flag = true;
        switch (mirrorIn) {
            case LEFT_RIGHT: {
                zCoord = 1.0 - zCoord;
                break;
            }
            case FRONT_BACK: {
                xCoord = 1.0 - xCoord;
                break;
            }
            default: {
                flag = false;
            }
        }
        switch (rotationIn) {
            case COUNTERCLOCKWISE_90: {
                return new Vec3d(zCoord, yCoord, 1.0 - xCoord);
            }
            case CLOCKWISE_90: {
                return new Vec3d(1.0 - zCoord, yCoord, xCoord);
            }
            case CLOCKWISE_180: {
                return new Vec3d(1.0 - xCoord, yCoord, 1.0 - zCoord);
            }
        }
        return flag ? new Vec3d(xCoord, yCoord, zCoord) : vec;
    }

    private void renderGhostBlock(World world, ModelHolder holder, EntityPlayer player, BlockRenderLayer layer, boolean existingModel, float partialTicks) {
        double dx = player.lastTickPosX + (player.posX - player.lastTickPosX) * (double)partialTicks;
        double dy = player.lastTickPosY + (player.posY - player.lastTickPosY) * (double)partialTicks;
        double dz = player.lastTickPosZ + (player.posZ - player.lastTickPosZ) * (double)partialTicks;
        BlockPos pos = holder.pos;
        GlStateManager.pushMatrix();
        GlStateManager.translate((double)((double)pos.getX() - dx), (double)((double)pos.getY() - dy), (double)((double)pos.getZ() - dz));
        if (existingModel) {
            GlStateManager.scale((double)1.001, (double)1.001, (double)1.001);
        }
        RenderHelper.disableStandardItemLighting();
        if (layer == BlockRenderLayer.CUTOUT) {
            this.mc.getTextureManager().getTexture(TextureMap.LOCATION_BLOCKS_TEXTURE).setBlurMipmap(false, false);
        }
        GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int alpha = -16777216;
        GlStateManager.enableBlend();
        GlStateManager.enableTexture2D();
        GlStateManager.blendFunc((int)770, (int)771);
        GlStateManager.colorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
        this.renderModel(world, holder, pos, -16777216);
        GlStateManager.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        GlStateManager.depthFunc((int)515);
        this.renderModel(world, holder, pos, -16777216);
        GlStateManager.disableBlend();
        if (layer == BlockRenderLayer.CUTOUT) {
            this.mc.getTextureManager().getTexture(TextureMap.LOCATION_BLOCKS_TEXTURE).restoreLastBlurMipmap();
        }
        GlStateManager.popMatrix();
    }

    private void renderModel(World world, ModelHolder holder, BlockPos pos, int alpha) {
        for (EnumFacing facing : EnumFacing.values()) {
            this.renderQuads(world, holder.actualState, pos, holder.model.getQuads(holder.extendedState, facing, 0L), alpha);
        }
        this.renderQuads(world, holder.actualState, pos, holder.model.getQuads(holder.extendedState, null, 0L), alpha);
    }

    private void renderQuads(World world, IBlockState actualState, BlockPos pos, List<BakedQuad> quads, int alpha) {
        Tessellator tessellator = Tessellator.getInstance();
        VertexBuffer buffer = tessellator.getBuffer();
        for (BakedQuad quad : quads) {
            buffer.begin(7, quad.getFormat());
            int color = quad.hasTintIndex() ? this.getTint(world, actualState, pos, alpha, quad.getTintIndex()) : alpha | 0xFFFFFF;
            LightUtil.renderQuadColor((VertexBuffer)buffer, (BakedQuad)quad, (int)color);
            tessellator.draw();
        }
    }

    private int getTint(World world, IBlockState actualState, BlockPos pos, int alpha, int tintIndex) {
        return alpha | this.mc.getBlockColors().colorMultiplier(actualState, (IBlockAccess)world, pos, tintIndex);
    }

    public List<Template.EntityInfo> getTileEntities() {
        return this.template.entities;
    }

    public PlacementSettings getSettings() {
        return this.settings;
    }
}

