/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.structures.helpers;

import com.minecolonies.coremod.blocks.AbstractBlockHut;
import com.minecolonies.coremod.util.BlockPosUtil;
import com.minecolonies.structures.helpers.Structure;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StructureProxy {
    private final Structure structure;
    private Template.EntityInfo[][][] entities;
    private Template.BlockInfo[][][] blocks;
    private int width;
    private int height;
    private int length;
    private BlockPos offset;

    public StructureProxy(World worldObj, String name) {
        this.structure = new Structure(worldObj, name, new PlacementSettings());
        if (this.structure.isTemplateMissing()) {
            return;
        }
        BlockPos size = this.structure.getSize(Rotation.NONE);
        this.width = size.getX();
        this.height = size.getY();
        this.length = size.getZ();
        this.blocks = new Template.BlockInfo[this.width][this.height][this.length];
        this.entities = new Template.EntityInfo[this.width][this.height][this.length];
        for (Template.BlockInfo info : this.structure.getBlockInfo()) {
            BlockPos tempPos = info.pos;
            this.blocks[tempPos.getX()][tempPos.getY()][tempPos.getZ()] = info;
            this.entities[tempPos.getX()][tempPos.getY()][tempPos.getZ()] = null;
            if (!(info.blockState.getBlock() instanceof AbstractBlockHut)) continue;
            this.offset = info.pos;
        }
        for (Template.EntityInfo info : this.structure.getTileEntities()) {
            BlockPos tempPos = info.blockPos;
            this.entities[tempPos.getX()][tempPos.getY()][tempPos.getZ()] = info;
        }
    }

    public BlockPos getOffset() {
        return this.offset;
    }

    public void setOffset(BlockPos pos) {
        this.offset = pos;
    }

    public String getType() {
        if (this.hasOffset()) {
            return "Hut";
        }
        return "Decoration";
    }

    private boolean hasOffset() {
        return !BlockPosUtil.isEqual(this.offset, 0, 0, 0);
    }

    public Structure getStructure() {
        return this.structure;
    }

    public IBlockState getBlockState(@NotNull BlockPos pos) {
        return this.blocks[pos.getX()][pos.getY()][pos.getZ()].blockState;
    }

    public Template.BlockInfo getBlockInfo(@NotNull BlockPos pos) {
        return this.blocks[pos.getX()][pos.getY()][pos.getZ()];
    }

    public List<Template.EntityInfo> getTileEntities() {
        return this.structure.getTileEntities();
    }

    @Nullable
    public Template.EntityInfo getEntityinfo(@NotNull BlockPos pos) {
        if (this.entities[pos.getX()][pos.getY()].length == 0) {
            return null;
        }
        return this.entities[pos.getX()][pos.getY()][pos.getZ()];
    }

    public int getWidth() {
        return this.width;
    }

    public int getLength() {
        return this.length;
    }

    public int getHeight() {
        return this.height;
    }

    public void rotateWithMirror(int times, World world, BlockPos rotatePos, Mirror mirror) {
        Rotation rotation;
        switch (times) {
            case 1: {
                rotation = Rotation.CLOCKWISE_90;
                break;
            }
            case 2: {
                rotation = Rotation.CLOCKWISE_180;
                break;
            }
            case 3: {
                rotation = Rotation.COUNTERCLOCKWISE_90;
                break;
            }
            default: {
                rotation = Rotation.NONE;
            }
        }
        this.structure.setPlacementSettings(new PlacementSettings().setRotation(rotation).setMirror(mirror));
        BlockPos size = this.structure.getSize(rotation);
        this.width = size.getX();
        this.height = size.getY();
        this.length = size.getZ();
        this.blocks = new Template.BlockInfo[this.width][this.height][this.length];
        this.entities = new Template.EntityInfo[this.width][this.height][this.length];
        int minX = 0;
        int minY = 0;
        int minZ = 0;
        for (Template.BlockInfo info : this.structure.getBlockInfoWithSettings(new PlacementSettings().setRotation(rotation).setMirror(mirror))) {
            BlockPos tempPos = info.pos;
            int x = tempPos.getX();
            int y = tempPos.getY();
            int z = tempPos.getZ();
            if (x < minX) {
                minX = x;
            }
            if (y < minY) {
                minY = y;
            }
            if (z >= minZ) continue;
            minZ = z;
        }
        minX = Math.abs(minX);
        minY = Math.abs(minY);
        minZ = Math.abs(minZ);
        boolean foundHut = false;
        PlacementSettings settings = new PlacementSettings().setRotation(rotation).setMirror(mirror);
        for (Template.BlockInfo info : this.structure.getBlockInfoWithSettings(settings)) {
            BlockPos tempPos = info.pos;
            int x = tempPos.getX() + minX;
            int y = tempPos.getY() + minY;
            int z = tempPos.getZ() + minZ;
            this.blocks[x][y][z] = info;
            this.entities[x][y][z] = null;
            if (!(info.blockState.getBlock() instanceof AbstractBlockHut)) continue;
            foundHut = true;
            this.offset = info.pos.add(minX, minY, minZ);
        }
        this.updateOffSetIfDecoration(foundHut, size, times, minX, minY, minZ);
        for (Template.EntityInfo info : this.structure.getTileEntities()) {
            Template.EntityInfo newInfo = this.structure.transformEntityInfoWithSettings(info, world, rotatePos.subtract((Vec3i)this.offset).add((Vec3i)new BlockPos(minX, minY, minZ)), settings);
            BlockPos tempPos = Template.transformedBlockPos((PlacementSettings)settings, (BlockPos)info.blockPos);
            int x = tempPos.getX() + minX;
            int y = tempPos.getY() + minY;
            int z = tempPos.getZ() + minZ;
            this.entities[x][y][z] = newInfo;
        }
    }

    private void updateOffSetIfDecoration(boolean foundHut, BlockPos size, int rotation, int minX, int minY, int minZ) {
        if (!foundHut) {
            BlockPos tempSize = size;
            if (rotation == 1) {
                tempSize = new BlockPos(-size.getX(), size.getY(), size.getZ());
            }
            if (rotation == 2) {
                tempSize = new BlockPos(-size.getX(), size.getY(), -size.getZ());
            }
            if (rotation == 3) {
                tempSize = new BlockPos(size.getX(), size.getY(), -size.getZ());
            }
            this.offset = new BlockPos(tempSize.getX() / 2, 0, tempSize.getZ() / 2).add(minX, minY, minZ);
        }
    }
}

