/*
 * Decompiled with CFR 0.152.
 */
package com.blockout.views;

import com.blockout.Pane;
import com.blockout.PaneParams;
import com.blockout.View;
import com.blockout.views.ScrollingView;
import net.minecraft.client.renderer.GlStateManager;
import org.jetbrains.annotations.NotNull;

public class ScrollingContainer
extends View {
    private static final int PERCENT_90 = 90;
    private static final int PERCENT_FULL = 100;
    protected ScrollingView owner;
    protected int scrollY = 0;
    protected int contentHeight = 0;

    ScrollingContainer(ScrollingView owner) {
        this.owner = owner;
    }

    @Override
    public void parseChildren(PaneParams params) {
        super.parseChildren(params);
        this.computeContentHeight();
    }

    public void computeContentHeight() {
        this.contentHeight = 0;
        for (Pane child : this.children) {
            this.contentHeight = Math.max(this.contentHeight, child.getY() + child.getHeight());
        }
        this.setScrollY(this.scrollY);
    }

    public int getMaxScrollY() {
        return Math.max(0, this.contentHeight - this.getHeight());
    }

    @Override
    public void drawSelf(int mx, int my) {
        this.scissorsStart();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)0.0f, (float)(-this.scrollY), (float)0.0f);
        super.drawSelf(mx, my + this.scrollY);
        GlStateManager.func_179121_F();
        this.scissorsEnd();
    }

    @Override
    public void click(int mx, int my) {
        super.click(mx, my + this.scrollY);
    }

    @Override
    protected boolean childIsVisible(@NotNull Pane child) {
        return child.getX() < this.getWidth() && child.getY() < this.getHeight() + this.scrollY && child.getX() + child.getWidth() >= 0 && child.getY() + child.getHeight() >= this.scrollY;
    }

    public int getScrollY() {
        return this.scrollY;
    }

    public void setScrollY(int offset) {
        this.scrollY = offset;
        int maxScrollY = this.getMaxScrollY();
        if (this.scrollY > maxScrollY) {
            this.scrollY = maxScrollY;
        }
        if (this.scrollY < 0) {
            this.scrollY = 0;
        }
    }

    public int getContentHeight() {
        return this.contentHeight;
    }

    public int getScrollPageSize() {
        return this.getHeight() * 90 / 100;
    }

    public void scrollBy(int deltaY) {
        this.setScrollY(this.scrollY + deltaY);
    }
}

