/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.client.gui;

import com.blockout.Pane;
import com.blockout.controls.Button;
import com.blockout.controls.Label;
import com.blockout.views.ScrollingList;
import com.blockout.views.Window;
import com.minecolonies.MineColonies;
import com.minecolonies.colony.CitizenDataView;
import com.minecolonies.colony.ColonyView;
import com.minecolonies.colony.buildings.AbstractBuilding;
import com.minecolonies.colony.buildings.AbstractBuildingWorker;
import com.minecolonies.network.messages.HireFireMessage;
import com.minecolonies.util.LanguageHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.jetbrains.annotations.NotNull;

public class WindowHireWorker
extends Window
implements Button.Handler {
    private static final String BUTTON_DONE = "done";
    private static final String BUTTON_CANCEL = "cancel";
    private static final String CITIZEN_LABEL = "citizen";
    private static final String ID_LABEL = "id";
    private static final String CITIZEN_LIST = "unemployed";
    private static final String ATTRIBUTES_LABEL = "attributes";
    private static final String BUILDING_NAME_RESOURCE_SUFFIX = ":gui/windowHireWorker.xml";
    private static final int CITIZEN_ID_LABEL_POSITION = 3;
    private List<CitizenDataView> citizens = new ArrayList<CitizenDataView>();
    private AbstractBuilding.View building;
    private ColonyView colony;

    public WindowHireWorker(ColonyView c, BlockPos buildingId) {
        super("minecolonies:gui/windowHireWorker.xml");
        this.colony = c;
        this.building = this.colony.getBuilding(buildingId);
        this.updateCitizens();
    }

    private void updateCitizens() {
        this.citizens.clear();
        this.citizens.addAll(this.colony.getCitizens().values());
        this.citizens = this.colony.getCitizens().values().stream().filter(citizen -> citizen.getWorkBuilding() == null).collect(Collectors.toList());
    }

    @Override
    public void onOpened() {
        this.updateCitizens();
        ScrollingList citizenList = this.findPaneOfTypeByID(CITIZEN_LIST, ScrollingList.class);
        citizenList.enable();
        citizenList.show();
        citizenList.setDataProvider(new ScrollingList.DataProvider(){

            @Override
            public int getElementCount() {
                return WindowHireWorker.this.citizens.size();
            }

            @Override
            public void updateElement(int index, @NotNull Pane rowPane) {
                CitizenDataView citizen = (CitizenDataView)WindowHireWorker.this.citizens.get(index);
                String attributes = LanguageHandler.format("com.minecolonies.gui.citizen.skills.strength", citizen.getStrength()) + " " + LanguageHandler.format("com.minecolonies.gui.citizen.skills.charisma", citizen.getCharisma()) + " " + LanguageHandler.format("com.minecolonies.gui.citizen.skills.dexterity", citizen.getDexterity()) + " " + LanguageHandler.format("com.minecolonies.gui.citizen.skills.endurance", citizen.getEndurance()) + " " + LanguageHandler.format("com.minecolonies.gui.citizen.skills.intelligence", citizen.getIntelligence());
                rowPane.findPaneOfTypeByID(WindowHireWorker.CITIZEN_LABEL, Label.class).setLabelText(citizen.getName());
                rowPane.findPaneOfTypeByID(WindowHireWorker.ATTRIBUTES_LABEL, Label.class).setLabelText(attributes);
                rowPane.findPaneOfTypeByID(WindowHireWorker.ID_LABEL, Label.class).setLabelText(Integer.toString(citizen.getID()));
            }
        });
    }

    @Override
    public void onUpdate() {
        this.updateCitizens();
        this.window.findPaneOfTypeByID(CITIZEN_LIST, ScrollingList.class).refreshElementPanes();
    }

    @Override
    public void onButtonClicked(@NotNull Button button) {
        if (button.getID().equals(BUTTON_DONE)) {
            Label idLabel = (Label)button.getParent().getChildren().get(3);
            int id = Integer.parseInt(idLabel.getLabelText());
            if (this.building instanceof AbstractBuildingWorker.View) {
                ((AbstractBuildingWorker.View)this.building).setWorkerId(id);
            }
            MineColonies.getNetwork().sendToServer((IMessage)new HireFireMessage(this.building, true, id));
        } else if (!button.getID().equals(BUTTON_CANCEL)) {
            return;
        }
        if (this.colony.getTownHall() != null) {
            this.building.openGui();
        }
    }
}

