/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.colony.buildings;

import com.blockout.views.Window;
import com.minecolonies.achievements.ModAchievements;
import com.minecolonies.client.gui.WindowHutMiner;
import com.minecolonies.colony.CitizenData;
import com.minecolonies.colony.Colony;
import com.minecolonies.colony.ColonyView;
import com.minecolonies.colony.buildings.AbstractBuildingWorker;
import com.minecolonies.colony.jobs.AbstractJob;
import com.minecolonies.colony.jobs.JobMiner;
import com.minecolonies.entity.ai.citizen.miner.Level;
import com.minecolonies.util.BlockPosUtil;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BuildingMiner
extends AbstractBuildingWorker {
    private static final String TAG_FLOOR_BLOCK = "floorBlock";
    private static final String TAG_FENCE_BLOCK = "fenceBlock";
    private static final String TAG_STARTING_LEVEL = "startingLevelShaft";
    private static final String TAG_LEVELS = "levels";
    private static final String TAG_CLEARED = "clearedShaft";
    private static final String TAG_SLOCATION = "shaftLocation";
    private static final String TAG_VECTORX = "vectorx";
    private static final String TAG_VECTORZ = "vectorz";
    private static final String TAG_CLOCATION = "cobblelocation";
    private static final String TAG_ACTIVE = "activeNodeint";
    private static final String TAG_CURRENT_LEVEL = "currentLevel";
    private static final String TAG_SN = "StartingNode";
    private static final String TAG_LLOCATION = "ladderlocation";
    private static final String TAG_LADDER = "found_ladder";
    private static final String TAG_SHAFT_BLOCK = "shaftBlock";
    private static final int MAX_BUILDING_LEVEL = 1;
    private static final String MINER = "Miner";
    private static final IBlockState floorBlock = Blocks.field_150376_bx.func_176223_P().func_177226_a((IProperty)BlockSlab.field_176554_a, (Comparable)BlockSlab.EnumBlockHalf.TOP);
    public boolean clearedShaft = false;
    private Block shaftBlock = Blocks.field_150344_f;
    private Block fenceBlock = Blocks.field_180407_aO;
    private int startingLevelShaft = 0;
    private BlockPos cobbleLocation;
    private int startingLevelNode = 0;
    private int active = 0;
    private int currentLevel = 0;
    private BlockPos shaftStart;
    private int vectorX = 1;
    private int vectorZ = 1;
    private BlockPos ladderLocation;
    private boolean foundLadder = false;
    @NotNull
    private List<Level> levels = new ArrayList<Level>();

    public BuildingMiner(Colony c, BlockPos l) {
        super(c, l);
    }

    @Override
    @NotNull
    public String getSchematicName() {
        return MINER;
    }

    @Override
    public int getMaxBuildingLevel() {
        return 1;
    }

    @Override
    public void onUpgradeComplete(int newLevel) {
        super.onUpgradeComplete(newLevel);
        if (newLevel == 1) {
            this.getColony().triggerAchievement(ModAchievements.achievementBuildingMiner);
        }
        if (newLevel >= this.getMaxBuildingLevel()) {
            this.getColony().triggerAchievement(ModAchievements.achievementUpgradeMinerMax);
        }
    }

    @Override
    @NotNull
    public String getJobName() {
        return MINER;
    }

    @Override
    @NotNull
    public AbstractJob createJob(CitizenData citizen) {
        return new JobMiner(citizen);
    }

    @Override
    public void readFromNBT(@NotNull NBTTagCompound compound) {
        super.readFromNBT(compound);
        if (compound.func_74764_b(TAG_FENCE_BLOCK)) {
            this.fenceBlock = Block.func_149684_b((String)compound.func_74779_i(TAG_FENCE_BLOCK));
        }
        if (compound.func_74764_b(TAG_SHAFT_BLOCK)) {
            this.shaftBlock = Block.func_149684_b((String)compound.func_74779_i(TAG_SHAFT_BLOCK));
        }
        this.startingLevelShaft = compound.func_74762_e(TAG_STARTING_LEVEL);
        this.clearedShaft = compound.func_74767_n(TAG_CLEARED);
        this.vectorX = compound.func_74762_e(TAG_VECTORX);
        this.vectorZ = compound.func_74762_e(TAG_VECTORZ);
        this.active = compound.func_74762_e(TAG_ACTIVE);
        this.currentLevel = compound.func_74762_e(TAG_CURRENT_LEVEL);
        this.ladderLocation = BlockPosUtil.readFromNBT(compound, TAG_LLOCATION);
        this.foundLadder = compound.func_74767_n(TAG_LADDER);
        this.shaftStart = BlockPosUtil.readFromNBT(compound, TAG_SLOCATION);
        this.cobbleLocation = BlockPosUtil.readFromNBT(compound, TAG_CLOCATION);
        this.startingLevelNode = compound.func_74762_e(TAG_SN);
        NBTTagList levelTagList = compound.func_150295_c(TAG_LEVELS, 10);
        for (int i = 0; i < levelTagList.func_74745_c(); ++i) {
            Level level = Level.createFromNBT(levelTagList.func_150305_b(i));
            this.levels.add(level);
        }
    }

    @Override
    public void writeToNBT(@NotNull NBTTagCompound compound) {
        super.writeToNBT(compound);
        compound.func_74778_a(TAG_FENCE_BLOCK, ((ResourceLocation)Block.field_149771_c.func_177774_c((Object)this.fenceBlock)).toString());
        compound.func_74778_a(TAG_FLOOR_BLOCK, ((ResourceLocation)Block.field_149771_c.func_177774_c((Object)this.shaftBlock)).toString());
        compound.func_74768_a(TAG_STARTING_LEVEL, this.startingLevelShaft);
        compound.func_74757_a(TAG_CLEARED, this.clearedShaft);
        compound.func_74768_a(TAG_VECTORX, this.vectorX);
        compound.func_74768_a(TAG_VECTORZ, this.vectorZ);
        compound.func_74768_a(TAG_ACTIVE, this.active);
        compound.func_74768_a(TAG_CURRENT_LEVEL, this.currentLevel);
        compound.func_74757_a(TAG_LADDER, this.foundLadder);
        compound.func_74768_a(TAG_SN, this.startingLevelNode);
        if (this.shaftStart != null && this.cobbleLocation != null) {
            BlockPosUtil.writeToNBT(compound, TAG_SLOCATION, this.shaftStart);
            BlockPosUtil.writeToNBT(compound, TAG_CLOCATION, this.cobbleLocation);
        }
        if (this.ladderLocation != null) {
            BlockPosUtil.writeToNBT(compound, TAG_LLOCATION, this.ladderLocation);
        }
        NBTTagList levelTagList = new NBTTagList();
        for (Level level : this.levels) {
            NBTTagCompound levelCompound = new NBTTagCompound();
            level.writeToNBT(levelCompound);
            levelTagList.func_74742_a((NBTBase)levelCompound);
        }
        compound.func_74782_a(TAG_LEVELS, (NBTBase)levelTagList);
    }

    @Override
    public void serializeToView(@NotNull ByteBuf buf) {
        super.serializeToView(buf);
        buf.writeInt(this.currentLevel);
        buf.writeInt(this.levels.size());
        for (Level level : this.levels) {
            buf.writeInt(level.getNumberOfNodes());
        }
    }

    public void addLevel(Level currentLevel) {
        this.levels.add(currentLevel);
    }

    public int getNumberOfLevels() {
        return this.levels.size();
    }

    @Nullable
    public Level getCurrentLevel() {
        if (this.currentLevel >= 0 && this.currentLevel < this.levels.size()) {
            return this.levels.get(this.currentLevel);
        }
        return null;
    }

    public void setCurrentLevel(int currentLevel) {
        this.currentLevel = currentLevel;
    }

    public int getDepthLimit() {
        if (this.getBuildingLevel() == 1) {
            return 50;
        }
        if (this.getBuildingLevel() == 2) {
            return 30;
        }
        if (this.getBuildingLevel() == 3) {
            return 5;
        }
        return 70;
    }

    public BlockPos getLadderLocation() {
        return this.ladderLocation;
    }

    public void setLadderLocation(BlockPos ladderLocation) {
        this.ladderLocation = ladderLocation;
    }

    public boolean hasFoundLadder() {
        return this.foundLadder;
    }

    public void setFoundLadder(boolean foundLadder) {
        this.foundLadder = foundLadder;
    }

    public int getVectorX() {
        return this.vectorX;
    }

    public void setVectorX(int vectorX) {
        this.vectorX = vectorX;
    }

    public int getVectorZ() {
        return this.vectorZ;
    }

    public void setVectorZ(int vectorZ) {
        this.vectorZ = vectorZ;
    }

    public BlockPos getCobbleLocation() {
        return this.cobbleLocation;
    }

    public void setCobbleLocation(BlockPos pos) {
        this.cobbleLocation = pos;
    }

    public void setShaftStart(BlockPos pos) {
        this.shaftStart = pos;
    }

    public int getStartingLevelShaft() {
        return this.startingLevelShaft;
    }

    public void resetStartingLevelShaft() {
        this.startingLevelShaft = 0;
    }

    public void incrementStartingLevelShaft() {
        ++this.startingLevelShaft;
    }

    public IBlockState getFloorBlock() {
        return floorBlock;
    }

    public Block getShaftBlock() {
        return this.shaftBlock;
    }

    public Block getFenceBlock() {
        return this.fenceBlock;
    }

    public static class View
    extends AbstractBuildingWorker.View {
        public int[] levels;
        public int current;

        public View(ColonyView c, BlockPos l) {
            super(c, l);
        }

        @Override
        @NotNull
        public Window getWindow() {
            return new WindowHutMiner(this);
        }

        @Override
        public void deserialize(@NotNull ByteBuf buf) {
            super.deserialize(buf);
            this.current = buf.readInt();
            int size = buf.readInt();
            this.levels = new int[size];
            for (int i = 0; i < size; ++i) {
                this.levels[i] = buf.readInt();
            }
        }
    }
}

