/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.commands;

import com.minecolonies.colony.Colony;
import com.minecolonies.colony.ColonyManager;
import com.minecolonies.commands.AbstractSingleCommand;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import org.jetbrains.annotations.NotNull;

public class ListColonies
extends AbstractSingleCommand {
    private static final String ID_TEXT = "\u00a72ID: \u00a7f";
    private static final String NAME_TEXT = "\u00a72 Name: \u00a7f";
    private static final String COORDINATES_TEXT = "\u00a72Coordinates: \u00a7f";
    private static final String COORDINATES_XYZ = "\u00a74x=\u00a7f%s \u00a74y=\u00a7f%s \u00a74z=\u00a7f%s";
    private static final String LIST_COMMAND_SUGGESTED = "/mc colonies list ";
    private static final String PAGE_TOP_LEFT = "\u00a72   ------------------ page ";
    private static final String PAGE_TOP_RIGHT = " ------------------";
    private static final String PAGE_TOP_MIDDLE = " of ";
    private static final String PREV_PAGE = " <- prev";
    private static final String NEXT_PAGE = "next -> ";
    private static final String PAGE_LINE = "\u00a72 ----------------";
    private static final String PAGE_LINE_DIVIDER = "\u00a72 | ";
    private static final int COLONIES_ON_PAGE = 9;

    public ListColonies(String ... parents) {
        super(parents);
    }

    @Override
    @NotNull
    public String getCommandUsage(@NotNull ICommandSender sender) {
        return super.getCommandUsage(sender) + "";
    }

    @Override
    public void execute(@NotNull MinecraftServer server, @NotNull ICommandSender sender, String ... args) throws CommandException {
        int page = 1;
        List<Colony> colonies = ColonyManager.getColonies();
        int colonyCount = colonies.size();
        int halfPage = colonyCount % 9 == 0 ? 0 : 1;
        int pageCount = colonyCount / 9 + halfPage;
        if (args.length != 0) {
            try {
                page = Integer.parseInt(args[0]);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if (page < 1 || page > pageCount) {
            page = 1;
        }
        int pageStartIndex = 9 * (page - 1);
        int pageStopIndex = Math.min(9 * page, colonyCount);
        int prevPage = Math.max(0, page - 1);
        int nextPage = Math.min(page + 1, colonyCount / 9 + halfPage);
        List<Object> coloniesPage = pageStartIndex < 0 || pageStartIndex >= colonyCount ? new ArrayList() : colonies.subList(pageStartIndex, pageStopIndex);
        TextComponentString headerLine = new TextComponentString(PAGE_TOP_LEFT + page + PAGE_TOP_MIDDLE + pageCount + PAGE_TOP_RIGHT);
        sender.func_145747_a((ITextComponent)headerLine);
        for (Colony colony : coloniesPage) {
            sender.func_145747_a((ITextComponent)new TextComponentString(ID_TEXT + colony.getID() + NAME_TEXT + colony.getName()));
            BlockPos center = colony.getCenter();
            sender.func_145747_a((ITextComponent)new TextComponentString(COORDINATES_TEXT + String.format(COORDINATES_XYZ, center.func_177958_n(), center.func_177956_o(), center.func_177952_p())));
        }
        ITextComponent prevButton = new TextComponentString(PREV_PAGE).func_150255_a(new Style().func_150227_a(Boolean.valueOf(true)).func_150238_a(TextFormatting.GOLD).func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, LIST_COMMAND_SUGGESTED + prevPage)));
        ITextComponent iTextComponent = new TextComponentString(NEXT_PAGE).func_150255_a(new Style().func_150227_a(Boolean.valueOf(true)).func_150238_a(TextFormatting.GOLD).func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, LIST_COMMAND_SUGGESTED + nextPage)));
        TextComponentString beginLine = new TextComponentString(PAGE_LINE);
        TextComponentString endLine = new TextComponentString(PAGE_LINE);
        sender.func_145747_a(beginLine.func_150257_a(prevButton).func_150257_a((ITextComponent)new TextComponentString(PAGE_LINE_DIVIDER)).func_150257_a(iTextComponent).func_150257_a((ITextComponent)endLine));
    }

    @Override
    @NotNull
    public List<String> getTabCompletionOptions(@NotNull MinecraftServer server, @NotNull ICommandSender sender, @NotNull String[] args, @Nullable BlockPos pos) {
        return new ArrayList<String>();
    }

    @Override
    public boolean isUsernameIndex(@NotNull String[] args, int index) {
        return false;
    }
}

