/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.network.messages;

import com.minecolonies.colony.Schematics;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ColonyStylesMessage
implements IMessage,
IMessageHandler<ColonyStylesMessage, IMessage> {
    private Map<String, List<String>> hutStyleMap;
    private Map<String, List<String>> decorationStyleMap;

    public void fromBytes(@NotNull ByteBuf buf) {
        this.hutStyleMap = ColonyStylesMessage.readStyleMapFromByteBuf(buf);
        this.decorationStyleMap = ColonyStylesMessage.readStyleMapFromByteBuf(buf);
    }

    @NotNull
    private static Map<String, List<String>> readStyleMapFromByteBuf(@NotNull ByteBuf buf) {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        int count = buf.readInt();
        for (int i = 0; i < count; ++i) {
            ArrayList<String> styles = new ArrayList<String>();
            int numStyles = buf.readInt();
            for (int j = 0; j < numStyles; ++j) {
                styles.add(ByteBufUtils.readUTF8String((ByteBuf)buf));
            }
            map.put(ByteBufUtils.readUTF8String((ByteBuf)buf), styles);
        }
        return map;
    }

    public void toBytes(@NotNull ByteBuf buf) {
        ColonyStylesMessage.writeStyleMapToByteBuf(buf, Schematics.getHuts(), Schematics::getStylesForHut);
        ColonyStylesMessage.writeStyleMapToByteBuf(buf, Schematics.getDecorations(), Schematics::getStylesForDecoration);
    }

    private static void writeStyleMapToByteBuf(@NotNull ByteBuf buf, @NotNull Set<String> objects, @NotNull Function<String, List<String>> getStyles) {
        buf.writeInt(objects.size());
        for (String object : objects) {
            List<String> styles = getStyles.apply(object);
            buf.writeInt(styles.size());
            for (String style : styles) {
                ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)style);
            }
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)object);
        }
    }

    @Nullable
    public IMessage onMessage(@NotNull ColonyStylesMessage message, MessageContext ctx) {
        Schematics.setStyles(message.hutStyleMap, message.decorationStyleMap);
        return null;
    }
}

