/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.network.messages;

import com.minecolonies.colony.Colony;
import com.minecolonies.colony.ColonyManager;
import com.minecolonies.colony.buildings.AbstractBuilding;
import com.minecolonies.colony.permissions.Permissions;
import com.minecolonies.network.messages.AbstractMessage;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.jetbrains.annotations.NotNull;

public class WorkOrderChangeMessage
extends AbstractMessage<WorkOrderChangeMessage, IMessage> {
    private int colonyId;
    private int workOrderId;
    private int priority;
    private boolean removeWorkOrder;

    public WorkOrderChangeMessage() {
    }

    public WorkOrderChangeMessage(@NotNull AbstractBuilding.View building, int workOrderId, boolean removeWorkOrder, int priority) {
        this.colonyId = building.getColony().getID();
        this.workOrderId = workOrderId;
        this.removeWorkOrder = removeWorkOrder;
        this.priority = priority;
    }

    public void fromBytes(@NotNull ByteBuf buf) {
        this.colonyId = buf.readInt();
        this.workOrderId = buf.readInt();
        this.priority = buf.readInt();
        this.removeWorkOrder = buf.readBoolean();
    }

    public void toBytes(@NotNull ByteBuf buf) {
        buf.writeInt(this.colonyId);
        buf.writeInt(this.workOrderId);
        buf.writeInt(this.priority);
        buf.writeBoolean(this.removeWorkOrder);
    }

    @Override
    public void messageOnServerThread(WorkOrderChangeMessage message, EntityPlayerMP player) {
        Colony colony = ColonyManager.getColony(message.colonyId);
        if (colony != null && colony.getPermissions().hasPermission((EntityPlayer)player, Permissions.Action.ACCESS_HUTS)) {
            if (!colony.getPermissions().hasPermission((EntityPlayer)player, Permissions.Action.ACCESS_HUTS)) {
                return;
            }
            if (message.removeWorkOrder) {
                colony.getWorkManager().removeWorkOrder(message.workOrderId);
            } else {
                colony.getWorkManager().getWorkOrder(message.workOrderId).setPriority(message.priority);
            }
        }
    }
}

