/*
 * Decompiled with CFR 0.152.
 */
package com.schematica.client.renderer;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.schematica.Settings;
import com.schematica.client.renderer.ViewFrustumOverlay;
import com.schematica.client.renderer.chunk.OverlayRenderDispatcher;
import com.schematica.client.renderer.chunk.container.AbstractSchematicChunkRenderContainer;
import com.schematica.client.renderer.chunk.container.SchematicChunkRenderContainerList;
import com.schematica.client.renderer.chunk.container.SchematicChunkRenderContainerVbo;
import com.schematica.client.renderer.chunk.overlay.ISchematicRenderChunkFactory;
import com.schematica.client.renderer.chunk.overlay.RenderOverlay;
import com.schematica.client.renderer.chunk.overlay.RenderOverlayList;
import com.schematica.client.renderer.chunk.proxy.SchematicRenderChunkList;
import com.schematica.client.renderer.chunk.proxy.SchematicRenderChunkVbo;
import com.schematica.client.renderer.shader.ShaderProgram;
import com.schematica.client.world.SchematicWorld;
import com.schematica.core.client.renderer.GeometryTessellator;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.chunk.ChunkRenderDispatcher;
import net.minecraft.client.renderer.chunk.CompiledChunk;
import net.minecraft.client.renderer.chunk.RenderChunk;
import net.minecraft.client.renderer.chunk.VisGraph;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.culling.ICamera;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.profiler.Profiler;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IWorldEventListener;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.vector.Vector3f;

@SideOnly(value=Side.CLIENT)
public final class RenderSchematic
extends RenderGlobal {
    public static final RenderSchematic INSTANCE = new RenderSchematic(Minecraft.func_71410_x());
    private static final int RENDER_DISTANCE = 32;
    private static final int CHUNKS_XZ = 66;
    private static final int CHUNKS_Y = 16;
    private static final int CHUNKS = 69696;
    private static final int PASS = 2;
    private static final ShaderProgram SHADER_ALPHA = new ShaderProgram("minecolonies", null, "shaders/alpha.frag");
    private static final double DOUBLE_EPSILON = 1.0E-8;
    private static Vec3d playerPositionOffset = new Vec3d(0.0, 0.0, 0.0);
    @NotNull
    private final Minecraft mc;
    private final Profiler profiler;
    private final RenderManager renderManager;
    private final Set<RenderOverlay> overlaysToUpdate = Sets.newLinkedHashSet();
    private final BlockPos.MutableBlockPos tmp = new BlockPos.MutableBlockPos();
    private ChunkRenderDispatcher renderDispatcher = null;
    private OverlayRenderDispatcher renderDispatcherOverlay = null;
    @Nullable
    private SchematicWorld world;
    @NotNull
    private Set<RenderChunk> chunksToUpdate = Sets.newLinkedHashSet();
    @NotNull
    private List<ContainerLocalRenderInformation> renderInfos = Lists.newArrayListWithCapacity((int)69696);
    @Nullable
    private ViewFrustumOverlay viewFrustum = null;
    private double frustumUpdatePosX = Double.MIN_VALUE;
    private double frustumUpdatePosY = Double.MIN_VALUE;
    private double frustumUpdatePosZ = Double.MIN_VALUE;
    private int frustumUpdatePosChunkX = Integer.MIN_VALUE;
    private int frustumUpdatePosChunkY = Integer.MIN_VALUE;
    private int frustumUpdatePosChunkZ = Integer.MIN_VALUE;
    private double lastViewEntityX = Double.MIN_VALUE;
    private double lastViewEntityY = Double.MIN_VALUE;
    private double lastViewEntityZ = Double.MIN_VALUE;
    private double lastViewEntityPitch = Double.MIN_VALUE;
    private double lastViewEntityYaw = Double.MIN_VALUE;
    private AbstractSchematicChunkRenderContainer renderContainer;
    private int renderDistanceChunks = -1;
    private int countEntitiesTotal;
    private int countTileEntitiesTotal;
    private int countTileEntitiesRendered;
    private int countEntitiesRendered;
    private boolean vboEnabled = false;
    private ISchematicRenderChunkFactory renderChunkFactory;
    private double prevRenderSortX;
    private double prevRenderSortY;
    private double prevRenderSortZ;
    private boolean displayListEntitiesDirty = true;
    private int frameCount = 0;

    private RenderSchematic(@NotNull Minecraft minecraft) {
        super(minecraft);
        this.mc = minecraft;
        this.profiler = minecraft.field_71424_I;
        this.renderManager = minecraft.func_175598_ae();
        GlStateManager.func_187421_b((int)3553, (int)10242, (int)10497);
        GlStateManager.func_187421_b((int)3553, (int)10243, (int)10497);
        GlStateManager.func_179144_i((int)0);
        this.vboEnabled = OpenGlHelper.func_176075_f();
        if (this.vboEnabled) {
            this.initVbo();
        } else {
            this.initList();
        }
    }

    private void initVbo() {
        this.renderContainer = new SchematicChunkRenderContainerVbo();
        this.renderChunkFactory = new ISchematicRenderChunkFactory(){

            @NotNull
            public RenderChunk func_189565_a(World world, RenderGlobal renderGlobal, int index) {
                return new SchematicRenderChunkVbo(world, renderGlobal, index);
            }

            @Override
            @NotNull
            public RenderOverlay makeRenderOverlay(World world, RenderGlobal renderGlobal, @NotNull BlockPos pos, int index) {
                return new RenderOverlay(world, renderGlobal, index);
            }
        };
    }

    private void initList() {
        this.renderContainer = new SchematicChunkRenderContainerList();
        this.renderChunkFactory = new ISchematicRenderChunkFactory(){

            @NotNull
            public RenderChunk func_189565_a(World world, RenderGlobal renderGlobal, int index) {
                return new SchematicRenderChunkList(world, renderGlobal, index);
            }

            @Override
            @NotNull
            public RenderOverlay makeRenderOverlay(World world, RenderGlobal renderGlobal, @NotNull BlockPos pos, int index) {
                return new RenderOverlayList(world, renderGlobal, index);
            }
        };
    }

    public void func_110549_a(IResourceManager resourceManager) {
    }

    public void func_174966_b() {
    }

    public void func_174975_c() {
    }

    protected boolean func_174985_d() {
        return false;
    }

    public void func_72732_a(WorldClient worldClient) {
        if (worldClient instanceof SchematicWorld) {
            this.setWorldAndLoadRenderers((SchematicWorld)worldClient);
        } else {
            this.setWorldAndLoadRenderers(null);
        }
    }

    public void setWorldAndLoadRenderers(@Nullable SchematicWorld world) {
        if (this.world != null) {
            this.world.func_72848_b((IWorldEventListener)this);
        }
        this.frustumUpdatePosX = Double.MIN_VALUE;
        this.frustumUpdatePosY = Double.MIN_VALUE;
        this.frustumUpdatePosZ = Double.MIN_VALUE;
        this.frustumUpdatePosChunkX = Integer.MIN_VALUE;
        this.frustumUpdatePosChunkY = Integer.MIN_VALUE;
        this.frustumUpdatePosChunkZ = Integer.MIN_VALUE;
        this.renderManager.func_78717_a((World)world);
        this.world = world;
        if (world != null) {
            world.func_72954_a((IWorldEventListener)this);
            this.func_72712_a();
        } else {
            this.chunksToUpdate.clear();
            this.overlaysToUpdate.clear();
            this.renderInfos.clear();
            if (this.viewFrustum != null) {
                this.viewFrustum.func_178160_a();
            }
            this.viewFrustum = null;
            if (this.renderDispatcher != null) {
                this.renderDispatcher.func_188244_g();
            }
            this.renderDispatcher = null;
            if (this.renderDispatcherOverlay != null) {
                this.renderDispatcherOverlay.func_188244_g();
            }
            this.renderDispatcherOverlay = null;
        }
    }

    public void func_72712_a() {
        if (this.world != null) {
            if (this.renderDispatcher == null) {
                this.renderDispatcher = new ChunkRenderDispatcher();
            }
            if (this.renderDispatcherOverlay == null) {
                this.renderDispatcherOverlay = new OverlayRenderDispatcher();
            }
            this.displayListEntitiesDirty = true;
            this.renderDistanceChunks = 25;
            boolean vbo = this.vboEnabled;
            this.vboEnabled = OpenGlHelper.func_176075_f();
            if (vbo && !this.vboEnabled) {
                this.initList();
            } else if (!vbo && this.vboEnabled) {
                this.initVbo();
            }
            if (this.viewFrustum != null) {
                this.viewFrustum.func_178160_a();
            }
            this.func_174986_e();
            this.viewFrustum = new ViewFrustumOverlay((World)this.world, this.renderDistanceChunks, this, this.renderChunkFactory);
            double posX = RenderSchematic.playerPositionOffset.field_72450_a;
            double posZ = RenderSchematic.playerPositionOffset.field_72449_c;
            this.viewFrustum.func_178163_a(posX, posZ);
        }
    }

    protected void func_174986_e() {
        this.chunksToUpdate.clear();
        this.overlaysToUpdate.clear();
        this.renderDispatcher.func_178514_b();
        this.renderDispatcherOverlay.func_178514_b();
    }

    public void func_72720_a(int p_72720_1_, int p_72720_2_) {
    }

    public void func_180446_a(@NotNull Entity renderViewEntity, @NotNull ICamera camera, float partialTicks) {
        boolean entityPass = false;
        this.profiler.func_76320_a("prepare");
        TileEntityRendererDispatcher.field_147556_a.func_190056_a((World)this.world, this.mc.func_110434_K(), this.mc.field_71466_p, renderViewEntity, this.mc.field_71476_x, partialTicks);
        this.renderManager.func_180597_a((World)this.world, this.mc.field_71466_p, renderViewEntity, this.mc.field_147125_j, this.mc.field_71474_y, partialTicks);
        this.countEntitiesTotal = 0;
        this.countEntitiesRendered = 0;
        this.countTileEntitiesTotal = 0;
        this.countTileEntitiesRendered = 0;
        double x = RenderSchematic.playerPositionOffset.field_72450_a;
        double y = RenderSchematic.playerPositionOffset.field_72448_b;
        double z = RenderSchematic.playerPositionOffset.field_72449_c;
        RenderSchematic.setStaticPlayerPos(x, y, z);
        TileEntityRendererDispatcher.field_147556_a.field_147560_j = x;
        TileEntityRendererDispatcher.field_147556_a.field_147561_k = y;
        TileEntityRendererDispatcher.field_147556_a.field_147558_l = z;
        this.renderManager.func_178628_a(x, y, z);
        this.mc.field_71460_t.func_180436_i();
        this.profiler.func_76318_c("blockentities");
        RenderHelper.func_74519_b();
        TileEntityRendererDispatcher.field_147556_a.preDrawBatch();
        for (ContainerLocalRenderInformation renderInfo : this.renderInfos) {
            for (TileEntity tileEntity : renderInfo.renderChunk.func_178571_g().func_178485_b()) {
                AxisAlignedBB renderBB = tileEntity.getRenderBoundingBox();
                if (!tileEntity.shouldRenderInPass(0) || !camera.func_78546_a(renderBB) || !this.mc.field_71441_e.func_175623_d(tileEntity.func_174877_v().func_177971_a((Vec3i)this.world.position))) continue;
                TileEntityRendererDispatcher.field_147556_a.func_180546_a(tileEntity, partialTicks, -1);
                ++this.countTileEntitiesRendered;
            }
        }
        TileEntityRendererDispatcher.field_147556_a.drawBatch(0);
        this.mc.field_71460_t.func_175072_h();
        this.profiler.func_76319_b();
    }

    public String func_72735_c() {
        int total = this.viewFrustum.field_178164_f.length;
        int rendered = 0;
        for (ContainerLocalRenderInformation renderInfo : this.renderInfos) {
            CompiledChunk compiledChunk = ((ContainerLocalRenderInformation)renderInfo).renderChunk.field_178590_b;
            if (compiledChunk == CompiledChunk.field_178502_a || compiledChunk.func_178489_a()) continue;
            ++rendered;
        }
        return String.format("C: %d/%d %sD: %d, %s", rendered, total, this.mc.field_175612_E ? "(s) " : "", this.renderDistanceChunks, this.renderDispatcher.func_178504_a());
    }

    public String func_72723_d() {
        return String.format("E: %d/%d", this.countEntitiesRendered, this.countEntitiesTotal);
    }

    public void func_174970_a(Entity viewEntity, double partialTicks, @NotNull ICamera camera, int frameCount, boolean playerSpectator) {
        if (25 != this.renderDistanceChunks || this.vboEnabled != OpenGlHelper.func_176075_f()) {
            this.func_72712_a();
        }
        this.profiler.func_76320_a("camera");
        double posX = RenderSchematic.playerPositionOffset.field_72450_a;
        double posY = RenderSchematic.playerPositionOffset.field_72448_b;
        double posZ = RenderSchematic.playerPositionOffset.field_72449_c;
        double deltaX = posX - this.frustumUpdatePosX;
        double deltaY = posY - this.frustumUpdatePosY;
        double deltaZ = posZ - this.frustumUpdatePosZ;
        int chunkCoordX = MathHelper.func_76128_c((double)posX) >> 4;
        int chunkCoordY = MathHelper.func_76128_c((double)posY) >> 4;
        int chunkCoordZ = MathHelper.func_76128_c((double)posZ) >> 4;
        if (this.frustumUpdatePosChunkX != chunkCoordX || this.frustumUpdatePosChunkY != chunkCoordY || this.frustumUpdatePosChunkZ != chunkCoordZ || deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ > 16.0) {
            this.frustumUpdatePosX = posX;
            this.frustumUpdatePosY = posY;
            this.frustumUpdatePosZ = posZ;
            this.frustumUpdatePosChunkX = chunkCoordX;
            this.frustumUpdatePosChunkY = chunkCoordY;
            this.frustumUpdatePosChunkZ = chunkCoordZ;
            this.viewFrustum.func_178163_a(posX, posZ);
        }
        this.profiler.func_76318_c("renderlistcamera");
        this.renderContainer.func_178004_a(posX, posY, posZ);
        this.profiler.func_76318_c("culling");
        BlockPos posEye = new BlockPos(posX, posY + (double)viewEntity.func_70047_e(), posZ);
        RenderChunk renderchunk = this.viewFrustum.func_178161_a(posEye);
        RenderOverlay renderoverlay = this.viewFrustum.getRenderOverlay(posEye);
        this.displayListEntitiesDirty = this.isDisplayListDirty(viewEntity, posX, posY, posZ);
        this.lastViewEntityX = posX;
        this.lastViewEntityY = posY;
        this.lastViewEntityZ = posZ;
        this.lastViewEntityPitch = viewEntity.field_70125_A;
        this.lastViewEntityYaw = viewEntity.field_70177_z;
        this.profiler.func_76318_c("update");
        if (this.displayListEntitiesDirty) {
            this.displayListEntitiesDirty = false;
            this.renderInfos = Lists.newArrayListWithCapacity((int)69696);
            LinkedList renderInfoList = Lists.newLinkedList();
            boolean renderChunksMany = this.mc.field_175612_E;
            if (renderchunk == null) {
                int chunkY = posEye.func_177956_o() > 0 ? 248 : 8;
                for (int chunkX = -this.renderDistanceChunks; chunkX <= this.renderDistanceChunks; ++chunkX) {
                    for (int chunkZ = -this.renderDistanceChunks; chunkZ <= this.renderDistanceChunks; ++chunkZ) {
                        BlockPos pos = new BlockPos((chunkX << 4) + 8, chunkY, (chunkZ << 4) + 8);
                        RenderChunk renderChunk = this.viewFrustum.func_178161_a(pos);
                        RenderOverlay renderOverlay = this.viewFrustum.getRenderOverlay(pos);
                        if (renderChunk == null || !camera.func_78546_a(renderChunk.field_178591_c)) continue;
                        renderChunk.func_178577_a(frameCount);
                        renderOverlay.func_178577_a(frameCount);
                        renderInfoList.add(new ContainerLocalRenderInformation(renderChunk, renderOverlay, null, 0));
                    }
                }
            } else {
                boolean add = false;
                ContainerLocalRenderInformation renderInfo = new ContainerLocalRenderInformation(renderchunk, renderoverlay, null, 0);
                Set<EnumFacing> visibleSides = this.getVisibleSides(posEye);
                if (visibleSides.size() == 1) {
                    Vector3f viewVector = this.func_174962_a(viewEntity, partialTicks);
                    EnumFacing facing = EnumFacing.func_176737_a((float)viewVector.x, (float)viewVector.y, (float)viewVector.z).func_176734_d();
                    visibleSides.remove(facing);
                }
                if (visibleSides.isEmpty()) {
                    add = true;
                }
                if (add && !playerSpectator) {
                    this.renderInfos.add(renderInfo);
                } else {
                    if (playerSpectator && this.world.func_180495_p(posEye).func_185914_p()) {
                        renderChunksMany = false;
                    }
                    renderchunk.func_178577_a(frameCount);
                    renderoverlay.func_178577_a(frameCount);
                    renderInfoList.add(renderInfo);
                }
            }
            this.profiler.func_76320_a("iteration");
            while (!renderInfoList.isEmpty()) {
                ContainerLocalRenderInformation renderInfo = (ContainerLocalRenderInformation)renderInfoList.poll();
                RenderChunk renderChunk = renderInfo.renderChunk;
                EnumFacing facing = renderInfo.facing;
                BlockPos posChunk = renderChunk.func_178568_j();
                this.renderInfos.add(renderInfo);
                for (EnumFacing side : EnumFacing.field_82609_l) {
                    RenderChunk neighborRenderChunk = this.getNeighborRenderChunk(posEye, posChunk, side);
                    RenderOverlay neighborRenderOverlay = this.getNeighborRenderOverlay(posEye, posChunk, side);
                    if (renderChunksMany && renderInfo.setFacing.contains(side.func_176734_d()) || renderChunksMany && facing != null && !renderChunk.func_178571_g().func_178495_a(facing.func_176734_d(), side) || neighborRenderChunk == null || !neighborRenderChunk.func_178577_a(frameCount) || !camera.func_78546_a(neighborRenderChunk.field_178591_c)) continue;
                    ContainerLocalRenderInformation renderInfoNext = new ContainerLocalRenderInformation(neighborRenderChunk, neighborRenderOverlay, side, renderInfo.counter + 1);
                    renderInfoNext.setFacing.addAll(renderInfo.setFacing);
                    renderInfoNext.setFacing.add(side);
                    renderInfoList.add(renderInfoNext);
                }
            }
        }
        this.profiler.func_76318_c("rebuild");
        this.renderDispatcher.func_178513_e();
        this.renderDispatcherOverlay.func_178513_e();
        Set<RenderChunk> set = this.chunksToUpdate;
        Set<RenderOverlay> set1 = this.overlaysToUpdate;
        this.chunksToUpdate = Sets.newLinkedHashSet();
        for (ContainerLocalRenderInformation renderInfo : this.renderInfos) {
            RenderChunk renderChunk = renderInfo.renderChunk;
            RenderOverlay renderOverlay = renderInfo.renderOverlay;
            if (renderChunk.func_178569_m() || set.contains(renderChunk)) {
                this.displayListEntitiesDirty = true;
                this.chunksToUpdate.add(renderChunk);
            }
            if (!renderOverlay.func_178569_m() && !set1.contains((Object)renderOverlay)) continue;
            this.displayListEntitiesDirty = true;
            this.overlaysToUpdate.add(renderOverlay);
        }
        this.chunksToUpdate.addAll(set);
        this.overlaysToUpdate.addAll(set1);
        this.profiler.func_76319_b();
    }

    protected Vector3f func_174962_a(Entity entity, double partialTicks) {
        return super.func_174962_a(entity, partialTicks);
    }

    public int func_174977_a(@NotNull BlockRenderLayer layer, double partialTicks, int pass, Entity entity) {
        RenderHelper.func_74518_a();
        if (layer == BlockRenderLayer.TRANSLUCENT) {
            this.profiler.func_76320_a("translucent_sort");
            double posX = RenderSchematic.playerPositionOffset.field_72450_a;
            double posY = RenderSchematic.playerPositionOffset.field_72448_b;
            double posZ = RenderSchematic.playerPositionOffset.field_72449_c;
            double deltaX = posX - this.prevRenderSortX;
            double deltaY = posY - this.prevRenderSortY;
            double deltaZ = posZ - this.prevRenderSortZ;
            if (deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ > 1.0) {
                this.prevRenderSortX = posX;
                this.prevRenderSortY = posY;
                this.prevRenderSortZ = posZ;
                int count = 0;
                for (ContainerLocalRenderInformation renderInfo : this.renderInfos) {
                    if (((ContainerLocalRenderInformation)renderInfo).renderChunk.field_178590_b.func_178492_d(layer) && count < 15) {
                        this.renderDispatcher.func_178509_c(renderInfo.renderChunk);
                        this.renderDispatcherOverlay.func_178509_c(renderInfo.renderOverlay);
                    }
                    ++count;
                }
            }
            this.profiler.func_76319_b();
        }
        this.profiler.func_76320_a("filterempty");
        int count = 0;
        boolean isTranslucent = layer == BlockRenderLayer.TRANSLUCENT;
        int start = isTranslucent ? this.renderInfos.size() - 1 : 0;
        int end = isTranslucent ? -1 : this.renderInfos.size();
        int step = isTranslucent ? -1 : 1;
        for (int index = start; index != end; index += step) {
            ContainerLocalRenderInformation renderInfo = this.renderInfos.get(index);
            RenderChunk renderChunk = renderInfo.renderChunk;
            RenderOverlay renderOverlay = renderInfo.renderOverlay;
            ++count;
            this.renderContainer.func_178002_a(renderChunk, layer);
            ++count;
            this.renderContainer.addRenderOverlay(renderOverlay);
        }
        this.profiler.func_76318_c("render_" + layer);
        this.renderBlockLayer(layer);
        this.profiler.func_76319_b();
        return count;
    }

    public void func_72734_e() {
    }

    public void func_174976_a(float partialTicks, int pass) {
    }

    public void func_180447_b(float partialTicks, int pass) {
    }

    public boolean func_72721_a(double x, double y, double z, float partialTicks) {
        return false;
    }

    public void func_174967_a(long finishTimeNano) {
        RenderOverlay renderOverlay;
        RenderChunk renderChunk;
        this.displayListEntitiesDirty |= this.renderDispatcher.func_178516_a(finishTimeNano);
        Iterator<RenderChunk> chunkIterator = this.chunksToUpdate.iterator();
        while (chunkIterator.hasNext() && this.renderDispatcher.func_178507_a(renderChunk = chunkIterator.next())) {
            renderChunk.func_178575_a(false);
            chunkIterator.remove();
            long diff = finishTimeNano - System.nanoTime();
            if (diff >= 0L) continue;
            break;
        }
        this.displayListEntitiesDirty |= this.renderDispatcherOverlay.func_178516_a(finishTimeNano);
        Iterator<RenderOverlay> overlayIterator = this.overlaysToUpdate.iterator();
        while (overlayIterator.hasNext() && this.renderDispatcherOverlay.func_178507_a(renderOverlay = overlayIterator.next())) {
            renderOverlay.func_178575_a(false);
            overlayIterator.remove();
            long diff = finishTimeNano - System.nanoTime();
            if (diff >= 0L) continue;
            break;
        }
    }

    public void func_180449_a(Entity entity, float partialTicks) {
    }

    public void func_174981_a(Tessellator tessellator, VertexBuffer VertexBuffer2, Entity entity, float partialTicks) {
    }

    public void func_72731_b(EntityPlayer player, RayTraceResult movingObjectPosition, int p_72731_3_, float partialTicks) {
    }

    public void func_184376_a(World worldIn, BlockPos pos, IBlockState oldState, IBlockState newState, int flags) {
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        this.markBlocksForUpdate(x - 1, y - 1, z - 1, x + 1, y + 1, z + 1, (flags & 8) != 0);
    }

    public void func_174959_b(BlockPos pos) {
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        this.markBlocksForUpdate(x - 1, y - 1, z - 1, x + 1, y + 1, z + 1, true);
    }

    public void func_147585_a(int x1, int y1, int z1, int x2, int y2, int z2) {
        this.markBlocksForUpdate(x1 - 1, y1 - 1, z1 - 1, x2 + 1, y2 + 1, z2 + 1, true);
    }

    public void func_184377_a(@Nullable SoundEvent soundIn, BlockPos pos) {
    }

    public void func_184375_a(@Nullable EntityPlayer player, SoundEvent soundIn, SoundCategory category, double x, double y, double z, float volume, float pitch) {
    }

    public void func_180442_a(int p_180442_1_, boolean p_180442_2_, double p_180442_3_, double p_180442_5_, double p_180442_7_, double p_180442_9_, double p_180442_11_, double p_180442_13_, int ... p_180442_15_) {
    }

    public void func_72703_a(Entity entityIn) {
    }

    public void func_72709_b(Entity entityIn) {
    }

    public void func_72728_f() {
    }

    public void func_180440_a(int p_180440_1_, BlockPos pos, int p_180440_3_) {
    }

    public void func_180439_a(EntityPlayer player, int type, BlockPos blockPosIn, int data) {
    }

    public void func_180441_b(int breakerId, BlockPos pos, int progress) {
    }

    public boolean func_184384_n() {
        return this.chunksToUpdate.isEmpty() && this.renderDispatcher.func_188247_f();
    }

    public void func_174979_m() {
        this.displayListEntitiesDirty = true;
    }

    public void func_181023_a(Collection<TileEntity> tileEntitiesToRemove, Collection<TileEntity> tileEntitiesToAdd) {
    }

    private void markBlocksForUpdate(int x1, int y1, int z1, int x2, int y2, int z2, boolean flag) {
        if (this.world == null) {
            return;
        }
        BlockPos.MutableBlockPos position = this.world.position;
        this.viewFrustum.func_187474_a(x1 - position.func_177958_n(), y1 - position.func_177956_o(), z1 - position.func_177952_p(), x2 - position.func_177958_n(), y2 - position.func_177956_o(), z2 - position.func_177952_p(), flag);
    }

    @SubscribeEvent
    public void onRenderWorldLast(@NotNull RenderWorldLastEvent event) {
        EntityPlayerSP player = this.mc.field_71439_g;
        if (player != null) {
            this.profiler.func_76320_a("schematica");
            boolean isRenderingSchematic = Settings.instance.getActiveSchematic() != null && Settings.instance.getSchematicWorld().isRendering;
            this.profiler.func_76320_a("schematic");
            if (isRenderingSchematic) {
                GlStateManager.func_179094_E();
                this.renderSchematic(Settings.instance.getSchematicWorld(), event.getPartialTicks());
                this.renderSchematic(Settings.instance.getSchematicWorld(), event.getPartialTicks());
                GlStateManager.func_179121_F();
            }
            this.profiler.func_76319_b();
            this.profiler.func_76319_b();
        }
    }

    private synchronized void renderSchematic(SchematicWorld schematic, float partialTicks) {
        if (this.world != schematic) {
            this.world = schematic;
            this.func_72712_a();
        }
        playerPositionOffset = this.mc.field_71439_g.func_174791_d().func_178786_a((double)this.world.position.func_177958_n(), (double)this.world.position.func_177956_o(), (double)this.world.position.func_177952_p());
        if (OpenGlHelper.field_148824_g) {
            // empty if block
        }
        int fps = Math.max(Minecraft.func_175610_ah(), 30);
        this.renderWorld(partialTicks, System.nanoTime() + (long)(1000000000 / fps));
        if (OpenGlHelper.field_148824_g) {
            // empty if block
        }
    }

    private void renderWorld(float partialTicks, long finishTimeNano) {
        GlStateManager.func_179089_o();
        this.profiler.func_76318_c("culling");
        Frustum frustum = new Frustum();
        Entity entity = this.mc.func_175606_aa();
        double x = RenderSchematic.playerPositionOffset.field_72450_a;
        double y = RenderSchematic.playerPositionOffset.field_72448_b;
        double z = RenderSchematic.playerPositionOffset.field_72449_c;
        frustum.func_78547_a(x, y, z);
        GlStateManager.func_179103_j((int)7425);
        this.profiler.func_76318_c("prepareterrain");
        this.mc.func_110434_K().func_110577_a(TextureMap.field_110575_b);
        RenderHelper.func_74518_a();
        this.profiler.func_76318_c("terrain_setup");
        this.func_174970_a(entity, partialTicks, (ICamera)frustum, this.frameCount, this.isInsideWorld(x, y, z));
        ++this.frameCount;
        this.profiler.func_76318_c("updatechunks");
        this.func_174967_a(finishTimeNano / 2L);
        this.profiler.func_76318_c("terrain");
        GlStateManager.func_179128_n((int)5888);
        GlStateManager.func_179094_E();
        GlStateManager.func_179147_l();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        this.func_174977_a(BlockRenderLayer.SOLID, partialTicks, 2, entity);
        this.func_174977_a(BlockRenderLayer.CUTOUT_MIPPED, partialTicks, 2, entity);
        this.mc.func_110434_K().func_110581_b(TextureMap.field_110575_b).func_174936_b(false, false);
        this.func_174977_a(BlockRenderLayer.CUTOUT, partialTicks, 2, entity);
        this.mc.func_110434_K().func_110581_b(TextureMap.field_110575_b).func_174935_a();
        GlStateManager.func_179084_k();
        GlStateManager.func_179103_j((int)7424);
        GlStateManager.func_179092_a((int)516, (float)0.1f);
        GlStateManager.func_179128_n((int)5888);
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        this.profiler.func_76318_c("entities");
        RenderHelper.func_74519_b();
        GlStateManager.func_179147_l();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        this.func_180446_a(entity, (ICamera)frustum, partialTicks);
        GlStateManager.func_179084_k();
        RenderHelper.func_74518_a();
        RenderSchematic.disableLightmap();
        GlStateManager.func_179128_n((int)5888);
        GlStateManager.func_179121_F();
        GlStateManager.func_179089_o();
        GlStateManager.func_179092_a((int)516, (float)0.1f);
        this.mc.func_110434_K().func_110577_a(TextureMap.field_110575_b);
        GlStateManager.func_179103_j((int)7425);
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179094_E();
        this.profiler.func_76318_c("translucent");
        GlStateManager.func_179147_l();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        this.func_174977_a(BlockRenderLayer.TRANSLUCENT, partialTicks, 2, entity);
        GlStateManager.func_179084_k();
        GlStateManager.func_179121_F();
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179103_j((int)7424);
        GlStateManager.func_179089_o();
    }

    private boolean isInsideWorld(double x, double y, double z) {
        return x >= -1.0 && y >= -1.0 && z >= -1.0 && x <= (double)this.world.getWidth() && y <= (double)this.world.func_72800_K() && z <= (double)this.world.getLength();
    }

    private static void disableLightmap() {
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77476_b);
        GlStateManager.func_179090_x();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77478_a);
    }

    private boolean isDisplayListDirty(@NotNull Entity viewEntity, double posX, double posY, double posZ) {
        return this.displayListEntitiesDirty || !this.chunksToUpdate.isEmpty() || this.didEntityMove(posX, posY, posZ) || this.didEntityRotate(viewEntity);
    }

    private Set<EnumFacing> getVisibleSides(@NotNull BlockPos pos) {
        VisGraph visgraph = new VisGraph();
        BlockPos posChunk = new BlockPos(pos.func_177958_n() & 0xFFFFFFF0, pos.func_177956_o() & 0xFFFFFFF0, pos.func_177952_p() & 0xFFFFFFF0);
        for (BlockPos.MutableBlockPos mutableBlockPos : BlockPos.func_177975_b((BlockPos)posChunk, (BlockPos)posChunk.func_177982_a(15, 15, 15))) {
            if (!this.world.func_180495_p((BlockPos)mutableBlockPos).func_185914_p()) continue;
            visgraph.func_178606_a((BlockPos)mutableBlockPos);
        }
        return visgraph.func_178609_b(pos);
    }

    private RenderChunk getNeighborRenderChunk(@NotNull BlockPos posEye, @NotNull BlockPos posChunk, EnumFacing side) {
        BlockPos offset = posChunk.func_177967_a(side, 16);
        if (MathHelper.func_76130_a((int)(posEye.func_177958_n() - offset.func_177958_n())) > this.renderDistanceChunks * 16) {
            return null;
        }
        if (offset.func_177956_o() < 0 || offset.func_177956_o() >= 256) {
            return null;
        }
        if (MathHelper.func_76130_a((int)(posEye.func_177952_p() - offset.func_177952_p())) > this.renderDistanceChunks * 16) {
            return null;
        }
        return this.viewFrustum.func_178161_a(offset);
    }

    private RenderOverlay getNeighborRenderOverlay(@NotNull BlockPos posEye, @NotNull BlockPos posChunk, EnumFacing side) {
        BlockPos offset = posChunk.func_177967_a(side, 16);
        if (MathHelper.func_76130_a((int)(posEye.func_177958_n() - offset.func_177958_n())) > this.renderDistanceChunks * 16) {
            return null;
        }
        if (offset.func_177956_o() < 0 || offset.func_177956_o() >= 256) {
            return null;
        }
        if (MathHelper.func_76130_a((int)(posEye.func_177952_p() - offset.func_177952_p())) > this.renderDistanceChunks * 16) {
            return null;
        }
        return this.viewFrustum.getRenderOverlay(offset);
    }

    private void renderBlockLayer(BlockRenderLayer layer) {
        this.mc.field_71460_t.func_180436_i();
        this.renderContainer.func_178001_a(layer);
        this.mc.field_71460_t.func_175072_h();
    }

    private static void setStaticPlayerPos(double x, double y, double z) {
        TileEntityRendererDispatcher.field_147554_b = x;
        TileEntityRendererDispatcher.field_147555_c = y;
        TileEntityRendererDispatcher.field_147552_d = z;
    }

    private boolean didEntityMove(double posX, double posY, double posZ) {
        return RenderSchematic.doubleEquals(posX, this.lastViewEntityX) || RenderSchematic.doubleEquals(posY, this.lastViewEntityY) || RenderSchematic.doubleEquals(posZ, this.lastViewEntityZ);
    }

    private boolean didEntityRotate(@NotNull Entity viewEntity) {
        return RenderSchematic.doubleEquals(viewEntity.field_70125_A, this.lastViewEntityPitch) || RenderSchematic.doubleEquals(viewEntity.field_70177_z, this.lastViewEntityYaw);
    }

    private static boolean doubleEquals(double d1, double d2) {
        double diff = Math.abs(d1 - d2);
        double nd1 = Math.abs(d1);
        double nd2 = Math.abs(d2);
        double largest = nd2 > nd1 ? nd2 : nd1;
        return diff <= largest * 1.0E-8;
    }

    private void renderOverlay(@NotNull SchematicWorld schematic) {
        GlStateManager.func_179090_x();
        GlStateManager.func_179147_l();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        GL11.glEnable((int)2848);
        GeometryTessellator tessellator = GeometryTessellator.getInstance();
        tessellator.setTranslation(-this.mc.field_71439_g.field_70165_t, -this.mc.field_71439_g.field_70163_u, -this.mc.field_71439_g.field_70161_v);
        tessellator.setDelta(0.005);
        tessellator.beginLines();
        this.tmp.func_181079_c(schematic.position.func_177958_n() + schematic.getWidth() - 1, schematic.position.func_177956_o() + schematic.func_72800_K() - 1, schematic.position.func_177952_p() + schematic.getLength() - 1);
        tessellator.drawCuboid((BlockPos)schematic.position, (BlockPos)this.tmp, 63, 2143223999);
        tessellator.func_78381_a();
        GlStateManager.func_179132_a((boolean)false);
        this.renderContainer.renderOverlay();
        GlStateManager.func_179132_a((boolean)true);
        GL11.glDisable((int)2848);
        GlStateManager.func_179084_k();
        GlStateManager.func_179098_w();
    }

    public void refresh() {
        this.func_72712_a();
    }

    @SideOnly(value=Side.CLIENT)
    private class ContainerLocalRenderInformation {
        private final RenderChunk renderChunk;
        private final RenderOverlay renderOverlay;
        private final EnumFacing facing;
        @NotNull
        private final Set<EnumFacing> setFacing = EnumSet.noneOf(EnumFacing.class);
        private final int counter;

        ContainerLocalRenderInformation(RenderChunk renderChunk, RenderOverlay renderOverlay, EnumFacing facing, int counter) {
            this.renderChunk = renderChunk;
            this.renderOverlay = renderOverlay;
            this.facing = facing;
            this.counter = counter;
        }
    }
}

