/*
 * Decompiled with CFR 0.152.
 */
package com.blockout.controls;

import com.blockout.PaneParams;
import com.blockout.controls.AbstractTextElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.renderer.GlStateManager;

public class Text
extends AbstractTextElement {
    protected String textContent;
    protected List<String> formattedText;
    protected int textHeight;
    protected int linespace = 0;

    public Text() {
    }

    public Text(PaneParams params) {
        super(params);
        this.textContent = params.getLocalizedText();
        this.linespace = params.getIntegerAttribute("linespace", this.linespace);
    }

    @Override
    public void setScale(float s) {
        super.setScale(s);
        this.formattedText = null;
    }

    public String getTextContent() {
        return this.textContent;
    }

    public void setTextContent(String s) {
        this.textContent = s;
        this.formattedText = null;
    }

    public int getLineSpace() {
        return this.linespace;
    }

    public void setLineSpace(int l) {
        this.linespace = l;
    }

    public int getLineHeight() {
        return (int)((double)this.mc.field_71466_p.field_78288_b * this.scale);
    }

    public int getTextHeight() {
        this.getFormattedText();
        return this.textHeight;
    }

    public int getStringWidth(String s) {
        return (int)((double)this.mc.field_71466_p.func_78256_a(s) * this.scale);
    }

    public List<String> getFormattedText() {
        if (this.formattedText == null) {
            this.formattedText = this.textContent == null || this.textContent.length() == 0 ? Collections.unmodifiableList(new ArrayList()) : Collections.unmodifiableList(this.mc.field_71466_p.func_78271_c(this.textContent, (int)((double)this.getWidth() / this.scale)).stream().filter(s -> s != null).collect(Collectors.toList()));
            int numLines = this.formattedText.size();
            if (numLines > 0) {
                int scaledLinespace = (int)((double)this.linespace * this.scale);
                this.textHeight = numLines * (this.getLineHeight() + scaledLinespace) - scaledLinespace;
            } else {
                this.textHeight = 0;
            }
        }
        return this.formattedText;
    }

    @Override
    public void drawSelf(int mx, int my) {
        int scaledLinespace = (int)((double)this.linespace * this.scale);
        int offsetY = 0;
        if (this.textAlignment.isBottomAligned() || this.textAlignment.isVerticalCentered()) {
            int maxVisibleLines = (this.getHeight() + scaledLinespace) / (this.getLineHeight() + scaledLinespace);
            int maxVisibleSize = maxVisibleLines * (this.getLineHeight() + scaledLinespace) - scaledLinespace;
            if (this.getTextHeight() < maxVisibleSize) {
                maxVisibleSize = this.getTextHeight();
            }
            offsetY = Math.max(0, this.getHeight() - maxVisibleSize);
            if (this.textAlignment.isVerticalCentered()) {
                offsetY /= 2;
            }
        }
        for (String s : this.getFormattedText()) {
            int offsetX = 0;
            if (this.textAlignment.isRightAligned() || this.textAlignment.isHorizontalCentered()) {
                offsetX = this.getWidth() - this.getStringWidth(s);
                if (this.textAlignment.isHorizontalCentered()) {
                    offsetX /= 2;
                }
            }
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)(this.getX() + offsetX), (float)(this.getY() + offsetY), (float)0.0f);
            GlStateManager.func_179152_a((float)((float)this.scale), (float)((float)this.scale), (float)((float)this.scale));
            this.mc.field_71446_o.func_110577_a(TEXTURE);
            this.mc.field_71466_p.func_175065_a(s, 0.0f, 0.0f, this.textColor, this.shadow);
            GlStateManager.func_179121_F();
            if ((offsetY += this.getLineHeight() + scaledLinespace) + this.getLineHeight() <= this.getHeight()) continue;
            break;
        }
    }
}

