/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.colony.buildings;

import com.blockout.views.Window;
import com.minecolonies.MineColonies;
import com.minecolonies.achievements.ModAchievements;
import com.minecolonies.client.gui.WindowHutFarmer;
import com.minecolonies.colony.CitizenData;
import com.minecolonies.colony.Colony;
import com.minecolonies.colony.ColonyView;
import com.minecolonies.colony.buildings.AbstractBuildingWorker;
import com.minecolonies.colony.jobs.AbstractJob;
import com.minecolonies.colony.jobs.JobFarmer;
import com.minecolonies.entity.ai.citizen.farmer.Field;
import com.minecolonies.entity.ai.citizen.farmer.FieldView;
import com.minecolonies.network.messages.AssignFieldMessage;
import com.minecolonies.network.messages.AssignmentModeMessage;
import com.minecolonies.tileentities.ScarecrowTileEntity;
import com.minecolonies.util.LanguageHandler;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BuildingFarmer
extends AbstractBuildingWorker {
    private static final String FARMER = "Farmer";
    private static final int MAX_BUILDING_LEVEL = 3;
    private static final String TAG_FIELDS = "fields";
    private static final String TAG_ASSIGN_MANUALLY = "assign";
    private final ArrayList<Field> farmerFields = new ArrayList();
    @Nullable
    private Field currentField;
    private boolean assignManually = false;

    public BuildingFarmer(Colony c, BlockPos l) {
        super(c, l);
    }

    @NotNull
    public List<Field> getFarmerFields() {
        return Collections.unmodifiableList(this.farmerFields);
    }

    public boolean hasNoFields() {
        return this.farmerFields.isEmpty();
    }

    public void addFarmerFields(Field field) {
        this.farmerFields.add(field);
    }

    @Nullable
    public Field getCurrentField() {
        return this.currentField;
    }

    public void setCurrentField(Field currentField) {
        this.currentField = currentField;
    }

    @Nullable
    public Field getFieldToWorkOn() {
        Collections.shuffle(this.farmerFields);
        for (Field field : this.farmerFields) {
            if (!field.needsWork()) continue;
            this.currentField = field;
            return field;
        }
        return null;
    }

    @Override
    @NotNull
    public String getSchematicName() {
        return FARMER;
    }

    @Override
    public int getMaxBuildingLevel() {
        return 3;
    }

    @Override
    @NotNull
    public String getJobName() {
        return FARMER;
    }

    @Override
    @NotNull
    public AbstractJob createJob(@NotNull CitizenData citizen) {
        if (!this.farmerFields.isEmpty()) {
            for (Field field : this.farmerFields) {
                Field colonyField = this.getColony().getField(field.getID());
                if (colonyField != null) {
                    colonyField.setOwner(citizen.getName());
                }
                field.setOwner(citizen.getName());
            }
        }
        return new JobFarmer(citizen);
    }

    @Override
    public void readFromNBT(@NotNull NBTTagCompound compound) {
        super.readFromNBT(compound);
        NBTTagList fieldTagList = compound.func_150295_c(TAG_FIELDS, 10);
        for (int i = 0; i < fieldTagList.func_74745_c(); ++i) {
            NBTTagCompound fieldCompound = fieldTagList.func_150305_b(i);
            Field f = Field.createFromNBT(this.getColony(), fieldCompound);
            if (f == null) continue;
            this.farmerFields.add(f);
        }
        this.assignManually = compound.func_74767_n(TAG_ASSIGN_MANUALLY);
    }

    @Override
    public void writeToNBT(@NotNull NBTTagCompound compound) {
        super.writeToNBT(compound);
        NBTTagList fieldTagList = new NBTTagList();
        for (Field f : this.farmerFields) {
            NBTTagCompound fieldCompound = new NBTTagCompound();
            f.writeToNBT(fieldCompound);
            fieldTagList.func_74742_a((NBTBase)fieldCompound);
        }
        compound.func_74782_a(TAG_FIELDS, (NBTBase)fieldTagList);
        compound.func_74757_a(TAG_ASSIGN_MANUALLY, this.assignManually);
    }

    @Override
    public void onDestroyed() {
        super.onDestroyed();
        for (Field field : this.farmerFields) {
            Field tempField = this.getColony().getField(field.getID());
            if (tempField == null) continue;
            tempField.setTaken(false);
            tempField.setOwner("");
            ScarecrowTileEntity scarecrowTileEntity = (ScarecrowTileEntity)this.getColony().getWorld().func_175625_s(field.getID());
            this.getColony().getWorld().func_184138_a(scarecrowTileEntity.func_174877_v(), this.getColony().getWorld().func_180495_p(scarecrowTileEntity.func_174877_v()), this.getColony().getWorld().func_180495_p(scarecrowTileEntity.func_174877_v()), 3);
            scarecrowTileEntity.setName(LanguageHandler.format("com.minecolonies.gui.scarecrow.user", LanguageHandler.format("com.minecolonies.gui.scarecrow.user.noone", new Object[0])));
        }
    }

    @Override
    public void serializeToView(@NotNull ByteBuf buf) {
        super.serializeToView(buf);
        buf.writeBoolean(this.assignManually);
        int size = 0;
        for (Field field : this.getColony().getFields().values()) {
            if (field.isTaken()) {
                if (this.getWorker() != null && !field.getOwner().equals(this.getWorker().getName())) continue;
                ++size;
                continue;
            }
            ++size;
        }
        buf.writeInt(size);
        for (Field field : this.getColony().getFields().values()) {
            FieldView fieldView;
            if (field.isTaken()) {
                if (this.getWorker() != null && !field.getOwner().equals(this.getWorker().getName())) continue;
                fieldView = new FieldView(field);
                fieldView.serializeViewNetworkData(buf);
                continue;
            }
            fieldView = new FieldView(field);
            fieldView.serializeViewNetworkData(buf);
        }
        if (this.getWorker() == null) {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)"");
        } else {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.getWorker().getName());
        }
    }

    public void syncWithColony(@NotNull World world) {
        if (!this.farmerFields.isEmpty()) {
            ArrayList<Field> tempFields = new ArrayList<Field>(this.farmerFields);
            for (Field field : tempFields) {
                ScarecrowTileEntity scarecrow = (ScarecrowTileEntity)world.func_175625_s(field.getID());
                if (scarecrow == null) {
                    this.farmerFields.remove((Object)field);
                    if (this.currentField == null || this.currentField.getID() != field.getID()) continue;
                    this.currentField = null;
                    continue;
                }
                scarecrow.setName(LanguageHandler.format("com.minecolonies.gui.scarecrow.user", this.getWorker().getName()));
                this.getColony().getWorld().func_184138_a(scarecrow.func_174877_v(), this.getColony().getWorld().func_180495_p(scarecrow.func_174877_v()), this.getColony().getWorld().func_180495_p(scarecrow.func_174877_v()), 3);
                field.setInventoryField(scarecrow.getInventoryField());
                if (this.currentField == null || this.currentField.getID() != field.getID()) continue;
                this.currentField.setInventoryField(scarecrow.getInventoryField());
            }
        }
    }

    public void resetFields() {
        for (Field field : this.farmerFields) {
            field.setNeedsWork(true);
            field.calculateSize(this.getColony().getWorld(), field.getLocation().func_177977_b());
        }
    }

    public boolean assignManually() {
        return this.assignManually;
    }

    public void freeField(BlockPos position) {
        Field tempField = this.farmerFields.stream().filter(field -> field.getID().equals((Object)position)).findFirst().orElse(null);
        if (tempField != null) {
            this.farmerFields.remove((Object)tempField);
            Field field2 = this.getColony().getField(position);
            field2.setTaken(false);
            field2.setOwner("");
            ScarecrowTileEntity scarecrowTileEntity = (ScarecrowTileEntity)this.getColony().getWorld().func_175625_s(field2.getID());
            this.getColony().getWorld().func_184138_a(scarecrowTileEntity.func_174877_v(), this.getColony().getWorld().func_180495_p(scarecrowTileEntity.func_174877_v()), this.getColony().getWorld().func_180495_p(scarecrowTileEntity.func_174877_v()), 3);
            scarecrowTileEntity.setName(LanguageHandler.format("com.minecolonies.gui.scarecrow.user", LanguageHandler.format("com.minecolonies.gui.scarecrow.user.noone", new Object[0])));
        }
    }

    public void assignField(BlockPos position) {
        Field field = this.getColony().getField(position);
        field.setTaken(true);
        field.setOwner(this.getWorker().getName());
        this.farmerFields.add(field);
    }

    public void setAssignManually(boolean assignManually) {
        this.assignManually = assignManually;
    }

    @Override
    public void onUpgradeComplete(int newLevel) {
        super.onUpgradeComplete(newLevel);
        if (newLevel == 1) {
            this.getColony().triggerAchievement(ModAchievements.achievementBuildingFarmer);
        }
        if (newLevel >= this.getMaxBuildingLevel()) {
            this.getColony().triggerAchievement(ModAchievements.achievementUpgradeFarmerMax);
        }
    }

    public static class View
    extends AbstractBuildingWorker.View {
        private boolean assignFieldManually;
        @NotNull
        private List<FieldView> fields = new ArrayList<FieldView>();
        private String workerName;
        private int amountOfFields;

        public View(ColonyView c, BlockPos l) {
            super(c, l);
        }

        @Override
        @NotNull
        public Window getWindow() {
            return new WindowHutFarmer(this);
        }

        @Override
        public void deserialize(@NotNull ByteBuf buf) {
            this.fields = new ArrayList<FieldView>();
            super.deserialize(buf);
            this.assignFieldManually = buf.readBoolean();
            int size = buf.readInt();
            for (int i = 1; i <= size; ++i) {
                FieldView fieldView = new FieldView();
                fieldView.deserialize(buf);
                this.fields.add(fieldView);
                if (!fieldView.isTaken()) continue;
                ++this.amountOfFields;
            }
            this.workerName = ByteBufUtils.readUTF8String((ByteBuf)buf);
        }

        public boolean assignFieldManually() {
            return this.assignFieldManually;
        }

        @NotNull
        public List<FieldView> getFields() {
            return Collections.unmodifiableList(this.fields);
        }

        public String getWorkerName() {
            return this.workerName;
        }

        public int getAmountOfFields() {
            return this.amountOfFields;
        }

        public void setAssignFieldManually(boolean assignFieldManually) {
            MineColonies.getNetwork().sendToServer((IMessage)new AssignmentModeMessage(this, assignFieldManually));
            this.assignFieldManually = assignFieldManually;
        }

        public void changeFields(BlockPos id, boolean addNewField, int row) {
            MineColonies.getNetwork().sendToServer((IMessage)new AssignFieldMessage(this, addNewField, id));
            this.fields.get(row).setTaken(addNewField);
            if (addNewField) {
                this.fields.get(row).setOwner(this.workerName);
                ++this.amountOfFields;
            } else {
                this.fields.get(row).setOwner("");
                --this.amountOfFields;
            }
        }
    }
}

