/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.colony.jobs;

import com.minecolonies.client.render.RenderBipedCitizen;
import com.minecolonies.colony.CitizenData;
import com.minecolonies.colony.buildings.AbstractBuilding;
import com.minecolonies.colony.jobs.AbstractJob;
import com.minecolonies.colony.workorders.WorkOrderBuild;
import com.minecolonies.entity.ai.basic.AbstractAISkeleton;
import com.minecolonies.entity.ai.citizen.builder.EntityAIStructureBuilder;
import com.minecolonies.util.BlockPosUtil;
import com.minecolonies.util.SchematicWrapper;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JobBuilder
extends AbstractJob {
    private static final String TAG_WORK_ORDER = "workorder";
    private static final String TAG_SCHEMATIC = "schematic";
    private static final String TAG_NAME = "name";
    private static final String TAG_POSITION = "position";
    private static final String TAG_PROGRESS = "progress";
    private static final String TAG_STAGE = "stage";
    protected SchematicWrapper schematic;
    private int workOrderId;
    private String schematicName;
    private BlockPos schematicPos;
    private BlockPos schematicProgress;

    public JobBuilder(CitizenData entity) {
        super(entity);
    }

    @Override
    public void readFromNBT(@NotNull NBTTagCompound compound) {
        super.readFromNBT(compound);
        if (compound.func_74764_b(TAG_WORK_ORDER)) {
            this.workOrderId = compound.func_74762_e(TAG_WORK_ORDER);
            if (compound.func_74764_b(TAG_SCHEMATIC)) {
                NBTTagCompound schematicTag = compound.func_74775_l(TAG_SCHEMATIC);
                this.schematicName = schematicTag.func_74779_i(TAG_NAME);
                this.schematicPos = BlockPosUtil.readFromNBT(schematicTag, TAG_POSITION);
                this.schematicProgress = BlockPosUtil.readFromNBT(schematicTag, TAG_PROGRESS);
            }
        }
    }

    @Override
    @NotNull
    public String getName() {
        return "com.minecolonies.job.Builder";
    }

    @Override
    @NotNull
    public RenderBipedCitizen.Model getModel() {
        return RenderBipedCitizen.Model.BUILDER;
    }

    @Override
    public void writeToNBT(@NotNull NBTTagCompound compound) {
        super.writeToNBT(compound);
        if (this.workOrderId != 0) {
            compound.func_74768_a(TAG_WORK_ORDER, this.workOrderId);
            if (this.hasSchematic()) {
                NBTTagCompound schematicTag = new NBTTagCompound();
                schematicTag.func_74778_a(TAG_NAME, this.schematic.getName());
                BlockPosUtil.writeToNBT(schematicTag, TAG_POSITION, this.schematic.getPosition());
                BlockPosUtil.writeToNBT(schematicTag, TAG_PROGRESS, this.schematic.getLocalPosition());
                compound.func_74782_a(TAG_SCHEMATIC, (NBTBase)schematicTag);
            }
        }
    }

    public boolean hasSchematic() {
        return this.schematic != null;
    }

    @Override
    @NotNull
    public AbstractAISkeleton generateAI() {
        return new EntityAIStructureBuilder(this);
    }

    public int getWorkOrderId() {
        return this.workOrderId;
    }

    public boolean hasWorkOrder() {
        return this.workOrderId != 0;
    }

    public SchematicWrapper getSchematic() {
        return this.schematic;
    }

    public void setSchematic(SchematicWrapper schematic) {
        this.schematic = schematic;
    }

    public int getWorkInterval() {
        return 1;
    }

    public void complete() {
        BlockPos buildingLocation = this.getWorkOrder().getBuildingLocation();
        AbstractBuilding building = this.getCitizen().getColony().getBuilding(buildingLocation);
        if (building != null) {
            this.getCitizen().getColony().onBuildingUpgradeComplete(building, this.getWorkOrder().getUpgradeLevel());
        }
        this.getCitizen().getColony().getWorkManager().removeWorkOrder(this.workOrderId);
        this.setWorkOrder(null);
        this.setSchematic(null);
    }

    public WorkOrderBuild getWorkOrder() {
        return this.getColony().getWorkManager().getWorkOrder(this.workOrderId, WorkOrderBuild.class);
    }

    public void setWorkOrder(@Nullable WorkOrderBuild order) {
        this.workOrderId = order == null ? 0 : order.getID();
    }
}

