/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.entity.pathfinding;

import com.minecolonies.configuration.Configurations;
import com.minecolonies.entity.pathfinding.AbstractPathJob;
import com.minecolonies.entity.pathfinding.Node;
import com.minecolonies.util.Log;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.pathfinding.Path;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.opengl.GL11;

public final class Pathfinding {
    private static final BlockingQueue<Runnable> jobQueue = new LinkedBlockingDeque<Runnable>();
    private static final ResourceLocation TEXTURE = new ResourceLocation("textures/gui/widgets.png");
    private static ThreadPoolExecutor executor = new ThreadPoolExecutor(1, Configurations.pathfindingMaxThreadCount, 10L, TimeUnit.SECONDS, jobQueue);

    private Pathfinding() {
    }

    public static Future<Path> enqueue(@NotNull AbstractPathJob job) {
        return executor.submit(job);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SideOnly(value=Side.CLIENT)
    public static void debugDraw(double frame) {
        Set<Node> debugNodesPath;
        Set<Node> debugNodesVisited;
        Set<Node> debugNodesNotVisited;
        if (AbstractPathJob.lastDebugNodesNotVisited == null) {
            return;
        }
        Entity entity = Minecraft.func_71410_x().func_175606_aa();
        double dx = entity.field_70142_S + (entity.field_70165_t - entity.field_70142_S) * frame;
        double dy = entity.field_70137_T + (entity.field_70163_u - entity.field_70137_T) * frame;
        double dz = entity.field_70136_U + (entity.field_70161_v - entity.field_70136_U) * frame;
        GL11.glPushMatrix();
        GL11.glPushAttrib((int)1048575);
        GL11.glTranslated((double)(-dx), (double)(-dy), (double)(-dz));
        GL11.glDisable((int)3553);
        GL11.glDisable((int)3042);
        GL11.glDisable((int)2896);
        GL11.glEnable((int)2884);
        GL11.glEnable((int)2929);
        Iterator<Node> iterator = AbstractPathJob.debugNodeMonitor;
        synchronized (iterator) {
            debugNodesNotVisited = AbstractPathJob.lastDebugNodesNotVisited;
            debugNodesVisited = AbstractPathJob.lastDebugNodesVisited;
            debugNodesPath = AbstractPathJob.lastDebugNodesPath;
        }
        try {
            for (Node n : debugNodesNotVisited) {
                Pathfinding.debugDrawNode(n, (byte)-1, (byte)0, (byte)0);
            }
            for (Node n : debugNodesVisited) {
                Pathfinding.debugDrawNode(n, (byte)0, (byte)0, (byte)-1);
            }
            if (debugNodesPath != null) {
                for (Node n : debugNodesPath) {
                    Pathfinding.debugDrawNode(n, (byte)0, (byte)-1, (byte)0);
                }
            }
        }
        catch (ConcurrentModificationException exc) {
            Log.getLogger().catching((Throwable)exc);
        }
        GL11.glPopAttrib();
        GL11.glPopMatrix();
    }

    @SideOnly(value=Side.CLIENT)
    private static void debugDrawNode(@NotNull Node n, byte r, byte g, byte b) {
        GL11.glPushMatrix();
        GL11.glTranslated((double)((double)n.pos.func_177958_n() + 0.375), (double)((double)n.pos.func_177956_o() + 0.375), (double)((double)n.pos.func_177952_p() + 0.375));
        float f = 1.6f;
        float f1 = (float)(0.016666668 * (double)f / 2.0);
        Entity entity = Minecraft.func_71410_x().func_175606_aa();
        double dx = (double)n.pos.func_177958_n() - entity.field_70165_t;
        double dy = (double)n.pos.func_177956_o() - entity.field_70163_u;
        double dz = (double)n.pos.func_177952_p() - entity.field_70161_v;
        if (Math.sqrt(dx * dx + dy * dy + dz * dz) <= 5.0) {
            Pathfinding.renderDebugText(n, f1);
        }
        GL11.glScaled((double)0.25, (double)0.25, (double)0.25);
        GL11.glBegin((int)7);
        GL11.glColor3ub((byte)r, (byte)g, (byte)b);
        GL11.glVertex3d((double)1.0, (double)0.0, (double)0.0);
        GL11.glVertex3d((double)1.0, (double)1.0, (double)0.0);
        GL11.glVertex3d((double)1.0, (double)1.0, (double)1.0);
        GL11.glVertex3d((double)1.0, (double)0.0, (double)1.0);
        GL11.glVertex3d((double)0.0, (double)0.0, (double)1.0);
        GL11.glVertex3d((double)0.0, (double)1.0, (double)1.0);
        GL11.glVertex3d((double)0.0, (double)1.0, (double)0.0);
        GL11.glVertex3d((double)0.0, (double)0.0, (double)0.0);
        GL11.glVertex3d((double)0.0, (double)0.0, (double)0.0);
        GL11.glVertex3d((double)0.0, (double)1.0, (double)0.0);
        GL11.glVertex3d((double)1.0, (double)1.0, (double)0.0);
        GL11.glVertex3d((double)1.0, (double)0.0, (double)0.0);
        GL11.glVertex3d((double)1.0, (double)0.0, (double)1.0);
        GL11.glVertex3d((double)1.0, (double)1.0, (double)1.0);
        GL11.glVertex3d((double)0.0, (double)1.0, (double)1.0);
        GL11.glVertex3d((double)0.0, (double)0.0, (double)1.0);
        GL11.glVertex3d((double)1.0, (double)1.0, (double)1.0);
        GL11.glVertex3d((double)1.0, (double)1.0, (double)0.0);
        GL11.glVertex3d((double)0.0, (double)1.0, (double)0.0);
        GL11.glVertex3d((double)0.0, (double)1.0, (double)1.0);
        GL11.glVertex3d((double)0.0, (double)0.0, (double)1.0);
        GL11.glVertex3d((double)0.0, (double)0.0, (double)0.0);
        GL11.glVertex3d((double)1.0, (double)0.0, (double)0.0);
        GL11.glVertex3d((double)1.0, (double)0.0, (double)1.0);
        GL11.glEnd();
        if (n.parent != null) {
            GL11.glBegin((int)1);
            GL11.glColor3f((float)0.75f, (float)0.75f, (float)0.75f);
            double pdx = (double)(n.parent.pos.func_177958_n() - n.pos.func_177958_n()) + 0.125;
            double pdy = (double)(n.parent.pos.func_177956_o() - n.pos.func_177956_o()) + 0.125;
            double pdz = (double)(n.parent.pos.func_177952_p() - n.pos.func_177952_p()) + 0.125;
            GL11.glVertex3d((double)0.5, (double)0.5, (double)0.5);
            GL11.glVertex3d((double)(pdx / 0.25), (double)(pdy / 0.25), (double)(pdz / 0.25));
            GL11.glEnd();
        }
        GL11.glPopMatrix();
    }

    @SideOnly(value=Side.CLIENT)
    private static void renderDebugText(@NotNull Node n, float f1) {
        String s1 = String.format("F: %.3f [%d]", n.cost, n.counterAdded);
        String s2 = String.format("G: %.3f [%d]", n.score, n.counterVisited);
        FontRenderer fontrenderer = Minecraft.func_71410_x().field_71466_p;
        GL11.glPushAttrib((int)1048575);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)0.0f, (float)0.75f, (float)0.0f);
        GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
        RenderManager renderManager = Minecraft.func_71410_x().func_175598_ae();
        GL11.glRotatef((float)(-renderManager.field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)renderManager.field_78732_j, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glScalef((float)(-f1), (float)(-f1), (float)f1);
        GL11.glTranslatef((float)0.0f, (float)((float)(0.25 / (double)f1)), (float)0.0f);
        GL11.glDepthMask((boolean)false);
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer VertexBuffer2 = tessellator.func_178180_c();
        GL11.glDisable((int)3553);
        VertexBuffer2.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        int i = Math.max(fontrenderer.func_78256_a(s1), fontrenderer.func_78256_a(s2)) / 2;
        VertexBuffer2.func_181662_b((double)(-i - 1), -5.0, 0.0).func_181666_a(0.0f, 0.0f, 0.0f, 0.25f).func_181675_d();
        VertexBuffer2.func_181662_b((double)(-i - 1), 12.0, 0.0).func_181666_a(0.0f, 0.0f, 0.0f, 0.25f).func_181675_d();
        VertexBuffer2.func_181662_b((double)(i + 1), 12.0, 0.0).func_181666_a(0.0f, 0.0f, 0.0f, 0.25f).func_181675_d();
        VertexBuffer2.func_181662_b((double)(i + 1), -5.0, 0.0).func_181666_a(0.0f, 0.0f, 0.0f, 0.25f).func_181675_d();
        tessellator.func_78381_a();
        GL11.glEnable((int)3553);
        GL11.glEnable((int)3042);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(TEXTURE);
        GL11.glDepthMask((boolean)true);
        GL11.glTranslatef((float)0.0f, (float)-5.0f, (float)0.0f);
        fontrenderer.func_78276_b(s1, -fontrenderer.func_78256_a(s1) / 2, 0, 0x20FFFFFF);
        GL11.glTranslatef((float)0.0f, (float)8.0f, (float)0.0f);
        fontrenderer.func_78276_b(s2, -fontrenderer.func_78256_a(s2) / 2, 0, 0x20FFFFFF);
        GL11.glPopMatrix();
        GL11.glPopAttrib();
    }
}

