/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.event;

import com.minecolonies.blocks.AbstractBlockHut;
import com.minecolonies.blocks.BlockHutTownHall;
import com.minecolonies.colony.ColonyManager;
import com.minecolonies.colony.IColony;
import com.minecolonies.colony.buildings.AbstractBuilding;
import com.minecolonies.colony.permissions.Permissions;
import com.minecolonies.util.LanguageHandler;
import com.minecolonies.util.Log;
import com.minecolonies.util.MathUtils;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.jetbrains.annotations.NotNull;

public class EventHandler {
    @SubscribeEvent
    public void onBlockBreak(@NotNull BlockEvent.BreakEvent event) {
        World world = event.getWorld();
        if (!world.field_72995_K && event.getState().func_177230_c() instanceof AbstractBlockHut) {
            AbstractBuilding building = ColonyManager.getBuilding(world, event.getPos());
            if (building == null) {
                return;
            }
            if (!building.getColony().getPermissions().hasPermission(event.getPlayer(), Permissions.Action.BREAK_HUTS)) {
                event.setCanceled(true);
                return;
            }
            building.destroy();
        }
    }

    @SubscribeEvent
    public void onPlayerInteract(@NotNull PlayerInteractEvent.RightClickBlock event) {
        EntityPlayer player = event.getEntityPlayer();
        World world = event.getWorld();
        if (event.getHand() == EnumHand.MAIN_HAND && !event.getWorld().field_72995_K) {
            if (EventHandler.playerRightClickInteract(player, world, event.getPos()) && world.func_180495_p(event.getPos()).func_177230_c() instanceof AbstractBlockHut) {
                IColony colony = ColonyManager.getIColony(world, event.getPos());
                if (colony != null && !colony.getPermissions().hasPermission(player, Permissions.Action.ACCESS_HUTS)) {
                    event.setCanceled(true);
                }
                return;
            }
            if (player.func_184614_ca() == null || player.func_184614_ca().func_77973_b() == null) {
                return;
            }
            this.handleEventCancellation((PlayerInteractEvent)event, player);
        }
    }

    private static boolean playerRightClickInteract(@NotNull EntityPlayer player, World world, BlockPos pos) {
        return !player.func_70093_af() || player.func_184614_ca() == null || player.func_184614_ca().func_77973_b() == null || player.func_184614_ca().func_77973_b().doesSneakBypassUse(player.func_184614_ca(), (IBlockAccess)world, pos, player);
    }

    private void handleEventCancellation(@NotNull PlayerInteractEvent event, @NotNull EntityPlayer player) {
        Block heldBlock = Block.func_149634_a((Item)player.func_184614_ca().func_77973_b());
        if (heldBlock instanceof AbstractBlockHut) {
            event.setCanceled(!EventHandler.onBlockHutPlaced(event.getWorld(), player, heldBlock, event.getPos().func_177972_a(event.getFace())));
        }
    }

    public static boolean onBlockHutPlaced(@NotNull World world, @NotNull EntityPlayer player, Block block, BlockPos pos) {
        if (block instanceof BlockHutTownHall) {
            return EventHandler.onTownHallPlaced(world, player, pos);
        }
        return EventHandler.onBlockHutPlaced(world, player, pos);
    }

    static boolean onTownHallPlaced(@NotNull World world, @NotNull EntityPlayer player, BlockPos pos) {
        IColony colony = ColonyManager.getIColonyByOwner(world, player);
        if (colony != null) {
            return EventHandler.canOwnerPlaceTownHallHere(world, player, colony, pos);
        }
        colony = ColonyManager.getClosestIColony(world, pos);
        if (colony == null) {
            EventHandler.createColony(world, player, pos);
            return true;
        }
        return EventHandler.canPlayerPlaceTownHallHere(world, player, pos, colony);
    }

    private static boolean onBlockHutPlaced(World world, @NotNull EntityPlayer player, BlockPos pos) {
        IColony colony = ColonyManager.getIColony(world, pos);
        if (colony == null) {
            LanguageHandler.sendPlayerLocalizedMessage(player, "tile.blockHut.messageNoTownHall", new Object[0]);
            return false;
        }
        if (!colony.getPermissions().hasPermission(player, Permissions.Action.PLACE_HUTS)) {
            LanguageHandler.sendPlayerLocalizedMessage(player, "tile.blockHut.messageNoPermission", colony.getName());
            return false;
        }
        return true;
    }

    private static boolean canOwnerPlaceTownHallHere(World world, @NotNull EntityPlayer player, @NotNull IColony colony, BlockPos pos) {
        if (!colony.isCoordInColony(world, pos) || colony.hasTownHall()) {
            LanguageHandler.sendPlayerLocalizedMessage(player, "tile.blockHutTownHall.messagePlacedAlready", new Object[0]);
            return false;
        }
        IColony currentColony = ColonyManager.getIColony(world, pos);
        if (currentColony != colony) {
            LanguageHandler.sendPlayerLocalizedMessage(player, "tile.blockHutTownhall.messageTooFar", new Object[0]);
            return false;
        }
        return true;
    }

    private static void createColony(@NotNull World world, EntityPlayer player, BlockPos pos) {
        if (!world.field_72995_K) {
            ColonyManager.createColony(world, pos, player);
        }
    }

    private static boolean canPlayerPlaceTownHallHere(@NotNull World world, @NotNull EntityPlayer player, BlockPos pos, @NotNull IColony closestColony) {
        if (closestColony.isCoordInColony(world, pos)) {
            if (closestColony.hasTownHall() || !closestColony.getPermissions().isColonyMember(player)) {
                Log.getLogger().info("Can't place at: " + pos.func_177958_n() + "." + pos.func_177956_o() + "." + pos.func_177952_p() + ". Because of townhall of: " + closestColony.getName() + " at " + closestColony.getCenter().func_177958_n() + "." + closestColony.getCenter().func_177956_o() + "." + closestColony.getCenter().func_177952_p());
                LanguageHandler.sendPlayerLocalizedMessage(player, "tile.blockHutTownHall.messageTooClose", new Object[0]);
                return false;
            }
            if (!closestColony.getPermissions().hasPermission(player, Permissions.Action.PLACE_HUTS)) {
                LanguageHandler.sendPlayerLocalizedMessage(player, "tile.blockHut.messageNoPermissionPlace", closestColony.getName());
                return false;
            }
            return true;
        }
        if ((double)closestColony.getDistanceSquared(pos) <= MathUtils.square(ColonyManager.getMinimumDistanceBetweenTownHalls())) {
            Log.getLogger().info("Can't place at: " + pos.func_177958_n() + "." + pos.func_177956_o() + "." + pos.func_177952_p() + ". Because of townhall of: " + closestColony.getName() + " at " + closestColony.getCenter().func_177958_n() + "." + closestColony.getCenter().func_177956_o() + "." + closestColony.getCenter().func_177952_p());
            LanguageHandler.sendPlayerLocalizedMessage(player, "tile.blockHutTownHall.messageTooClose", new Object[0]);
            return false;
        }
        EventHandler.createColony(world, player, pos);
        return true;
    }

    @SubscribeEvent
    public void onWorldLoad(@NotNull WorldEvent.Load event) {
        ColonyManager.onWorldLoad(event.getWorld());
    }

    @SubscribeEvent
    public void onWorldUnload(@NotNull WorldEvent.Unload event) {
        ColonyManager.onWorldUnload(event.getWorld());
    }

    @SubscribeEvent
    public void onWorldSave(@NotNull WorldEvent.Save event) {
        ColonyManager.onWorldSave(event.getWorld());
    }
}

