/*
 * Decompiled with CFR 0.152.
 */
package com.schematica.core.client.renderer;

import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.math.BlockPos;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GeometryTessellator
extends Tessellator {
    @Nullable
    private static GeometryTessellator instance = null;
    private static double deltaS = 0.0;
    private double delta = 0.0;

    private GeometryTessellator() {
        super(0x200000);
    }

    @Nullable
    public static synchronized GeometryTessellator getInstance() {
        if (instance == null) {
            instance = new GeometryTessellator();
        }
        return instance;
    }

    public static void setStaticDelta(double delta) {
        deltaS = delta;
    }

    public static void drawCuboid(@NotNull VertexBuffer VertexBuffer2, @NotNull BlockPos pos, int sides, int argb) {
        GeometryTessellator.drawCuboid(VertexBuffer2, pos, pos, sides, argb);
    }

    private static void drawCuboid(@NotNull VertexBuffer VertexBuffer2, @NotNull BlockPos begin, @NotNull BlockPos end, int sides, int argb) {
        GeometryTessellator.drawCuboid(VertexBuffer2, begin, end, sides, argb, deltaS);
    }

    private static void drawCuboid(@NotNull VertexBuffer VertexBuffer2, @NotNull BlockPos begin, @NotNull BlockPos end, int sides, int argb, double delta) {
        if (VertexBuffer2.func_178979_i() == -1 || sides == 0) {
            return;
        }
        double x0 = (double)begin.func_177958_n() - delta;
        double y0 = (double)begin.func_177956_o() - delta;
        double z0 = (double)begin.func_177952_p() - delta;
        double x1 = (double)(end.func_177958_n() + 1) + delta;
        double y1 = (double)(end.func_177956_o() + 1) + delta;
        double z1 = (double)(end.func_177952_p() + 1) + delta;
        switch (VertexBuffer2.func_178979_i()) {
            case 7: {
                GeometryTessellator.drawQuads(VertexBuffer2, x0, y0, z0, x1, y1, z1, sides, argb);
                break;
            }
            case 1: {
                GeometryTessellator.drawLines(VertexBuffer2, x0, y0, z0, x1, y1, z1, sides, argb);
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported mode!");
            }
        }
    }

    private static void drawQuads(@NotNull VertexBuffer VertexBuffer2, double x0, double y0, double z0, double x1, double y1, double z1, int sides, int argb) {
        int a = argb >>> 24 & 0xFF;
        int r = argb >>> 16 & 0xFF;
        int g = argb >>> 8 & 0xFF;
        int b = argb & 0xFF;
        GeometryTessellator.drawQuads(VertexBuffer2, x0, y0, z0, x1, y1, z1, sides, a, r, g, b);
    }

    private static void drawLines(@NotNull VertexBuffer VertexBuffer2, double x0, double y0, double z0, double x1, double y1, double z1, int sides, int argb) {
        int a = argb >>> 24 & 0xFF;
        int r = argb >>> 16 & 0xFF;
        int g = argb >>> 8 & 0xFF;
        int b = argb & 0xFF;
        GeometryTessellator.drawLines(VertexBuffer2, x0, y0, z0, x1, y1, z1, sides, a, r, g, b);
    }

    private static void drawQuads(@NotNull VertexBuffer VertexBuffer2, double x0, double y0, double z0, double x1, double y1, double z1, int sides, int a, int r, int g, int b) {
        if ((sides & 1) != 0) {
            VertexBuffer2.func_181662_b(x1, y0, z0).func_181669_b(r, g, b, a).func_181675_d();
            VertexBuffer2.func_181662_b(x1, y0, z1).func_181669_b(r, g, b, a).func_181675_d();
            VertexBuffer2.func_181662_b(x0, y0, z1).func_181669_b(r, g, b, a).func_181675_d();
            VertexBuffer2.func_181662_b(x0, y0, z0).func_181669_b(r, g, b, a).func_181675_d();
        }
        if ((sides & 2) != 0) {
            VertexBuffer2.func_181662_b(x1, y1, z0).func_181669_b(r, g, b, a).func_181675_d();
            VertexBuffer2.func_181662_b(x0, y1, z0).func_181669_b(r, g, b, a).func_181675_d();
            VertexBuffer2.func_181662_b(x0, y1, z1).func_181669_b(r, g, b, a).func_181675_d();
            VertexBuffer2.func_181662_b(x1, y1, z1).func_181669_b(r, g, b, a).func_181675_d();
        }
        if ((sides & 4) != 0) {
            VertexBuffer2.func_181662_b(x1, y0, z0).func_181669_b(r, g, b, a).func_181675_d();
            VertexBuffer2.func_181662_b(x0, y0, z0).func_181669_b(r, g, b, a).func_181675_d();
            VertexBuffer2.func_181662_b(x0, y1, z0).func_181669_b(r, g, b, a).func_181675_d();
            VertexBuffer2.func_181662_b(x1, y1, z0).func_181669_b(r, g, b, a).func_181675_d();
        }
        if ((sides & 8) != 0) {
            VertexBuffer2.func_181662_b(x0, y0, z1).func_181669_b(r, g, b, a).func_181675_d();
            VertexBuffer2.func_181662_b(x1, y0, z1).func_181669_b(r, g, b, a).func_181675_d();
            VertexBuffer2.func_181662_b(x1, y1, z1).func_181669_b(r, g, b, a).func_181675_d();
            VertexBuffer2.func_181662_b(x0, y1, z1).func_181669_b(r, g, b, a).func_181675_d();
        }
        if ((sides & 0x10) != 0) {
            VertexBuffer2.func_181662_b(x0, y0, z0).func_181669_b(r, g, b, a).func_181675_d();
            VertexBuffer2.func_181662_b(x0, y0, z1).func_181669_b(r, g, b, a).func_181675_d();
            VertexBuffer2.func_181662_b(x0, y1, z1).func_181669_b(r, g, b, a).func_181675_d();
            VertexBuffer2.func_181662_b(x0, y1, z0).func_181669_b(r, g, b, a).func_181675_d();
        }
        if ((sides & 0x20) != 0) {
            VertexBuffer2.func_181662_b(x1, y0, z1).func_181669_b(r, g, b, a).func_181675_d();
            VertexBuffer2.func_181662_b(x1, y0, z0).func_181669_b(r, g, b, a).func_181675_d();
            VertexBuffer2.func_181662_b(x1, y1, z0).func_181669_b(r, g, b, a).func_181675_d();
            VertexBuffer2.func_181662_b(x1, y1, z1).func_181669_b(r, g, b, a).func_181675_d();
        }
    }

    private static void drawLines(@NotNull VertexBuffer VertexBuffer2, double x0, double y0, double z0, double x1, double y1, double z1, int sides, int a, int r, int g, int b) {
        if ((sides & 0x11) != 0) {
            VertexBuffer2.func_181662_b(x0, y0, z0).func_181669_b(r, g, b, a).func_181675_d();
            VertexBuffer2.func_181662_b(x0, y0, z1).func_181669_b(r, g, b, a).func_181675_d();
        }
        if ((sides & 0x12) != 0) {
            VertexBuffer2.func_181662_b(x0, y1, z0).func_181669_b(r, g, b, a).func_181675_d();
            VertexBuffer2.func_181662_b(x0, y1, z1).func_181669_b(r, g, b, a).func_181675_d();
        }
        if ((sides & 0x21) != 0) {
            VertexBuffer2.func_181662_b(x1, y0, z0).func_181669_b(r, g, b, a).func_181675_d();
            VertexBuffer2.func_181662_b(x1, y0, z1).func_181669_b(r, g, b, a).func_181675_d();
        }
        if ((sides & 0x22) != 0) {
            VertexBuffer2.func_181662_b(x1, y1, z0).func_181669_b(r, g, b, a).func_181675_d();
            VertexBuffer2.func_181662_b(x1, y1, z1).func_181669_b(r, g, b, a).func_181675_d();
        }
        if ((sides & 5) != 0) {
            VertexBuffer2.func_181662_b(x0, y0, z0).func_181669_b(r, g, b, a).func_181675_d();
            VertexBuffer2.func_181662_b(x1, y0, z0).func_181669_b(r, g, b, a).func_181675_d();
        }
        if ((sides & 6) != 0) {
            VertexBuffer2.func_181662_b(x0, y1, z0).func_181669_b(r, g, b, a).func_181675_d();
            VertexBuffer2.func_181662_b(x1, y1, z0).func_181669_b(r, g, b, a).func_181675_d();
        }
        if ((sides & 9) != 0) {
            VertexBuffer2.func_181662_b(x0, y0, z1).func_181669_b(r, g, b, a).func_181675_d();
            VertexBuffer2.func_181662_b(x1, y0, z1).func_181669_b(r, g, b, a).func_181675_d();
        }
        if ((sides & 0xA) != 0) {
            VertexBuffer2.func_181662_b(x0, y1, z1).func_181669_b(r, g, b, a).func_181675_d();
            VertexBuffer2.func_181662_b(x1, y1, z1).func_181669_b(r, g, b, a).func_181675_d();
        }
        if ((sides & 0x14) != 0) {
            VertexBuffer2.func_181662_b(x0, y0, z0).func_181669_b(r, g, b, a).func_181675_d();
            VertexBuffer2.func_181662_b(x0, y1, z0).func_181669_b(r, g, b, a).func_181675_d();
        }
        if ((sides & 0x24) != 0) {
            VertexBuffer2.func_181662_b(x1, y0, z0).func_181669_b(r, g, b, a).func_181675_d();
            VertexBuffer2.func_181662_b(x1, y1, z0).func_181669_b(r, g, b, a).func_181675_d();
        }
        if ((sides & 0x18) != 0) {
            VertexBuffer2.func_181662_b(x0, y0, z1).func_181669_b(r, g, b, a).func_181675_d();
            VertexBuffer2.func_181662_b(x0, y1, z1).func_181669_b(r, g, b, a).func_181675_d();
        }
        if ((sides & 0x28) != 0) {
            VertexBuffer2.func_181662_b(x1, y0, z1).func_181669_b(r, g, b, a).func_181675_d();
            VertexBuffer2.func_181662_b(x1, y1, z1).func_181669_b(r, g, b, a).func_181675_d();
        }
    }

    public void setTranslation(double x, double y, double z) {
        this.func_178180_c().func_178969_c(x, y, z);
    }

    public void beginQuads() {
        this.begin(7);
    }

    private void begin(int mode) {
        this.func_178180_c().func_181668_a(mode, DefaultVertexFormats.field_181706_f);
    }

    public void beginLines() {
        this.begin(1);
    }

    public void setDelta(double delta) {
        this.delta = delta;
    }

    public void drawCuboid(@NotNull BlockPos pos, int sides, int argb) {
        this.drawCuboid(pos, pos, sides, argb);
    }

    public void drawCuboid(@NotNull BlockPos begin, @NotNull BlockPos end, int sides, int argb) {
        GeometryTessellator.drawCuboid(this.func_178180_c(), begin, end, sides, argb, this.delta);
    }
}

