/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.gui;

import com.minecolonies.blockout.controls.Button;
import com.minecolonies.blockout.controls.Label;
import com.minecolonies.blockout.views.SwitchView;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.client.gui.AbstractWindowSkeleton;
import com.minecolonies.coremod.colony.buildings.AbstractBuilding;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingHut;
import com.minecolonies.coremod.network.messages.BuildRequestMessage;
import com.minecolonies.coremod.network.messages.OpenInventoryMessage;
import com.minecolonies.coremod.util.LanguageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractWindowBuilding<B extends AbstractBuildingHut.View>
extends AbstractWindowSkeleton {
    private static final String BUTTON_BUILD = "build";
    private static final String BUTTON_REPAIR = "repair";
    private static final String BUTTON_INVENTORY = "inventory";
    private static final String LABEL_BUILDING_NAME = "name";
    private static final String BUTTON_PREVPAGE = "prevPage";
    private static final String BUTTON_NEXTPAGE = "nextPage";
    private static final String VIEW_PAGES = "pages";
    private final Button buttonPrevPage;
    private final Button buttonNextPage;
    protected final B building;

    public AbstractWindowBuilding(B building, String resource) {
        super(resource);
        this.building = building;
        this.registerButton(BUTTON_BUILD, this::buildClicked);
        this.registerButton(BUTTON_REPAIR, this::repairClicked);
        this.registerButton(BUTTON_INVENTORY, this::inventoryClicked);
        this.buttonNextPage = this.findPaneOfTypeByID(BUTTON_NEXTPAGE, Button.class);
        this.buttonPrevPage = this.findPaneOfTypeByID(BUTTON_PREVPAGE, Button.class);
    }

    private void buildClicked() {
        MineColonies.getNetwork().sendToServer((IMessage)new BuildRequestMessage((AbstractBuilding.View)this.building, 0));
    }

    private void repairClicked() {
        MineColonies.getNetwork().sendToServer((IMessage)new BuildRequestMessage((AbstractBuilding.View)this.building, 1));
    }

    private void inventoryClicked() {
        MineColonies.getNetwork().sendToServer((IMessage)new OpenInventoryMessage((AbstractBuilding.View)this.building));
    }

    @Override
    public void onOpened() {
        if (this.buttonPrevPage != null) {
            this.findPaneOfTypeByID(BUTTON_PREVPAGE, Button.class).setEnabled(false);
        }
        this.findPaneOfTypeByID(LABEL_BUILDING_NAME, Label.class).setLabelText(LanguageHandler.getString(this.getBuildingName()) + " " + ((AbstractBuilding.View)this.building).getBuildingLevel());
        if (((AbstractBuilding.View)this.building).getBuildingLevel() == 0) {
            this.findPaneOfTypeByID(BUTTON_BUILD, Button.class).setLabel(LanguageHandler.getString("com.minecolonies.coremod.gui.workerHuts.build"));
            this.findPaneByID(BUTTON_REPAIR).disable();
        } else if (((AbstractBuilding.View)this.building).isBuildingMaxLevel()) {
            Button button = this.findPaneOfTypeByID(BUTTON_BUILD, Button.class);
            button.setLabel(LanguageHandler.getString("com.minecolonies.coremod.gui.workerHuts.upgradeUnavailable"));
            button.disable();
        }
    }

    @Override
    public void onButtonClicked(@NotNull Button button) {
        switch (button.getID()) {
            case "prevPage": {
                this.findPaneOfTypeByID(VIEW_PAGES, SwitchView.class).previousView();
                this.buttonPrevPage.setEnabled(false);
                this.buttonNextPage.setEnabled(true);
                break;
            }
            case "nextPage": {
                this.findPaneOfTypeByID(VIEW_PAGES, SwitchView.class).nextView();
                this.buttonPrevPage.setEnabled(true);
                this.buttonNextPage.setEnabled(false);
                break;
            }
            default: {
                super.onButtonClicked(button);
            }
        }
    }

    public abstract String getBuildingName();
}

