/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.gui;

import com.minecolonies.blockout.controls.Button;
import com.minecolonies.blockout.views.Window;
import com.minecolonies.coremod.util.Log;
import java.util.HashMap;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractWindowSkeleton
extends Window
implements Button.Handler {
    @NotNull
    private final HashMap<String, Consumer<Button>> buttons = new HashMap();

    public AbstractWindowSkeleton(String resource) {
        super(resource);
    }

    public final void registerButton(String id, Runnable action) {
        this.registerButton(id, (Button button) -> action.run());
    }

    public final void registerButton(String id, Consumer<Button> action) {
        this.buttons.put(id, action);
    }

    @Override
    public void onButtonClicked(@NotNull Button button) {
        if (this.buttons.containsKey(button.getID())) {
            this.buttons.get(button.getID()).accept(button);
        } else {
            Log.getLogger().warn(this.getClass().getName() + ": Unhandled Button ID:" + button.getID());
        }
    }

    public final void doNothing(Button ignored) {
    }
}

