/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.gui;

import com.minecolonies.blockout.Pane;
import com.minecolonies.blockout.controls.Button;
import com.minecolonies.blockout.controls.Label;
import com.minecolonies.blockout.views.ScrollingList;
import com.minecolonies.blockout.views.SwitchView;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.client.gui.AbstractWindowWorkerBuilding;
import com.minecolonies.coremod.colony.buildings.BuildingGuardTower;
import com.minecolonies.coremod.network.messages.GuardScepterMessage;
import com.minecolonies.coremod.network.messages.GuardTaskMessage;
import com.minecolonies.coremod.util.LanguageHandler;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.jetbrains.annotations.NotNull;

public class WindowHutGuardTower
extends AbstractWindowWorkerBuilding<BuildingGuardTower.View> {
    private static final String LIST_LEVELS = "positions";
    private static final String PAGE_ACTIONS = "levelActions";
    private static final String BUTTON_JOB = "job";
    private static final String BUTTON_ASSIGNMENT_MODE = "assign";
    private static final String BUTTON_PATROL_MODE = "patrol";
    private static final String BUTTON_RETRIEVAL_MODE = "retrieve";
    private static final String BUTTON_TASK_PATROL = "patrolling";
    private static final String BUTTON_TASK_FOLLOW = "following";
    private static final String BUTTON_TASK_GUARD = "guarding";
    private static final String BUTTON_SET_TARGET = "setTarget";
    private static final String VIEW_PAGES = "pages";
    private static final String HUT_GUARD_TOWER_RESOURCE_SUFFIX = ":gui/windowHutGuardTower.xml";
    private static final String AUTO = LanguageHandler.format("com.minecolonies.coremod.gui.workerHuts.modeA", new Object[0]);
    private static final String MANUAL = LanguageHandler.format("com.minecolonies.coremod.gui.workerHuts.modeM", new Object[0]);
    private static final String ON = LanguageHandler.format("com.minecolonies.coremod.gui.workerHuts.retrieveOn", new Object[0]);
    private static final String OFF = LanguageHandler.format("com.minecolonies.coremod.gui.workerHuts.retrieveOff", new Object[0]);
    private final Button buttonTaskPatrol;
    private final Button buttonTaskFollow;
    private final Button buttonTaskGuard;
    private final Button buttonSetTarget;
    private boolean assignManually = false;
    private boolean retrieveOnLowHealth = false;
    private boolean patrolManually = false;
    private BuildingGuardTower.Task task = BuildingGuardTower.Task.GUARD;
    private BuildingGuardTower.GuardJob job = null;
    private List<BlockPos> patrolTargets = new ArrayList<BlockPos>();
    private ScrollingList patrolList;

    public WindowHutGuardTower(BuildingGuardTower.View building) {
        super(building, "minecolonies:gui/windowHutGuardTower.xml");
        this.pullInfoFromHut();
        this.registerButton(BUTTON_JOB, this::switchJob);
        this.registerButton(BUTTON_ASSIGNMENT_MODE, this::switchAssignmentMode);
        this.registerButton(BUTTON_PATROL_MODE, this::switchPatrolMode);
        this.registerButton(BUTTON_RETRIEVAL_MODE, this::switchRetrievalMode);
        this.registerButton(BUTTON_TASK_PATROL, this::switchTask);
        this.registerButton(BUTTON_TASK_FOLLOW, this::switchTask);
        this.registerButton(BUTTON_TASK_GUARD, this::switchTask);
        this.registerButton(BUTTON_SET_TARGET, this::setTarget);
        this.buttonTaskPatrol = this.findPaneOfTypeByID(BUTTON_TASK_PATROL, Button.class);
        this.buttonTaskFollow = this.findPaneOfTypeByID(BUTTON_TASK_FOLLOW, Button.class);
        this.buttonTaskGuard = this.findPaneOfTypeByID(BUTTON_TASK_GUARD, Button.class);
        this.buttonSetTarget = this.findPaneOfTypeByID(BUTTON_SET_TARGET, Button.class);
        this.handleButtons();
    }

    private void pullInfoFromHut() {
        this.assignManually = ((BuildingGuardTower.View)this.building).assignManually;
        this.patrolManually = ((BuildingGuardTower.View)this.building).patrolManually;
        this.retrieveOnLowHealth = ((BuildingGuardTower.View)this.building).retrieveOnLowHealth;
        this.task = ((BuildingGuardTower.View)this.building).task;
        this.job = ((BuildingGuardTower.View)this.building).job;
        this.patrolTargets = ((BuildingGuardTower.View)this.building).patrolTargets;
    }

    private void handleButtons() {
        Button buttonJob = this.findPaneOfTypeByID(BUTTON_JOB, Button.class);
        if (this.job != null) {
            if (this.job.equals((Object)BuildingGuardTower.GuardJob.KNIGHT)) {
                buttonJob.setLabel(LanguageHandler.format("com.minecolonies.coremod.gui.workerHuts.knight", new Object[0]));
            } else {
                buttonJob.setLabel(LanguageHandler.format("com.minecolonies.coremod.gui.workerHuts.ranger", new Object[0]));
            }
        }
        buttonJob.setEnabled(this.assignManually);
        this.findPaneOfTypeByID(BUTTON_ASSIGNMENT_MODE, Button.class).setLabel(this.assignManually ? MANUAL : AUTO);
        this.findPaneOfTypeByID(BUTTON_PATROL_MODE, Button.class).setLabel(this.patrolManually ? MANUAL : AUTO);
        this.findPaneOfTypeByID(BUTTON_RETRIEVAL_MODE, Button.class).setLabel(this.retrieveOnLowHealth ? ON : OFF);
        if (this.task.equals((Object)BuildingGuardTower.Task.PATROL)) {
            if (this.patrolManually) {
                this.buttonSetTarget.setEnabled(true);
                this.buttonSetTarget.setLabel(LanguageHandler.format("com.minecolonies.coremod.gui.workerHuts.targetPatrol", new Object[0]));
            } else {
                this.buttonSetTarget.setEnabled(false);
            }
            this.buttonTaskPatrol.setEnabled(false);
        } else if (this.task.equals((Object)BuildingGuardTower.Task.FOLLOW)) {
            this.buttonTaskFollow.setEnabled(false);
            this.buttonSetTarget.hide();
        } else if (this.task.equals((Object)BuildingGuardTower.Task.GUARD)) {
            this.buttonSetTarget.setLabel(LanguageHandler.format("com.minecolonies.coremod.gui.workerHuts.targetGuard", new Object[0]));
            this.buttonTaskGuard.setEnabled(false);
        }
    }

    private void switchTask(Button button) {
        if (button.getID().contains(BUTTON_PATROL_MODE)) {
            ((BuildingGuardTower.View)this.building).task = BuildingGuardTower.Task.PATROL;
            this.buttonTaskPatrol.setEnabled(false);
            this.buttonTaskFollow.setEnabled(true);
            this.buttonTaskGuard.setEnabled(true);
            this.buttonSetTarget.show();
        } else if (button.getID().contains("follow")) {
            ((BuildingGuardTower.View)this.building).task = BuildingGuardTower.Task.FOLLOW;
            this.buttonTaskFollow.setEnabled(false);
            this.buttonTaskPatrol.setEnabled(true);
            this.buttonTaskGuard.setEnabled(true);
            this.buttonSetTarget.hide();
        } else {
            ((BuildingGuardTower.View)this.building).task = BuildingGuardTower.Task.GUARD;
            this.buttonTaskGuard.setEnabled(false);
            this.buttonTaskPatrol.setEnabled(true);
            this.buttonTaskFollow.setEnabled(true);
            this.buttonSetTarget.show();
        }
        this.pullInfoFromHut();
        this.sendChangesToServer();
    }

    private void sendChangesToServer() {
        int ordinal = ((BuildingGuardTower.View)this.building).job == null ? -1 : this.job.ordinal();
        MineColonies.getNetwork().sendToServer((IMessage)new GuardTaskMessage((BuildingGuardTower.View)this.building, ordinal, this.assignManually, this.patrolManually, this.retrieveOnLowHealth, this.task.ordinal()));
    }

    private void setTarget() {
        EntityPlayerSP player = this.mc.field_71439_g;
        int emptySlot = player.field_71071_by.func_70447_i();
        this.pullInfoFromHut();
        if (emptySlot == -1) {
            LanguageHandler.sendPlayerLocalizedMessage((EntityPlayer)player, "com.minecolonies.coremod.gui.workerHuts.noSpace", new Object[0]);
        }
        if (this.patrolManually && this.task.equals((Object)BuildingGuardTower.Task.PATROL)) {
            this.givePlayerScepter(BuildingGuardTower.Task.PATROL);
            LanguageHandler.sendPlayerLocalizedMessage((EntityPlayer)player, "com.minecolonies.coremod.job.guard.tool.taskPatrol", new Object[0]);
        } else if (this.task.equals((Object)BuildingGuardTower.Task.GUARD)) {
            this.givePlayerScepter(BuildingGuardTower.Task.GUARD);
            LanguageHandler.sendPlayerLocalizedMessage((EntityPlayer)player, "com.minecolonies.coremod.job.guard.tool.taskGuard", new Object[0]);
        }
        this.window.close();
    }

    private void givePlayerScepter(BuildingGuardTower.Task localTask) {
        MineColonies.getNetwork().sendToServer((IMessage)new GuardScepterMessage(localTask.ordinal(), ((BuildingGuardTower.View)this.building).getID()));
    }

    private void switchRetrievalMode() {
        ((BuildingGuardTower.View)this.building).retrieveOnLowHealth = !((BuildingGuardTower.View)this.building).retrieveOnLowHealth;
        this.pullInfoFromHut();
        this.sendChangesToServer();
        this.findPaneOfTypeByID(BUTTON_RETRIEVAL_MODE, Button.class).setLabel(this.retrieveOnLowHealth ? ON : OFF);
    }

    private void switchPatrolMode() {
        ((BuildingGuardTower.View)this.building).patrolManually = !((BuildingGuardTower.View)this.building).patrolManually;
        this.pullInfoFromHut();
        this.sendChangesToServer();
        this.handleButtons();
    }

    private void switchJob() {
        ((BuildingGuardTower.View)this.building).job = ((BuildingGuardTower.View)this.building).job == null ? BuildingGuardTower.GuardJob.RANGER : (((BuildingGuardTower.View)this.building).job.equals((Object)BuildingGuardTower.GuardJob.KNIGHT) ? BuildingGuardTower.GuardJob.RANGER : BuildingGuardTower.GuardJob.KNIGHT);
        this.pullInfoFromHut();
        this.sendChangesToServer();
    }

    private void switchAssignmentMode() {
        ((BuildingGuardTower.View)this.building).assignManually = !((BuildingGuardTower.View)this.building).assignManually;
        this.pullInfoFromHut();
        this.sendChangesToServer();
    }

    @Override
    public void onOpened() {
        super.onOpened();
        this.patrolList = this.findPaneOfTypeByID(LIST_LEVELS, ScrollingList.class);
        if (this.task.equals((Object)BuildingGuardTower.Task.PATROL)) {
            this.patrolList.setDataProvider(new ScrollingList.DataProvider(){

                @Override
                public int getElementCount() {
                    return WindowHutGuardTower.this.patrolTargets.size();
                }

                @Override
                public void updateElement(int index, @NotNull Pane rowPane) {
                    BlockPos pos = (BlockPos)WindowHutGuardTower.this.patrolTargets.get(index);
                    rowPane.findPaneOfTypeByID("position", Label.class).setLabelText(pos.func_177958_n() + " " + pos.func_177956_o() + " " + pos.func_177952_p());
                }
            });
        } else if (this.task.equals((Object)BuildingGuardTower.Task.GUARD)) {
            this.patrolList.setDataProvider(new ScrollingList.DataProvider(){

                @Override
                public int getElementCount() {
                    return 1;
                }

                @Override
                public void updateElement(int index, @NotNull Pane rowPane) {
                    BlockPos pos = ((BuildingGuardTower.View)WindowHutGuardTower.this.building).guardPos;
                    rowPane.findPaneOfTypeByID("position", Label.class).setLabelText(pos.func_177958_n() + " " + pos.func_177956_o() + " " + pos.func_177952_p());
                }
            });
        }
    }

    @Override
    public void onUpdate() {
        String currentPage;
        this.pullInfoFromHut();
        this.handleButtons();
        if (!this.task.equals((Object)BuildingGuardTower.Task.PATROL)) {
            this.patrolList.hide();
        }
        if ((currentPage = this.findPaneOfTypeByID(VIEW_PAGES, SwitchView.class).getCurrentView().getID()).equals(PAGE_ACTIONS)) {
            this.pullInfoFromHut();
            this.window.findPaneOfTypeByID(LIST_LEVELS, ScrollingList.class).refreshElementPanes();
        }
    }

    @Override
    @NotNull
    public String getBuildingName() {
        return "com.minecolonies.coremod.gui.workerHuts.GuardTower";
    }
}

