/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings;

import com.minecolonies.coremod.colony.CitizenData;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.ColonyView;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingHut;
import com.minecolonies.coremod.colony.buildings.BuildingBuilder;
import com.minecolonies.coremod.colony.jobs.AbstractJob;
import com.minecolonies.coremod.entity.EntityCitizen;
import io.netty.buffer.ByteBuf;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractBuildingWorker
extends AbstractBuildingHut {
    private static final String TAG_WORKER = "worker";
    private CitizenData worker;

    public AbstractBuildingWorker(@NotNull Colony c, BlockPos l) {
        super(c, l);
    }

    @NotNull
    public abstract String getJobName();

    @NotNull
    public abstract AbstractJob createJob(CitizenData var1);

    public CitizenData getWorker() {
        return this.worker;
    }

    public void setWorker(CitizenData citizen) {
        EntityCitizen tempCitizen;
        if (this.worker == citizen) {
            return;
        }
        if (this.worker != null) {
            tempCitizen = this.worker.getCitizenEntity();
            this.worker.setWorkBuilding(null);
            tempCitizen.setLastJob(this.getJobName());
        }
        this.worker = citizen;
        if (this.worker != null) {
            tempCitizen = citizen.getCitizenEntity();
            if (tempCitizen != null && !tempCitizen.getLastJob().equals(this.getJobName())) {
                citizen.resetExperienceAndLevel();
            }
            this.worker.setWorkBuilding(this);
        }
        this.markDirty();
    }

    @Nullable
    public EntityCitizen getWorkerEntity() {
        if (this.worker == null) {
            return null;
        }
        return this.worker.getCitizenEntity();
    }

    @Override
    public void readFromNBT(@NotNull NBTTagCompound compound) {
        super.readFromNBT(compound);
        if (compound.func_74764_b(TAG_WORKER)) {
            this.worker = this.getColony().getCitizen(compound.func_74762_e(TAG_WORKER));
            if (this.worker != null) {
                this.worker.setWorkBuilding(this);
            }
        }
    }

    @Override
    public void writeToNBT(@NotNull NBTTagCompound compound) {
        super.writeToNBT(compound);
        if (this.worker != null) {
            compound.func_74768_a(TAG_WORKER, this.worker.getId());
        }
    }

    @Override
    public void onDestroyed() {
        if (this.hasWorker()) {
            this.removeCitizen(this.worker);
        }
        super.onDestroyed();
    }

    public boolean hasWorker() {
        return this.worker != null;
    }

    public boolean isWorker(CitizenData citizen) {
        return citizen == this.worker;
    }

    @Override
    public void removeCitizen(CitizenData citizen) {
        if (this.isWorker(citizen)) {
            this.setWorker(null);
        }
    }

    @Override
    public void onWorldTick(@NotNull TickEvent.WorldTickEvent event) {
        CitizenData joblessCitizen;
        super.onWorldTick(event);
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (!(this.hasWorker() || this.getBuildingLevel() <= 0 && !(this instanceof BuildingBuilder) || this.getColony().isManualHiring() || (joblessCitizen = this.getColony().getJoblessCitizen()) == null)) {
            this.setWorker(joblessCitizen);
        }
    }

    @Override
    public void serializeToView(@NotNull ByteBuf buf) {
        super.serializeToView(buf);
        buf.writeInt(this.worker == null ? 0 : this.worker.getId());
    }

    public static class View
    extends AbstractBuildingHut.View {
        private int workerId;

        public View(ColonyView c, @NotNull BlockPos l) {
            super(c, l);
        }

        public int getWorkerId() {
            return this.workerId;
        }

        public void setWorkerId(int workerId) {
            this.workerId = workerId;
        }

        @Override
        public void deserialize(@NotNull ByteBuf buf) {
            super.deserialize(buf);
            this.workerId = buf.readInt();
        }
    }
}

